/* mscio.h */

/* header file for MSC specific IO & BIOS calls */
/* Copyright 1992, Robert C. Becker, Lantern Systems */

#ifndef MSCIO

#define		VIDEO		0x10	/* BIOS video int. */
#define		WRT_PIX		0x0c	/* BIOS write pixel request */
#define		SET_MODE	0	/* BIOS set video mode: al = video mode */
#define		VIDEO_STATE	0x0f	/* BIOS read video state */
#define		SET_COLOR	0x0b	/* setup color pallate request */

#define		MOUSE_D		0x33	/* mouse driver interrupt vector */
#define 	M_RESET		0	/* reset mouse */
#define 	M_SHO_CUR	1	/* show cursor */
#define 	M_HID_CUR	2	/* hide cursor */
#define 	M_GET_POS	3	/* get current cursor position (in pixels) */
#define 	M_SET_POS	4	/* set cursor position (in pixels ) */
#define 	M_GET_BTNS	5	/* get button press info */
#define		M_MAX_MIN_X	7	/* set max & min x position (in pixels) */
#define		M_MAX_MIN_Y	8	/* set max & min y position (in pixels) */
#define		M_DEF_CURS	9	/* define graphics cursor shape & reference point */

#define		RT_ARROW	0x4d00
#define		LF_ARROW	0x4b00
#define		UP_ARROW	0x4800
#define		DN_ARROW	0x5000	/* cursor key values returned by _bios_keybrd (_KEYBRD_READ) */

#define	get_vector(x)			_gr_get_vector_ (x)
#define	get_key()			_gr_get_key_ ()
#define	pc_wrt_line(r,s,t,u,v,w)	_gr_pc_wrt_line_ (r, s, t, u, v, w)
#define	kbd_shift_state()		_gr_kbd_shift_state_ ()
#define	kbd_status()			_gr_kbd_status_ ()
#define	clear_kbd_queue()		_gr_clear_kbd_queue_ ()
#define	move_cursor(x,y,z,t)		_gr_move_cursor_ (x, y, z, t)
#define	draw_pointer(r,s,t,u,v,w)	_gr_draw_pointer_ (r, s, t, u, v, w)
#define	mouse_set_pos(x,y)		_gr_mouse_set_pos_ (x, y)
#define	mouse_get_pos()			_gr_mouse_get_pos_ ()
#define	mouse_define_cursor(x,y,z)	_gr_mouse_define_cursor_ (x, y, z)
#define	mouse_get_btns(x)		_gr_mouse_get_btns_ (x)


#define	get_video_mode()		_gr_vid_mode_ (VIDEO_STATE, 0)
#define	set_video_mode(x)		_gr_vid_mode_ (SET_MODE, x)
#define mouse_reset()			_gr_mouse_fn1_ (M_RESET)
#define	mouse_sho_cur()			( (void) _gr_mouse_fn1_ (M_SHO_CUR))
#define	mouse_hid_cur()			( (void) _gr_mouse_fn1_ (M_HID_CUR))
					/* showing and hiding the mouse do not yield */
					/* meaningful return values */
#define	mouse_cursor_x(xmin,xmax)	_gr_mouse_cursor_minmax_ (xmin, xmax, M_MAX_MIN_X)
#define	mouse_cursor_y(ymin,ymax)	_gr_mouse_cursor_minmax_ (ymin, ymax, M_MAX_MIN_Y)

#define arrow_key(x)			((x == UP_ARROW) || (x == LF_ARROW) \
					|| (x == RT_ARROW) || (x == DN_ARROW))
					/* test for cursor keys */

struct mouse_pos
	{
	int x, y;
	unsigned count;
	};

void _gr_draw_pointer_ ( int *, int *, int, int, unsigned _far *, unsigned _far * );

unsigned _gr_get_key_ ( void );
unsigned char _far * _gr_get_vector_ ( unsigned );

unsigned _gr_kbd_shift_state_ ( void );
unsigned _gr_kbd_status_ ( void );
void _gr_clear_kbd_queue_ ( void );

void _gr_move_cursor_ ( int *, int *, unsigned, int );

int _gr_mouse_fn1_ ( unsigned );
void _gr_mouse_define_cursor_ (int, int, unsigned _far * );
void _gr_mouse_cursor_minmax_ ( unsigned, unsigned, unsigned );
void _gr_mouse_set_pos_ ( int, int );
struct mouse_pos *_gr_mouse_get_btns_ ( unsigned );
struct mouse_pos *_gr_mouse_get_pos_ ( void );	/* get position */

void _gr_pc_wrt_line_ ( unsigned, int, int, int, int, int );
unsigned _gr_vid_mode_ ( unsigned char, unsigned char );

#define	MSCIO
#endif
