/*
 * Copyright (c) 1988, 1992 Antonio Costa, INESC-Norte.
 * All rights reserved.
 *
 * Code, ideas or suggestions were taken from the following people:
 *
 *  Roman Kuchkuda      - basic ray tracer
 *  Mark VandeWettering - MTV ray tracer
 *  Augusto Sousa       - overall, shading model
 *  Craig Kolb          - stereo view mode
 *  Rodney Bogart       - depth of field (lens camera model)
 *  Reid Judd           - portability
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Antonio Costa, at INESC-Norte. The name of the author and
 * INESC-Norte may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifdef TURBOC
#define MAIN_MODULE
#endif
#ifndef lint
char            copyright[] =
"@(#) Copyright (c) 1988, 1992 Antonio Costa, INESC-Norte.\n\
All rights reserved.\n";
#endif
#include "defs.h"
#include "extern.h"

/**********************************************************************
 *    RAY TRACING - Version 8.0.0                                     *
 *                                                                    *
 *    MADE BY    : Antonio Costa, INESC-Norte, October 1988           *
 *    ADAPTED BY : Antonio Costa, INESC-Norte, June 1989              *
 *    MODIFIED BY: Antonio Costa, INESC-Norte, September 1992         *
 **********************************************************************/

static void
input_parameters(parameters, parameter)
  int            *parameters;
  char_ptr        parameter[];
{
  REG int         i;

  INPUT_PARAMETERS;
  POSDEC(*parameters);
  for (i = 1; i <= *parameters; POSINC(i))
    parameter[i - 1] = parameter[i];
}
static void
get_view(frame)
  int             frame;
{
  if (camera[frame].eye != NULL)
    STRUCT_ASSIGN(eye, *(camera[frame].eye));
  if (camera[frame].look != NULL)
    STRUCT_ASSIGN(look, *(camera[frame].look));
  if (camera[frame].up != NULL)
    STRUCT_ASSIGN(up, *(camera[frame].up));
  if (camera[frame].view_angle_x > 0.0)
    STRUCT_ASSIGN(view_angle_x, camera[frame].view_angle_x);
  if (camera[frame].view_angle_y > 0.0)
    STRUCT_ASSIGN(view_angle_y, camera[frame].view_angle_y);
}
/***** Main *****/
void
main(parameters, parameter)
  int             parameters;
  char_ptr        parameter[];
{
  int             frame;

  input_parameters(&parameters, parameter);
  get_parameters(parameters, parameter);

  ALLOCATE(pqueue, pqueue_struct, PQUEUE_SIZE_MAX, PARSE_TYPE);
  ALLOCATE(light, light_struct, lights_max, PARSE_TYPE);
  ALLOCATE(surface, surface_ptr, surfaces_max, PARSE_TYPE);
  ALLOCATE(object, object_ptr, objects_max, PARSE_TYPE);
  get_scene();
  setup_scene();

  ALLOCATE(new_line, pixel_struct, screen_size_x + 1, TRACE_TYPE);
  ALLOCATE(old_line, pixel_struct, screen_size_x + 1, TRACE_TYPE);
  ALLOCATE(true_color, rgb_struct, screen_size_x + 1, TRACE_TYPE);
  ALLOCATE(back_mask, real, screen_size_x + 1, TRACE_TYPE);

  make_view();
  init_globals();
  init_picture();
  ray_trace();
  for (frame = 0; frame < movie_frames; POSINC(frame))
  {
    WRITE(results, "\nInfo: FRAME %d\n", frame + 1);
    FLUSH(results);
    get_view(frame);
    make_view();
    init_globals();
    init_picture();
    ray_trace();
  }
  if (picture != OUTPUT)
    CLOSE(picture);
  if (background_mode == 1)
    CLOSE(background);
  if (raw_mode == 1)
    CLOSE(raw_picture);
  EXIT;
}
