/*	VGR.h    -  Header for VGR.c and board specific graphic modules

	*******************************************************
	* It's a good idea to assume that the video/graphics  *
	* functions   WON'T WORK IN THE SMALL DATA MODELS!    *
	*******************************************************
*/

typedef struct {
   unsigned int ax, bx, cx, dx, si, di, ds, es;
} REGS;

/*	Card specific constants
*/

#define BASE_MDA    0xb8000000l
#define BASE_EGA    0xa0000000l
#define BASE_CGA    0xb8000000l
#define BASE_HERC0  0xb0000000l /* page 0 */
#define BASE_HERC1  0xb8000000l /* page 1 */

#define TYPE_UNKNOWN   0
#define TYPE_MDA    1
#define TYPE_EGA    2
#define TYPE_CGA    3
#define TYPE_HERC   4


/*	Each video board, and each mode that is supported, will have 
	it's own set of driver functions. These functions will be
	placed into a module of their own. This module, on 
	initialization, will describe to the general routines the
	characteristics of the specific board/mode being driven.

	The functions in each module will be called in exactly the 
	same way for each board/mode.

	The current function list will be in this order:

	INIT     Init the module. NOTE: Don't use this macro until
	         after one of the driver level *_init() routines
	         has been called!
	MODE     Select a TEXT or APA mode.
	CLEAR    Clear the screen.
	SET      Set a point (turn it on.)
	CLR      Clear a point (turn it off.)
	XOR      XOR a point (turn it off if we want it on and it's on,
	         or if it's off and we want it off. Turn it off if we
	         want it on and it's off, or if it's on and we want it
	         on.)
	GET      Return the current color of the dot.
	ROW      Write an entire ROW of dots.

	VPEEK    Same as MOVMEM, PEEK & POKE. HERC and EGA boards don't
	VPOKE    need to test for flicker, but old CGA boards do. So...
	VMOVE    These macros will point to either movmem(), peek() &
	         poke(), or cga_movmem(), cga_peek() & cga_poke(). The
	         calling module doesn't need to know which.

	The following functions are supported for the benefit of the
	EGA board:

	PLANE    Select the desired bit map.
	PALETTE  Set a palette register.

	The following function is provided for the benefit of the CGA
	board:
	
	CPAL     set the palette for the CGA board.

	The following function is supported for the benefit of the
	HERC board:

	PAGE     Select the page to draw/view.
*/

GLOBAL int (*vgr_func[14])();

GLOBAL int VGR_HRES,
	   VGR_VRES,
	   VGR_NCOLORS,
	   VGR_NBPL;

#define VGR_INIT()           ((*vgr_func[ 0])())
#define VGR_CLEAR()          ((*vgr_func[ 1])())
#define VGR_SET(x,y,c)       ((*vgr_func[ 2])((x),(y),(c)))
#define VGR_CLR(x,y)         ((*vgr_func[ 3])((x),(y)))
#define VGR_XOR(x,y,c)       ((*vgr_func[ 4])((x),(y),(c)))
#define VGR_GET(x,y)         ((*vgr_func[ 5])((x),(y)))
#define VGR_ROW(r,p,n)       ((*vgr_func[ 6])((r),(p),(n)))
#define VGR_PLANE(p)         ((*vgr_func[ 7])((p)))
#define VGR_PALETTE(p,r,g,b) ((*vgr_func[ 8])((p),(r),(g),(b)))
#define VGR_MODE(n)          ((*vgr_func[ 9])((n)))
#define VGR_MOVE(s,d,n)      ((*vgr_func[10])((s),(d),(n))
#define VGR_PEEKB(p)         ((*vgr_func[11])((p))
#define VGR_POKEB(p,b)       ((*vgr_func[12])((p),(b))
#define VGR_PAGE(p)          ((*vgr_func[13])((p)))
#define VGR_CPAL(p,r)        ((*vgr_func[14])((p),(r)))

#define MODE_TEXT0     1     /* text, 80x25                      */
#define MODE_APA0      2     /* APA, 640x350x16                  */
#define MODE_APA1      3     /* APA, 720x348x2                   */
#define MODE_APA2      4     /* APA, 640x200x2                   */
#define MODE_APA3      5     /* APA, 320x200x4                   */

/*	Misc. Stuff...
*/

#define CASTUCFPP (unsigned char far * far *)
#define CASTUCFP (unsigned char far *)

void vgr_fill();
void vgr_point();

