/*
 * CGA.H -- (CGA) image manipulation routines
 *          Header file
 */

#ifndef __CGA_H
#define __CGA_H




/* TYPEDEFS */

typedef char          BYTE;
typedef unsigned char UBYTE;
typedef int           WORD;
typedef unsigned int  UWORD;
typedef long          LONG;
typedef unsigned long ULONG;

typedef int           boolean;
typedef unsigned char bool;




/* DEFINES */

#define _BLACK 0
#define _BLUE  1
#define _RED   2
#define _WHITE 3




/* PROTOTYPES */

void cls(void);

void fload_pic(const char *name);

void init_cgfx(UBYTE vmode);

void mode(WORD vmode);

void put_pixel(int x, int y, int color);

void save_pic(const char *name);


#endif __CGA_H
