/*****************************************************************************
*   General routines to	handle the graphics.				     *
*									     *
* Written by:  Gershon Elber			       Ver 0.2, Aug. 1990    *
*									     *
* Support: Interface for the virtual raster device, ps.			     *
*****************************************************************************/

#ifndef IGRAPH_H
#define IGRAPH_H

#define IG_DEFAULT_ZOOM_FACTOR	2

typedef enum {
    OUTPUT_EPSON,
    OUTPUT_GIF,
    OUTPUT_RAW,
} OutputDriverType;

void IGInitGraph(void);
void IGDumpScreen(OutputDriverType OutputKind, int DirectPrint,
						BooleanType DoubleDensity);
void IGCloseGraph(void);
int IGMapX(int x);
int IGMapY(int y);
void IGMoveTo(int x, int y);
void IGLineTo(int x, int y);
void IGLine(int x1, int y1, int x2, int y2);
void IGPoly(int n, int *Points, int Fill);
void IGBar(int x1, int y1, int x2, int y2);
void IGCircle(int x, int y, int r);
void IGArc(int x, int y, int StAngle, int EndAngle, int r);
void IGTextFormat(TextOrientationType TextOrient, int Scale,
		  TextHorizJustifyType XCenter, TextVertJustifyType YCenter);
void IGText(char *Text);
void IGDrawNotBar(int x1, int y1, int x2, int y2, char *Str);
void IGClearAllScreen(void);

/* These routines gets corrdinates in scren space. */
void IGLineRelToNoMap(int x, int y);
void IGMoveToNoMap(int x, int y);
void IGLineNoMap(int x1, int y1, int x2, int y2);
int IGTextWidthNoMap(char *s);
int IGTextHeightNoMap(char *s);

#endif IGRAPH_H
