/* Set up the basic primitives for Layer control */

#include <stdio.h>
#include <string.h>
#include "\usr\include\intr_lib.h"
/* #include "\usr\include\intr_gr.h" */
#include "program.h"
#include "eelayer.h"


#define MAX_LAYERS 44
#define LAYER_OFF 0
#define LAYER_ON  1
#define LAYER_ENABLED 2
#define LAYER_UNUSED  4

#define BLACK		0
#define RED		4
#define GREEN		2
#define BLUE		1
#define YELLOW		14
#define CYAN		3
#define MAGENTA		5
#define WHITE		15


static char *UsedLayers[] ={
	"Wire",
	"Bus",
	"Gate",
	"IEEE",
	"PinFun",
	"PinNum",
	"PinNam",
	"RefDes",
	"Attr",
	"Device",
	"Notes",
	"NetNam",
	"Pin",
	"END"
};
static int LayerInfo[] ={
	 WHITE,0x8200,
	 YELLOW,0x0100,
	 CYAN,0x0100,
	 RED,0x0100, 
	 BLUE,0x0100, 
	 YELLOW,0x0100, 
	 BLUE,0x0100, 
	 YELLOW,0x0100, 
	 YELLOW,0x0100, 
	 CYAN,0x0100, 
	 BLUE,0x0100, 
	 RED,0x0100,
	 WHITE,0x0100
};

struct LayerStruct *Layer; 

void SeedLayers()

{
	int pt;
	
	Layer = (LayerStruct *) MyMalloc(sizeof(LayerStruct));
	
	
	pt=0;
	Layer->CurrentWidth = 1;
/* seed Up the Layer Strings and colours, set all user layers off */
	while((strcmp(UsedLayers[pt],"END"))!=0){
		/* set layer name up */
	 
		strcpy(Layer->LayerNames[pt],UsedLayers[pt]);
		Layer->LayerStatus[pt]=
			 (LayerInfo[(pt * 2) +1] & 0x0f00)/0x100;

		Layer->LayerColor[pt] = LayerInfo[(pt * 2)];

		if(LayerInfo[(pt * 2) +1] & 0x8200)
			Layer->CurrentLayer=pt;
	 
		pt++;
	}
	 
	Layer->NumberOfLayers=pt-1;
	while(pt!=MAX_LAYERS){
		sprintf(Layer->LayerNames[pt],"User%d",pt);

		
		Layer->LayerStatus[pt] = LAYER_UNUSED;
							/* layers clear */
							/* and Off */
		Layer->LayerColor[pt] = INTR_COLOR_BLACK;
		/* Colours Black */ 
		pt++;
	}
	

	 
}
int ReturnCurrentWidth()
{
	return(LayerPointer -> CurrentWidth);
}
void SetCurrentWidth(int Width)
{
	LayerPointer -> CurrentWidth = Width;
}
int ReturnCurrentLayer()
{
	return(LayerPointer -> CurrentLayer);
}
void SetCurrentLayer(int Layer)
{
	LayerPointer->CurrentLayer = Layer;
}
char *ReturnLayerName(Layer)
int Layer;
{
	return(LayerPointer->LayerNames[Layer]);
}
void SetLayerName(Layer,Name)
int Layer;
char *Name;
{
	strcpy(LayerPointer->LayerNames[Layer],Name);
}
int ReturnLayerMode(Layer)
int Layer;
{
	return(LayerPointer->LayerStatus[Layer]);
}
void SetLayerMode(Layer,Mode)
int Layer,Mode;
{
	LayerPointer->LayerStatus[Layer]=Mode;
}

int ReturnLayerColor(Layer)
int Layer;
{
	return(LayerPointer->LayerColor[Layer]);
	 
}
void SetLayerColor(Layer,Color)
int Layer,Color;
{
	LayerPointer->LayerColor[Layer]=Color;
}
int ReturnLayerNumber()
{
	return(LayerPointer->NumberOfLayers);
}
void SetLayerNumber(Number)
int Number;
{
	LayerPointer->NumberOfLayers=Number;
}
void LoadLayers(f)
FILE *f;	/* Load the Layer Structuer from a file */
{
	int cnt,Number;
	char Line[LINE_LEN];
	int Mode,Color,Layer;
	char Name[0x10];

	fgets(Line,LINE_LEN-1,f);	/* read line */
	sscanf(Line,"%s %d %d",Name,&Number,&LayerPointer->CurrentLayer);
	if((strcmp(Name,"EELAYER"))!=0){
		/* Error! */
	} else
		SetLayerNumber(Number);
	cnt=0;
	while(cnt!=Number+1){
		fgets(Line,LINE_LEN-1,f);	/* read line */
		sscanf(Line,"%s %d %d %d",Name,&Color,&Mode,&Layer);
		SetLayerName(Layer,Name);
		SetLayerColor(Layer,Color);
		SetLayerMode(Layer,Mode);
		cnt++;
	}
	fgets(Line,LINE_LEN-1,f);	/* read trailing Line */

}
