/*****************************************************************************
*   Module to handle screen printing.					     *
*									     *
* Written by:  Gershon Elber			IBM PC Ver 1.0,	Dec. 1989    *
*****************************************************************************/

#include <stdio.h>
#include "Program.h"
#include "EEString.h"
#include "EELayer.h"
#include "Primary.h"

static void PutTextInfoNoCentering(int Orient, int PosX, int PosY, char *Str);

/*****************************************************************************
* Put out a string, always centered to the given position, with given	     *
* orientation, taking into account current zoom factor.			     *
*****************************************************************************/
void PutTextInfo(int Orient, int PosX, int PosY, int Scale, char *Str)
{
    int Size = MAX(1, GRFontSize + (Scale - 1)) - DEFAULT_ZOOM_FACTOR;

    GRSetTextStyle(GRFontName, Orient, Size);
    GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER, GR_TEXT_VJUSTIFY_CENTER);
    GRText(PosX, PosY, Str);
    GRSetTextStyle(GRFontName, GR_HORIZ_DIR, MAX(GRFontSize, 1) -
    						       DEFAULT_ZOOM_FACTOR);
}

/*****************************************************************************
* Same as PutTextInfo but does no centering.				     *
*****************************************************************************/
void PutTextInfoNoCentering(int Orient, int PosX, int PosY, char *Str)
{
    int Size = MAX(1, GRFontSize) - DEFAULT_ZOOM_FACTOR;

    GRSetTextStyle(GRFontName, Orient, Size);
    GRText(PosX, PosY, Str);
    GRSetTextStyle(GRFontName, GR_HORIZ_DIR, MAX(GRFontSize, 1) -
    						       DEFAULT_ZOOM_FACTOR);
}

/*****************************************************************************
* Put out pin number and pin text info, given the pin line coordinates.	     *
* The line must be vertical or horizontal.				     *
* If PinNext == NULL nothing is printed. If PinNum = 0 no number is printed. *
* Current Zoom factor is taken into account.				     *
* If TextInside then the text is been put inside (moving from x1, y1 in      *
* the opposite direction to x2,y2), otherwise all is drawn outside.	     *
*****************************************************************************/
void PutLineTextInfo(int x1, int y1, int x2, int y2, char *PinText, int PinNum,
				BooleanType TextInside, BooleanType DrawNums,
				int Mode)
{
/* Mode 0=EE_ERASE_COLOR, Mode 1=Layer_Color */
    int x, y;
    BooleanType IsNot;
    char SPinNum[MAX_PIN_INFO];

    /* Do we need to invert the string? Is this string has only "~"? */
    if (PinText != NULL && (IsNot = PinText[0] == '~') != FALSE) {
    	PinText++;
	if (PinText[0] == 0) PinText = NULL;
    }

    if (TextInside) {  /* Draw the text inside, but the pin numbers outside. */
	if (x1 != x2) {				  /* Its an horizontal line. */
	    if (PinText != NULL) {
		if (x1 > x2) {
		    GRSetTextJustify(GR_TEXT_HJUSTIFY_LEFT,
		                     GR_TEXT_VJUSTIFY_CENTER);
		    x = x1 + TextInside;
		    if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
		    	GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		    else
			GRSetColor(EE_ERASE_COLOR);
		    	PutTextInfoNoCentering(GR_HORIZ_DIR, x, y1, PinText);
		    	if (GRDrawingText() && IsNot) {
				GRMoveTo(x, y1);
		    		GRSMoveRel(0, -GRGetTextHeight(PinText) / 2 - 1);
				GRSLineRel(GRGetTextWidth(PinText), 0);
		    	}
		    
		}
		else {
		    GRSetTextJustify(GR_TEXT_HJUSTIFY_RIGHT,
		                     GR_TEXT_VJUSTIFY_CENTER);
		    if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
		    	GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		    else
			GRSetColor(EE_ERASE_COLOR);
		        x = x1 - TextInside;
		        PutTextInfoNoCentering(GR_HORIZ_DIR, x, y1, PinText);
		        if (GRDrawingText() && IsNot) {
			    GRMoveTo(x, y1);
		    	    GRSMoveRel(0, -GRGetTextHeight(PinText) / 2 - 1);
			    GRSLineRel(-GRGetTextWidth(PinText), 0);
		        }
		    
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER,
		                 GR_TEXT_VJUSTIFY_BOTTOM);
		if((ReturnLayerMode(LAYER_PINNUM)&0x03) & (Mode==1))
			GRSetColor(ReturnLayerColor(LAYER_PINNUM));
		else 
			GRSetColor(EE_ERASE_COLOR);
			sprintf(SPinNum, "%d", PinNum);
			PutTextInfoNoCentering(GR_HORIZ_DIR, 
				(x1 + x2) / 2, y1 + 1, SPinNum);
		
	    }
	}
	else {					     /* Its a vertical line. */
	    if (PinText != NULL) {
		if (y1 > y2) {
		    GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER,
                    		     GR_TEXT_VJUSTIFY_TOP);
		    if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
			GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		    else
			GRSetColor(EE_ERASE_COLOR);
		    	y = y1 + TextInside;
		    	PutTextInfoNoCentering(GR_VERT_DIR, x1, y, PinText);
		    	if (GRDrawingText() && IsNot) {
				GRMoveTo(x1, y);
		    		GRSMoveRel(-GRGetTextHeight(PinText) / 2 - 1, 0);
				GRSLineRel(0, GRGetTextWidth(PinText));
		    	}
		    
		}
		else {
		    GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER,
                       		     GR_TEXT_VJUSTIFY_BOTTOM);
		    if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
			GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		    else
			GRSetColor(EE_ERASE_COLOR);
		        y = y1 - TextInside;
		        PutTextInfoNoCentering(GR_VERT_DIR, x1, y, PinText);
		        if (GRDrawingText() && IsNot) {
			    GRMoveTo(x1, y);
		    	    GRSMoveRel(-GRGetTextHeight(PinText) / 2 - 1, 0);
			    GRSLineRel(0, -GRGetTextWidth(PinText));
		        }
		    
		}
	    }
	    if (PinNum != 0 && DrawNums) {
		GRSetTextJustify(GR_TEXT_HJUSTIFY_RIGHT,
                		 GR_TEXT_HJUSTIFY_CENTER);
		if((ReturnLayerMode(LAYER_PINNUM)&0x03) & (Mode==1))
		    GRSetColor(ReturnLayerColor(LAYER_PINNUM));
		else
		    GRSetColor(EE_ERASE_COLOR);
		    sprintf(SPinNum, "%d", PinNum);
		    PutTextInfoNoCentering(GR_VERT_DIR, x1 - 1,
			 (y1 + y2) / 2, SPinNum);
		
	    }
	}
    }
    else {				       /* Draw text outside as well. */
	if (x1 != x2) {				  /* Its an horizontal line. */
	    if (PinText != NULL) {
		GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER,
		                 GR_TEXT_VJUSTIFY_BOTTOM);
		if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
		    GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		else
		    GRSetColor(EE_ERASE_COLOR);
		    PutTextInfoNoCentering(GR_HORIZ_DIR, x = (x1 + x2) / 2,
					GRInvMapY(GRMapY(y1) - 1), PinText);
		    if (GRDrawingText() && IsNot) {
		        GRMoveTo(x, y1);
		        GRSMoveRel(-GRGetTextWidth(PinText) / 2,
			           -GRGetTextHeight(PinText) - 2);
		        GRSLineRel(GRGetTextWidth(PinText), 0);
		    }
		
	    }
	    if (PinNum != 0 && DrawNums) {
		GRSetTextJustify(GR_TEXT_HJUSTIFY_CENTER,
                		 GR_TEXT_VJUSTIFY_TOP);
		if((ReturnLayerMode(LAYER_PINNUM)&0x03) & (Mode==1))
		    GRSetColor(ReturnLayerColor(LAYER_PINNUM));
		else
		    GRSetColor(EE_ERASE_COLOR);
		    sprintf(SPinNum, "%d", PinNum);
		    PutTextInfoNoCentering(GR_HORIZ_DIR, (x1 + x2) / 2,
					  GRInvMapY(GRMapY(y1) + 2), SPinNum);
		
	    }
	}
	else {					     /* Its a vertical line. */
	    if (PinText != NULL) {
		GRSetTextJustify(GR_TEXT_HJUSTIFY_RIGHT,
	                	 GR_TEXT_VJUSTIFY_CENTER);
		if((ReturnLayerMode(LAYER_PINNAM)&0x03) & (Mode==1))
		    GRSetColor(ReturnLayerColor(LAYER_PINNAM));
		else
		    GRSetColor(EE_ERASE_COLOR);
		    PutTextInfoNoCentering(GR_VERT_DIR,
			 GRInvMapX(GRMapX(x1) - 1),
		         y = (y1 + y2) / 2, PinText);
		    if (GRDrawingText() && IsNot) {
		        GRMoveTo(x1, y);
		        GRSMoveRel(-GRGetTextHeight(PinText) - 2,
			           -GRGetTextWidth(PinText) / 2);
		        GRSLineRel(0, GRGetTextHeight(PinText));
		    }
		
	    }
	    if (PinNum != 0 && DrawNums) {
                /* For some reason LEFT justification does not work!!! */
		GRSetTextJustify(GR_TEXT_HJUSTIFY_RIGHT,
		                 GR_TEXT_VJUSTIFY_CENTER);
		if((ReturnLayerMode(LAYER_PINNUM)&0x03) & (Mode==1))
		    GRSetColor(ReturnLayerColor(LAYER_PINNUM));
		else
		    GRSetColor(EE_ERASE_COLOR);
		    sprintf(SPinNum, "%d", PinNum);
		    PutTextInfoNoCentering(GR_VERT_DIR,
			GRInvMapX(GRMapX(x1) + 2 + GRGetTextHeight(PinText)),
						      (y1 + y2) / 2, SPinNum);
		
	    }
	}
    }
}
