/* sw_pathe.c - path search for swaplib
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_path.c'v 0.9 90/09/09 21:44:05 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <io.h>
#include <malloc.h>

#include "swaplib.h"

extern void *xmalloc (size_t size);
extern void *xrealloc (void *ptr, size_t size);

#define PATH_SEP	';'
#define FSLASH		'/'
#define BSLASH		'\\'

/* The suffixes recognized by executable_p (). */

static char *suffixes[] =
{
  ".sh",			/* executed by $SHELL */
  ".bat",			/* executed by $COMSPEC */
  ".exe",
  ".com",
  NULL,
};


/* Look for NAME in the directories from $ENV ($PATH, if ENV is NULL),
   satisfying SELECT.  */

char *
swap_expand_path (char *name, char *env, char *(*select) (char *))
{
  size_t name_len = strlen (name) + 6;	/*  SELECT may append 4 chars! */
  char *exp = (char *) xmalloc (name_len);

  strcpy (exp, name);

  if ((*select) (exp))		/* first look in current directory. */
    return exp;

  /* If not an absolute path, scan $PATH  */

  if (exp[1] != ':' && *exp != BSLASH && *exp != FSLASH)
    {
      char *ptr = getenv ((env == NULL) ? "PATH" : env);
      if (ptr != NULL)
	{
	  char *path = (char *) alloca (strlen (ptr) + 1);
	  strcpy (path, ptr);	/* get a copy strtok() can butcher. */

	  ptr = strtok (path, ";");

	  while (ptr != NULL)
	    {
	      exp = (char *) xrealloc (exp, strlen (ptr) + name_len);
	      if ((*select) (strcat (strcat (strcpy (exp, ptr), "/"), name)))
		return exp;
	      ptr = strtok (NULL, ";");
	    }
	}
    }

  free (exp);
  return NULL;			/* We've failed!  */
}


/* Return the expanded path with extension iff PATH is an executable MS-DOS
   program, NULL otherwise. 
   Caution:  PATH *must* be able to hold 4 more characters.  */

char *
swap_executable_p (char *path)
{
  char *base = swap_basename (path);
  const char **suf = suffixes;

  if (strchr (base, '.'))	/* explicit suffix? */
    {
      if (!access (path, 0))
	return path;
    }
  else
    {
      while (*base)		/* point to the end */
	*base++;

      while (*suf)		/* try all suffixes */
	{
	  strcpy (base, *suf++);
	  if (!access (path, 0))
	    return path;
	}
    }

  return NULL;			/* failed */
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
