/* global.c - global variables and initial values for cpio.
   Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* MS-DOS port (c) 1990 by Thorsten Ohl, ohl@gnu.ai.mit.edu
   This port is also distributed under the terms of the
   GNU General Public License as published by the
   Free Software Foundation.

   Please note that this file is not identical to the
   original GNU release, you should have received this
   code as patch to the official release.

   $Header: e:/gnu/cpio/RCS/global.c 1.1.0.2 90/09/23 23:11:09 tho Exp $
 */

#include "cpio.h"
#include "dstring.h"

#ifdef MSDOS
#include "extern.h"
#endif

/* If TRUE, reset access times after reading files (-a). */
int reset_time_flag = FALSE;

/* Block size value, initially 512.  -B sets to 5120. */
int io_block_size = 512;

/* If TRUE, recognize binary header format for copy in (-b). */
int binary_flag = FALSE;

/* If TRUE, use ASCII header format for copy out
   and recognize ASCII header format for copy in (-c).  */
int portability_flag = FALSE;

/* If TRUE, create directories as needed. (-d with -i or -p) */
int create_dir_flag = FALSE;

/* If TRUE, interactively rename files. (-r) */
int rename_flag = FALSE;

/* If TRUE, print a table of contents of input. (-t) */
int table_flag = FALSE;

/* If TRUE, copy unconditionally (older replaces newer). (-u) */
int unconditional_flag = FALSE;

/* If TRUE, list the files processed, or ls -l style output with -t. (-v) */
int verbose_flag = FALSE;

/* If TRUE, link files whenever possible.  Used with -p option. (-l) */
int link_flag = FALSE;

/* If TRUE, retain previous file modification time. (-m) */
int retain_time_flag = FALSE;

/* With -i; if TRUE, copy only files that match any of the given patterns;
   if FALSE, copy only files that do not match any of the patterns. (-f) */
int copy_matching_files = TRUE;

/* With -itv; if TRUE, list numeric uid and gid instead of translating them
   into names. */
int numeric_uid = FALSE;

/* Input and output buffers. */
char *input_buffer, *output_buffer;

/* Current locations in `input_buffer' and `output_buffer'. */
char *in_buff, *out_buff;

/* Current number of bytes stored at `input_buff' and `output_buff'. */
LONG input_size, output_size;

/* Total number of bytes read and written for all files. */
LONG input_bytes, output_bytes;

/* Saving of argument values for later reference. */
char *directory_name;
char **save_patterns;
int num_patterns;

/* TRUE if input (cpio -i) or output (cpio -o) is a device node. */
#ifdef MSDOS			/* shut up the compiler */
int input_is_special = FALSE;
int output_is_special = FALSE;
#else
char input_is_special = FALSE;
char output_is_special = FALSE;
#endif

/* TRUE if lseek works on the input. */
#ifdef MSDOS			/* shut up the compiler */
int input_is_seekable = FALSE;
#else
char input_is_seekable = FALSE;
#endif

/* TRUE if lseek works on the output. */
#ifdef MSDOS			/* shut up the compiler */
int output_is_seekable = FALSE;
#else
char output_is_seekable = FALSE;
#endif

/* The name this program was run with. */
char *program_name;

/* A pointer to either lstat or stat, depending on whether
   dereferencing of symlinks is done for input files.  */
#ifdef MSDOS
int (*xstat) (char *name, struct stat *statb);
#else
int (*xstat) ();
#endif

/* Which copy operation to perform. (-i, -o, -p) */
#ifdef MSDOS
void (*copy_function) (void) = 0;
#else
void (*copy_function) () = 0;
#endif
