/* extern.h - External declarations for cpio.
   Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* MS-DOS port (c) 1990 by Thorsten Ohl, ohl@gnu.ai.mit.edu
   This port is also distributed under the terms of the
   GNU General Public License as published by the
   Free Software Foundation.

   Please note that this file is not identical to the
   original GNU release, you should have received this
   code as patch to the official release.

   $Header: e:/gnu/cpio/RCS/extern.h 1.1.0.2 90/09/23 23:11:18 tho Exp $
 */

#ifdef MSDOS
#define LONG long
#else
#define LONG int
#endif

extern int reset_time_flag;
extern int io_block_size;
extern int binary_flag;
extern int portability_flag;
extern int create_dir_flag;
extern int rename_flag;
extern int table_flag;
extern int unconditional_flag;
extern int verbose_flag;
extern int link_flag;
extern int retain_time_flag;
extern int copy_matching_files;
extern int numeric_uid;

extern char *input_buffer, *output_buffer;
extern char *in_buff, *out_buff;
extern LONG input_size, output_size;
extern LONG input_bytes, output_bytes;
extern char *directory_name;
extern char **save_patterns;
extern int num_patterns;
#ifdef MSDOS			/* shut up the compiler */
extern int input_is_special;
extern int output_is_special;
extern int input_is_seekable;
extern int output_is_seekable;
#else /* not MSDOS */
extern char input_is_special;
extern char output_is_special;
extern char input_is_seekable;
extern char output_is_seekable;
#endif /* not MSDOS */
extern char *program_name;

#ifdef MSDOS
extern int (*xstat) (char *name, struct stat *statb);
extern void (*copy_function) (void);
#else
extern int (*xstat) ();
extern void (*copy_function) ();
#endif

#ifdef MSDOS

#include <stdlib.h>
#include <io.h>

extern int utime (char *, long *);	/* we're cheating... */

extern char *copystring (char *string);
extern char *find_inode_file (unsigned int node_num);
extern char *getgroup (int gid);
extern char *getuser (int uid);
extern char *xmalloc (unsigned int size);
extern void add_inode (unsigned short node_num, char *file_name);
extern void copy_buf_out (char *in_buf, int out_des, LONG num_bytes);
extern void copy_files (int in_des, int out_des, LONG num_bytes);
extern void copy_in_buf (char *in_buf, int in_des, LONG num_bytes);
extern void create_all_directories (char *name);
extern void empty_output_buffer (int out_des);
extern void error (int status, int errnum, char *message, ...);
extern void finish_output_file (char *path, int out_des);
extern void get_next_reel (int tape_des);
extern void hash_insert (struct inode_val *new_value);
extern void long_format (struct cpio_header *file_hdr, char *link_name);
extern void process_copy_in (void);
extern void process_copy_out (void);
extern void process_copy_pass (void);
extern void toss_input (int in_des, LONG num_bytes);
extern void write_out_header (struct cpio_header *file_hdr, int out_des);

#else /* not MSDOS */

long lseek ();
char *malloc ();
char *realloc ();

char *copystring ();
char *find_inode_file ();
char *getgroup ();
char *getuser ();
char *xmalloc ();
void add_inode ();
void copy_buf_out ();
void copy_files ();
void copy_in_buf ();
void create_all_directories ();
void empty_output_buffer ();
void error ();
void finish_output_file ();
void get_next_reel ();
void hash_insert ();
void long_format ();
void process_copy_in ();
void process_copy_out();
void process_copy_pass ();
void protection ();
void toss_input ();
void write_out_header ();

#endif /* not MSDOS */
