{these routines contain all the printer-specific output stuff}

PROCEDURE prt_msg; {ok : BOOLEAN}
(*****************************************************************************
main body to print the message
******************************************************************************)
VAR
    abort : BOOLEAN;
    ch : CHAR;
BEGIN
    TextColor(Cyan);
    cur_page:=start_page;
    abort:=FALSE;
{$ifdef HPLJ}
    WRITE(lst,#27,'E');                 {reset LaserJet}
    WRITE(lst,#27,'&l0O');              {portrait}
    WRITE(lst,#27,'(0O',#27,'(s0p10h12v0s0b0T'); {select OCR-A font}
    WRITE(lst,#27,'&l6D');              {6 lines/inch}
    WRITE(lst,#27,'&l0E');              {no top margin}
{$endif}
{$ifdef NEC}
    WRITE(lst,#27,']L');                {10 pitch}
    WRITE(lst,#27,']W');                {6 lines/inch}
{$endif}
{$ifdef KISS}
    WRITE(lst,#27,'A',#12);             {6 lines/inch (12/72 in/lf)}
    WRITE(lst,#27,'P');                 {10 Pitch}
    WRITE(lst,#27,'[512;0;s');          {OCR A font, portrait}
{$endif}
{$ifdef ALPS}
    WRITE(lst,#27,'@');                 {reset printer}
    WRITE(lst,#27,'2');                 {6 lines/inch}
    WRITE(lst,#27,'P');                 {10 Pitch}
    WRITE(lst,#27,'x1');                {LQ print quality}
    WRITE(lst,#27,'k1');                {Font Cartridge 2, hopefully OCR A}
{$endif}
    WHILE (cur_page<=tot_pages) AND (cur_page<=end_page)
            AND NOT abort DO BEGIN      {loop for all pages}
        WRITELN('Printing page ',cur_page);
        cur_line:=1;
        prt_header;                     {print header}
        prt_body;                       {print body}
        IF cur_page=1 THEN
            prt_sign;                   {print signature block, first page only}
        IF (class[1]='U') OR (class[1]='F') THEN
            prt_class;                  {ending classification line if unclass}
        cur_page:=cur_page+1;
        WRITE(lst,#12); {formfeed}
        WRITELN;
        IF (cur_page<=tot_pages) AND (cur_page<=end_page) THEN BEGIN
            TextColor(Cyan);
            WRITELN('Insert next DD173/2 for page ',cur_page:2); TextColor(Yellow);
            WRITE('Type <enter> to continue or <esc> to abort ',#26,' ');
            ch:=READKEY; TextColor(Cyan);
            WRITELN;
            IF ch = #27 THEN abort:=TRUE;
        END;
    END;
    IF abort THEN                       {return values}
        ok:=FALSE
    ELSE
        ok:=TRUE;
END; {PROCEDURE prt_msg (ok : BOOLEAN)}

PROCEDURE prt_header;
(*****************************************************************************
header line information
Note: column numbers do *NOT* agree between NEC and HPLJ as they start
      at different positions on the page!  HPLJ left margin = .62"; NEC = 0.
******************************************************************************)
BEGIN
{$ifdef HPLJ}
    WRITE(lst,#27,'&a',hp_tm:0:1,'R');       {top margin}
    IF (class[1]='U') OR (class[1]='F') THEN
       WRITE(lst,#27,'&a42C',class);         {indent for classification}
    WRITE(lst,#27,'&a',hp_head:0:1,'R');     {move to header line}
    IF cur_page < 10 THEN                    {page number}
        WRITE(lst,#27,'&a',hp_lm:0:1,'C','0',cur_page:1)  {left margin, then page}
    ELSE
        WRITE(lst,#27,'&a',hp_lm:0:1,'C',cur_page:2);
    {end}
    IF tot_pages < 10 THEN                   {of how many pages?}
        WRITE(lst,#27,'&a',3.8+hp_lm:0:1,'C','0',tot_pages:1)
    ELSE
        WRITE(lst,#27,'&a',3.8+hp_lm:0:1,'C',tot_pages:2);
    {end}

    WRITE(lst,#27,'&a',7.8+hp_lm:0:1,'C',dtg);           {day time group}
    WRITE(lst,#27,'&a',16.8+hp_lm:0:1,'C',mon_str);      {month}
    WRITE(lst,#27,'&a',21.8+hp_lm:0:1,'C',yr_str);       {year}
    WRITE(lst,#27,'&a',25.8+hp_lm:0:1,'C',act_pred);     {action predecence}
    WRITE(lst,#27,'&a',29.8+hp_lm:0:1,'C',info_pred);    {info predecence}
    CASE class[1] OF
        'U' : WRITE(lst,#27,'&a',33.8+hp_lm:0:1,'C','UUUU');
        'F' : WRITE(lst,#27,'&a',33.8+hp_lm:0:1,'C','FFFF');
        'C' : WRITE(lst,#27,'&a',33.8+hp_lm:0:1,'C','CCCC');
        'S' : WRITE(lst,#27,'&a',33.8+hp_lm:0:1,'C','SSSS');
        'T' : WRITE(lst,#27,'&a',33.8+hp_lm:0:1,'C','TTTT');
    END; {case}

    IF cur_page=1 THEN BEGIN
        WRITE(lst,#27,'&a',46.5+hp_lm:0:1,'C','AT');  {standard garbage}
        WRITE(lst,#27,'&a',50.5+hp_lm:0:1,'C','ZYUW');
    END;

    WRITELN(lst);                                     {'no' on first page only}
    WRITELN(lst);
    IF cur_page=1 THEN BEGIN
        WRITE(lst,#27,'&a',hp_no:0:1,'R');            {move to book line}
        WRITE(lst,#27,'&a',hp_lm:0:1,'C','NO')
    END;
{$endif}
{$ifndef HPLJ}                {equivalent to ifdef NEC or KISS or ALPS}
    IF (class[1]='U') OR (class[1]='F') THEN
        WRITE(lst,'                                        ',class); {col 40+}
    WRITELN(lst);
    WRITELN(lst);
    WRITELN(lst);
    IF cur_page < 10 THEN
        WRITE(lst,'0',cur_page:1)            {col 1-2, 2 chars}
    ELSE
        WRITE(lst,cur_page:2);
    {end}
    IF tot_pages < 10 THEN
        WRITE(lst,' ','0',tot_pages:1)       {col 4-5, 2 chars}
    ELSE
        WRITE(lst,' ',tot_pages:2);
    {end}

    WRITE(lst,'   ',dtg);                    {col  9-15, 7 Chars}
    WRITE(lst,'  ',mon_str);                 {col 18-20, 3 chars}
    WRITE(lst,'  ',yr_str);                  {col 23-24, 2 chars}
    WRITE(lst,'  ',act_pred);                {col 27-28, 2 chars}
    WRITE(lst,'  ',info_pred);               {col 31-32, 2 chars}
    CASE class[1] OF
        'U' : WRITE(lst,'  ','UUUU');        {col 35-38, 4 chars}
        'F' : WRITE(lst,'  ','FFFF');
        'C' : WRITE(lst,'  ','CCCC');
        'S' : WRITE(lst,'  ','SSSS');
        'T' : WRITE(lst,'  ','TTTT');
    END; {case}

    IF cur_page=1 THEN BEGIN
        WRITE(lst,'         ','AT');         {col 48-49, 2 chars}
        WRITE(lst,'  ','ZYUW');              {col 52-55, 4 chars}
    END;

    WRITELN(lst);
    WRITELN(lst);
    IF cur_page=1 THEN WRITE(lst,' NO');
    WRITEln(lst);
    WRITEln(lst);
{$endif}
    cur_line:=cur_line+7;
END; {PROCEDURE prt_header}

PROCEDURE prt_body;
(*****************************************************************************
cycles for each page of the msg, abort if requested
******************************************************************************)
VAR
    line_cnt : INTEGER;
    i : INTEGER;
BEGIN
    line_cnt:=1;
{$ifdef HPLJ}
    WRITE(lst,#27,'&a',hp_text:0:1,'R'); {forward to first line of message body}
{$endif}
{$ifdef NEC}
    WRITE(lst,#27,';');       {negative 1/2 line feed}
{$endif}
{$ifdef KISS}
    WRITE(lst,#27,'j',#18);   {negative 1/2 line feed (-6/216 in) }
{$endif}
{$ifdef ALPS}
    WRITE(lst,#27,'j',#6);   {negative 1/2 line feed (-6/216 in) }
{$endif}

    WHILE (line_cnt <= Max_Lines_Page) AND
            ((Max_Lines_Page * (cur_page-1)+line_cnt) <= Tot_tty_lines) DO BEGIN
{$ifdef HPLJ}
        WRITE(lst,#27,'&a',hp_lm:0:1,'C'); {left margin}
{$endif}
{$ifdef NEC}
        {no left margin for NEC}
{$endif}
{$ifdef KISS}
        WRITE(lst,'      ');      {left margin for NEC}
{$endif}
{$ifdef ALPS}
        {no left margin for ALPS}
{$endif}
        WRITELN(lst,tty[Max_Lines_Page*(cur_page-1)+line_cnt]);
        WRITELN(lst);
        cur_line:=cur_line+2;
        line_cnt:=line_cnt+1
    END {while}
END; {PROCEDURE prt_body}

PROCEDURE prt_sign;
(*****************************************************************************
prints the signature block on Sign_Line and classified by line (first page only!)
******************************************************************************)
BEGIN
{$ifdef HPLJ}
    WRITE(lst,#27,'&a',hp_sign:0:1,'R');          {vertical position}
    WRITELN(lst,#27,'&a',hp_lm:0:1,'C',sign1);    {hor pos + print}
    WRITE(lst,#27,'&a',hp_lm:0:1,'C',sign2);
{$endif}
{$ifndef HPLJ}                {equivalent to ifdef NEC or KISS or ALPS}
    WHILE cur_line < Sign_Line DO BEGIN
        WRITELN(lst);
        cur_line:=cur_line+1;
    END;
    WRITELN(lst,sign1);
    cur_line:=cur_line+1;
    WRITE(lst,sign2);
{$endif}
    IF (class[1]<>'U') AND (class[1]<>'F') THEN BEGIN
       WRITE(lst,^M,'                                        '); {col 40+}
       WRITELN(lst,'CLASSIFIED BY ',class_by);
       cur_line:=cur_line+1;
       WRITE(lst,'                                        ');
       WRITE(lst,'DECLASSIFY ON ',declass)
    END;
    WRITELN(lst);
    cur_line:=cur_line+1
END; {PROCEDURE prt_sign}

PROCEDURE prt_class;
(*****************************************************************************
prints the trailing class line if UNCLASS or FOUO
******************************************************************************)
BEGIN
{$ifdef HPLJ}
    WRITE(lst,#27,'&a',hp_cl:0:1,'R');
    WRITELN(lst,#27,'&a42C',class)
{$endif}
{$ifndef HPLJ}                {equivalent to ifdef NEC or KISS or ALPS}
    WHILE cur_line < Bot_Class_Line DO BEGIN
        WRITELN(lst);
        cur_line:=cur_line+1;
    END;
    WRITELN(lst,'                                      ',class); {col 38+}
{$endif}
END; {PROCEDURE prt_class}

PROCEDURE prt_mfr;
(*****************************************************************************
prints the mfr as entered
******************************************************************************)
VAR
    ln,temp : STRING[132];
    c : CHAR;
    cc,i : INTEGER;
BEGIN
    WRITELN; TextColor(Yellow);
    WRITE('Set-up printer for MFR, <enter> to continue or <esc> to abort ',#26,' ');
    c:=READKEY; TextColor(Cyan);
    WRITELN;
    IF c=#27 THEN
        WRITELN('Skipping print of MFR by user request ...')
    ELSE BEGIN
{$ifdef HPLJ}
        WRITE(lst,#27,'&a',hp_lm:0:1,'L');   {set left margin for HPLJ only}
{$endif}
        FOR i:=1 TO tot_mfr_lines DO BEGIN
            WRITELN(lst,mfr[i]);
{$ifdef KISS}
            WRITE(lst,#27,'    ');   {left margin for KISS}
{$endif}
        END;
        WRITE(lst,#12)                      {formfeed and end of job}
    END {ok to print mfr?}
END; {PROCEDURE prt_mfr}
