Protocol Selection
~~~~~~~~~~~~~~~~~~

A file transfer protocol is simply a way of sending files from one computer to
another while checking for (and correcting) errors.  There are several transfer
protocols available:

XModem : This is a fairly old protocol, but it is supported by most terminal
         packages.  Its drawbacks are that it is slow and it can only send one
         file per session.

         XModem has several variants, XModem-1k (uses 1024 byte packets instead
         of 128, slightly faster) and XModem-1k-g (uses 1024 byte packets and
         does not perform any error checking).

         To download using XModem you have to supply a file name for your
         terminal to receive to.  To upload you _must_ use the "Enter pre-
         upload files" option so that the BBS knows what your file is called.

         If at all possible, avoid XModem and use a more sophisticated transfer
         protocol.

YModem : This is a batch variant of XModem that sends file name and size data
         before the file.  This means that when receiving you do not have to
         supply a file name, and you do not need to use the pre-upload option.

         YModem is a batch protocol, it can send more that one file in one
         session.

         YModem has a variant known as YModem-g.  Like the XModem variation,
         this does not perform and error correction.

ZModem : This is one of the best protocols available.  It is quite efficient
         and uses a 32 bit CRC for error checking.

         Like YModem, ZModem sends file information before the file itself,
         allowing batch file transfers.  Most implementations of ZModem also
         allow downloads to begin automatically upon receiving the file data.

         One of the most powerful features of ZModem is that it can resume
         aborted transfers.  This means that if the transfer is stopped for
         any reason then you can continue it later.

         ZModem has the MobyTurbo and ZModem-90 varients.  These are higher
         efficency versions by the original designer of the ZModem protocol.
         They are only available to people who have registered the DSZ driver.

Lynx   : Lynx is not a standard protocol.  The driver is a shareware program.
         Its features rival that of ZModem.

Puma   : Puma is not a standard protocol.  The driver is a shareware program.
         Its features rival that of ZModem.  Note that the driver may be called
         MPt, this is fully compatible.

Press [Enter] to continue.