                            SCHEMATICS README

This file describes the enhancements and modifications to the 5.0a
release of the Schematics program which did not get included in the 
Genesis User's Guide.

For information regarding installation, operation, and technical details
about the package, you may purchase the Genesis User's Guide for $40.00.

Evaluation Version Users:

	The evaluation version of Schematics contains the same capabilities
	as the production version with the following exceptions:

		- only one page schematics are allowed
		- only A size pages
		- symbol libraries can contain a maximum of 30 symbols
	 	- schematic pages can contain a maximum of 20 parts
		- a maximum of 7 symbol libraries can be configured
			for use by the Schematic Editor
		- the Print, Export Part, and Import Part functions in
			the Symbol Editor are not available
		- a subset of the symbol libraries is provided
		- a LIB symbol must be explicitly added to the schematic
			to simulate circuits that reference parts in PSpice
			simulation libraries.  (see EXAMPLE.SCH)

                 
1.0) TUTORIALS

	Schematic editor tutorial:

		Page 21, example1.sch is now example.sch.

		Page 22, Drawing a Wire, Step 1 - Choose Wire from the 
		Draw Menu.

		Page 22, Choosing a Part from the Component Libraries, 
		Step 1 - Choose Get New Part from the Draw Menu.

		Page 23, Generating a PSpice Netlist, Step 3 - Choose 
		Exit from the File Menu in the Notepad window to exit the 
		netlist file. 

        A Symbol Editor tutorial can be found in section 8.0 of this file.


2.0) GENERAL MODIFICATIONS

	* To use an editor of your choice to browse netlists and output files:

		In your msim.ini file, change the line

                        editor=<command line>

		to

			editor=notepad %f

		for example, where notepad is the desired editor and %f is 
		where the file name should be passed to the editor.

	* To use ATM's Adobe fonts or BitStream fonts (PCs only):

		After you have either the Adobe or BitStream fonts installed
		on your system, add the line 

                        fonttype=ADOBE

		to the [SCHEMATICS] section of the msim.ini file to use
		the Adobe fonts with Schematics, or the line

                        fonttype=BITSTREAM

		to use the BitStream fonts.

        * The AC Sweep/Noise Analysis dialog and the DC Sweep dialog have 
	  changed slightly.  Operation remains the same.

	* If you wish to simulate a circuit (e.g., dsad.sch) which contains 
	  parts from the digital symbol libraries (dig_1.slb, dig_2.slb, 
	  dig_3.slb, dig_4.slb, or dig_misc.slb), you must have the Digital 
	  Simulation option for PSpice.
         
        * The Print dialog allows you to specify page border widths.

	* Page 16, Figure 1, F7 is used for the Auto-Increment function.

	* Page 56, the two-pin versions of print and watch symbols
	  (Print2 and Watch2) are not yet supported.

	* Page 57, Viewpoints are not yet supported.


3.0) KNOWN PROBLEMS

        * Changing pin names on symbols used in schematic files may
          cause problems when attempting to read in the schematic.

        * Arcs do not draw properly on HP plotters (this is a problem
          with the driver - HP may have a newer version available).

	* Using either the F or G device (e.g., a GVALUE part) in an AC
	  analysis causes an error in PSpice.
	
	* In the Symbol Editor, attempting to move graphics, pins, pin names,
	  or pin attributes in AKO symbols results in them being automatically
          deselected (without visible explanation).  Note that the only changes
          that can be made to AKO symbols (those that reference another for
          pins and graphics) are to symbol attributes, part name, description 
          and aliases.

        * Grid spacing cannot be changed in the Symbol Editor; changing it in
          the Schematic Editor will change it for the Symbol Editor.

	* You must first initialize the printer by selecting Printer Setup 
          under the File Menu after you have installed Schematics.  After 
	  this is done, Schematics will remember the printer setup and any 
	  further changes made to it.

	* Changing the page size to User-Defined Metric does not work and
	  should be avoided.

	* To change the default title block symbol, you will need to directly
	  change the msim.ini file.  The title block menu item in the 
	  Configuration Menu is disabled.  Using Notepad or any text editor,
	  change the default value in the TITLEBLOCKSYM item from "titleblk"
	  to the name of your title block symbol.  Remove the TITLEBLOCKSYM
	  line entirely if you do not wish a title block to be automatically 
	  added to new pages.

	* The netlister will report a "floating pin" error if you don't have
	  all the signals from a multi-signal offpage connector or global port
	  connected to a pin somewhere on the same page.  A workaround is to
	  add another offpage connector or global port to that page with 
	  exactly the signals that are unused, than to connect a bus with that
	  same name to the bus coming from the original offpage connector or
	  global port.
	  

4.0) SYMBOL LIBRARIES

         Libraries shipped with Schematics and their contents:

         abm.slb      - Behavioral Modeling blocks

         analog.slb   - passive & semiconductor primitives, SCR, xtals

         breakout.slb - parameterized devices for modeling purposes

         global.slb   - global ports, bubble connectors, analog ground

         source.slb   - voltage & current stimulus devices

         special.slb  - simulation pseudodevices (IC, NODESET, etc.) 

	 eval.slb     - symbols for parts in PSpice eval.lib.  Contains
			a sampling of parts from the production libraries.


5.0) ANALOG BEHAVIORAL MODELING LIBRARY (ABM.SLB)

    This library contains a number of basic Behavioral Modeling
    "components," including examples of the VALUE, FREQ, and TABLE
    variants of both E and G devices (see Circuit Analysis User's Guide).

    Each of the components in the library has a pair of output
    pins and one or more pairs of input pins.  E devices (EMULT, etc.)
    produce an output voltage across their output pins.  G devices
    (GMULT, etc.) source current through their output pins.
    The input pins should be hooked up to the controlling voltage(s)
    for the component.  For example, the EMULT component acts as
    an ideal multiplier.  It multiplies the voltage between the
    "IN1" pair of pins by the voltage between the "IN2" pair of
    pins and produces an output across the "OUT" pair of pins.

    PSpice expressions used in Analog Behavioral Modeling (ABM)
    refer to voltages at nodes and voltages between nodes.  In
    Schematics, we generally do not have access to node names as
    these are assigned by the netlister.  The approach used by
    components in ABM.SLB is to connect up controlling voltages
    to pins on ABM components.  The normal netlist generation
    mechanism then assigns nodes and replaces pin references with
    node identifiers.

    In order to make the expressions used in the ABM devices easy
    to modify, they are set up as the default value of the EXPR
    attribute of the components.

    For an example of what will appear in the netlist when one of
    these components is used, let's look at the EVALUE device.
    This is set up as a buffer.  It has two input pins ("IN+" & "IN-")
    and two output pins ("OUT+" & "OUT-").
    Its template looks like this:

	E^@REFDES %OUT+ %OUT- VALUE = { @EXPR }

    where the EXPR attribute has default the value of V(%IN+, %IN-).
    Suppose we hook up one of these devices ("U33") to inputs that
    will become nodes 101 & 102, and to outputs that will become
    nodes 201 & 202.  First, the netlister substitutes attributes
    in the template line, so that

	E^@REFDES %OUT+ %OUT- VALUE = { @EXPR }

    becomes:

        E^U33 %OUT+ %OUT- VALUE = { V(%IN+, %IN-) }

    Next, the netlister substitutes node identifiers for pin names
    giving:

	E_U33 202 201 VALUE = { V(102, 101) }


6.0) NETLIST TEMPLATE SYNTAX

         There is no information in the manual on the syntax used
         to define the netlist template in electrical symbols.  A
         synopsis and several examples follow:

         The template contains regular characters that are copied
         to the netlist, and special items such as attributes, that
         are translated before being copied to the netlist.  The
         translation process is repeated until there are no more
         attributes left in the template.

         Regular characters include alphanumerics, '$' and '_', white
         space, and some punctuation marks.

         Attribute names are denoted by an identifier preceded by one
         of the following special characters:

                            @  ?  ~  #  &

         Attribute processing is determined by the character preceding
         the attribute name:

         @<id>        replaced by the value of <id>.  Error if
                      no <id> attribute or if no value assigned.

         &<id>        replaced by the value of <id> if <id> defined.

         ?<id>s...s   replaced by text between s...s if <id> defined.

         ~<id>s...s   replaced by text between s...s if <id> undefined.

         #<id>s...s   like ? but delete rest of template if <id> undefined.

         In the above, 's' can be any non-alphanumeric character.
         These conditional attribute constructs can be nested by using
         different separator characters.

         The '^' character is also special.  It is replaced by the
         complete hierarchical path to the device being netlisted.

         The sequence '\n' is replaced by a newline.  This allows
         a multiline netlist entry to be generated from a one-line
         template.

         Pin names are indicated by a '%' character followed by one
         or more regular characters.  A pin name in the template is
         replaced by the name of the node connected to that pin.
         The pin name is everything after the '%' to a separator
         (white space or comma).  Some characters in pin names are
         translated to avoid problems with Probe:

                  <      is replaced by l (L)
                  >      is replaced by g
                  =      is replaced by e
                  \XXX\  is replaced by XXXbar

         Any devices generated by a netlist template must start
         with a letter acceptable to PSpice for that particular
         kind of device (e.g., 'Q' for a bipolar transistor).  To
         ensure this, devices in the Schematics symbol libraries
         start with a prefix letter, the hierarchical path, and
         then the reference designator attribute. For example:

                  R^@REFDES ........   for a resistor

         We strongly recommend that users adopt this scheme.

         Examples:

             Simple Resistor
	 
                  This has attributes for REFDES and VALUE, both of
                  which are required.  It has two pins, "1" and "2".

                  A suitable template would be:

                            R^@REFDES %1 %2 @VALUE

                  A device with REFDES = R23 and VALUE = 1k
                  connected to nodes abc and def would generate:

                            R_R23 abc def 1k


             Voltage Source with optional AC and DC specifications

                  This has two attributes, AC and DC.  It has two
                  pins, "+" and "-".

                  A suitable template would be:

                            V^@REFDES %+ %- ?DC|DC=@DC| ?AC|AC=@AC|

                  A device with REFDES = V6 connected to nodes vp and
                  vm, with DC set to 5v and AC undefined would
                  generate:

                            V_V6 vp vm DC=5v

                  or with AC set to 1v would generate:

                            V_V6 vp vm DC=5v AC=1v


             Parameterized Subcircuit Call

                  Suppose we have a subcircuit Z that has two pins
                  "a" and "b" and has a subcircuit parameter G.  If
                  G is undefined, the value 1000 is to be supplied.
                  We use an attribute, G, to allow the parameter to be
                  changed on the schematic.

                  A suitable template would be:

                            X^@REFDES %a %b Z PARAMS: ?G|G=@G| ~G|G=1000|

                  A device U33 connected to nodes 101 and 102 and with
                  G set to 1024 would generate:

                            X_U33 101 102 Z PARAMS: G=1024

                  or with G undefined would generate:

                            X_U33 101 102 Z PARAMS: G=1000


7.0) CREATING NEW PARTS/SYMBOLS

	If the part you want is not in our library and you do not have
	a .MODEL or .SUBCKT to define the part, then one will need to be
	created.  This may involve using Parts, for instance, or calling
	the part manufacturer to request a SPICE model.  (Parts is not
	currently executable from the Schematics environment.)

	Once there is a model/subcircuit definition, a symbol needs to be
	created.  This is done using the Symbol Editor from within the
	Schematics environment.  See the Symbol Editor tutorial below.

	Things to watch out for:

	  - The new part's model/subcircuit definition will most likely be
	    in a library file which is not referenced in NOM.LIB, so a
	    .LIB statement will need to be generated for the "new" library.
	    In Schematics, this is done by placing a LIB symbol (from
	    SPECIAL.SLB) on the schematic.

	  - The symbol that gets created for the new part will most likely
	    reside in a "new" symbol library which is not referenced in
	    MSIM.INI, so MSIM.INI must be edited to include a reference to
	    this symbol library.


8.0) SYMBOL EDITOR TUTORIAL

	Using the Symbol Editor

	The symbol editor allows you to create new parts and libraries 
	and edit existing parts and libraries for use in the schematic 
	editor.

      	NOTE:  Changes made to parts in the symbol editor have a global 
	       implication; any changes will affect all instances of the 
	       part modified.

	This tutorial will show you how to accomplish the following:

      		1.  Invoke the symbol editor from the schematic editor.

      		2.  Edit the definition for a selected part.  You can edit
		    the symbol definition in the following ways:

            	    a.  Edit the name and description.

            	    b.  Edit the graphics and pins, or create new 
			graphics.

            	    c.  Adjust the pin names and numbers.

            	    d.  Edit the attributes.


	Invoking the Symbol Editor to Edit a Symbol

      		1.  From the schematic editor, choose Open from the File
		    Menu.

      		2.  Select example.sch from the list in the dialog box
	   	    and choose OK.

      		3.  On the schematic, click the left mouse button on the 
		    zigzag portion of resistor RS2 to select it.  (This 
		    resistor is located on the right side of the schematic.)  
		    The selected portion changes color to indicate that it is 
		    selected.  (If you have not changed the default colors, 
		    the zigzag portion changes from green to red.)  You can 
		    change the default colors in the msim.ini file.

	NOTE:  If you have difficulty determining which resistor is RS2 due 
	       to the size of the schematic on your screen, select a resistor 
	       by clicking on it with the mouse.  Then choose In from the Zoom 
	       Menu to see the part at closer range.  A crosshair appears.  
	       Position the crosshair in the center of the area you wish to 
	       view, and click the mouse.  You can repeat this process until 
	       the viewing area is large enough to suit your needs. 

      		4.  With resistor RS2 selected, choose Symbol from the Edit 
		    Menu.  The Symbol command invokes the symbol editor.

      		5.  The menu bar changes to that of the symbol editor.  The
		    resistor symbol you selected appears on the screen, 
		    enlarged and ready for editing.
	Editing the Symbol Definition

	The symbol definition consists of a symbol's graphics, pins, and 
	attributes.

	To edit the description:

      		1.  Choose Definition from the Part Menu.

      		2.  The Definition dialog box appears, displaying the 
		    following items:

            	Description     The textual description of the symbol.
      
            	Part Name       The most commonly used full name of the
				part.

            	Alias List      The exact electrical equivalents of the
				part that can be used to reference the
				symbol.

            	AKO Name        Specifies that the symbol will use the 
				graphics, pins, and attributes of an-
				other part.  Attributes on the symbol
				being edited will override those from
				the named part, and new attributes may
				be added.

            	Type            The symbol types include:  primitive, 
				port, annotation, border, and title 
				block.			

	For this tutorial, we will edit only the Description.  (Changing 
	the Part Name field in the tutorial would invalidate the tutorial 
	schematic, since the original part name for the resistor symbol 
	would not be able to be found.)

      		3.  In the Description field of the dialog box, replace the 
		    description with the words "special resistor."

      		4.  Then Choose OK to produce the change.  You will see no 
		    change in the symbol on your screen.  However, the 
		    description	of the symbol changes in the Get New Part 
		    menu item in the schematic editor Draw Menu. 

	To edit the graphics:

	So that you can see how symbol graphics are created and modified, we 
	will replace the graphical representation of resistor RS2 with a 
	simple rectangle shape.

      		1.  Select the "zigzag portion" of the resistor symbol by 
		    positioning the mouse cursor slightly above and to the 
		    left of the zigzags.

                    a.  Hold down the left mouse button and move the mouse
			to the right and down, so that the expanding rectangle
			encloses the zigzag portion of the resistor only.

            	    b.  Release the button when the selection box surrounds 
			the zigzag portion of the resistor.

      		2.  Choose Cut from the Edit Menu to delete the zigzag portion.

      		3.  To replace the zigzags with a rectangle, choose Box from
		    the Graphics Menu.  The cursor changes to a pencil shape.

      		4.  Move the pencil to a position on the dotted line at the
		    top of symbol's bounding box, directly over the space 
		    where the zigzags began.  Click the left mouse button.

      		5.  Move the cursor to the right and down toward the bottom
		    dotted line of the bounding box.  You will see the outline 
		    of a rectangle appear.  When the rectangle outline fills 
		    the space between the top and bottom dotted lines, in the 
		    area in which the zigzags were removed, click the mouse 
		    button to fix the rectangle and end the mode.

	You have now edited the graphics for this "special resistor."


	To adjust the pin names and numbers:

	With the Pin List command you can change the pin names, display types,
	and orientation of the pins.  You can edit all of the pins by using 
	one dialog box, or you can edit an individual pin by double-clicking 
	on the desired pin.  For this example, we will change the display of 
	the pin	names of the two pins on resistor RS2, so that they will appear 
	on the schematic.

      		1.  Choose Pin List from the Part Menu to bring up the Pin
		    List dialog box.

      		2.  Click the left mouse button on the number "1" in the box
		    in the upper right corner of the Pin List dialog box to 
		    select pin 1 to modify.

      		3.  Click on the circle to the left of Display Name in the
		    dialog box to enable the feature.  A black dot appears 
		    within the circle to show that it is enabled.  With 
		    Display Name enabled, the pin name will appear on your 
		    screen.

      		4.  Click on the Save Pin button at the bottom of the dialog
		    box to save the change to the pin.

      		5.  Now click on the number "2" in the box in the upper right
		    corner of the Pin List dialog box.  Repeat steps 3 and 4 
		    to cause the name for Pin 2 to be displayed on your 
		    schematic.  Then choose OK to produce the changes.  You 
		    will see the name for Pin 1 and Pin 2 displayed on the 
		    screen.


	To edit a symbol attribute:

	We will add a new attribute for resistor RS2, by giving it a "part 
	identification number."

      		1.  Choose Attributes from the Part Menu.

      		2.  In the Attributes dialog box, enter "partid" in the Name
		    field.

      		3.  Press the Tab key or click the left mouse button to 
		    position the cursor in the Value field.  Then enter "345" 
		    in the Value field.

      		4.  Click on the circle to the left of Display Value to 
		    enable the value to be visible on the screen.

      		5.  Click on the Save Attr button at the bottom of the dialog
		    box to temporarily save the attribute to the list of 
		    attributes appearing on the right side of the dialog box.

      		6.  Choose OK to produce the change.  This incorporates the 
		    new attribute into the attribute list.  You should see 
		    the value of the new partid attribute on your symbol.

	You can move the attributes displayed on the symbol.  Let's move the 
	partid attribute and center it within the symbol rectangle.


	To move the partid number:

      		1.  Click on the partid attribute (345) to select it.

      		2.  With the mouse cursor pointed at the partid attribute, 
		    hold down the left mouse button and drag the attribute to 
		    the new location.  Release the mouse button to place the 
		    attribute at its new location.
      

	To save the symbol and exit from the symbol editor:

      		1.  Choose Save from the Part Menu to save the symbol.

      		2.  Choose Save As from the File Menu to save the part to 
		    another library (in this case, tutorial.slb).

      	NOTE:  You would choose Save from the File Menu if you wanted to save 
	the changed part to the current library.  However, choosing this menu 
	item while working in the tutorial would result in a global change to 
	the resistor symbol.

      		3.  Choose Exit from the File Menu to return to the schematic
		    editor.