/*
 EPSHeader

   File: trim.e
   Author: J. Kercheval
   Created: Sat, 09/11/1990  21:49:49
*/

/*

    These two routines add functions to trim whitespace from the end
    of the line.  These are in the category of trivia functions for
    those of us who cannot stand an extra space or two at the end
    of our lines.
        
    trim_region() trims all lines between point and mark while 
    trim_buffer() trims all lines in the current buffer.
        
        John Kercheval
        127 NW Bowdoin Pl #105
        Seattle, WA  98107-4960
        October 24, 1990
            
*/

#include "eel.h"

command trim_region()
{
  int spot;

  say("Trimming region.");
	if (point > mark) {
		spot = mark;
		mark = point;
		point = spot;
	}
	if (nl_reverse())
		point++;
  spot = point;
	while (point < mark) {
		if (nl_forward() != 0) {
      point--;
      if (point < mark) {
        re_search(-1, "[ \t]*");		/* to beginning of area */
        delete(point, point + parse_string(1, "[ \t]*", (char *) 0));
        point++;
      }
    }
    check_abort();
  }
	mark = spot;
  say("Trim of region complete.");
	this_cmd = iter = 0;
}

command trim_buffer()
{
  say("Trimming %s.",bufname);
  point = 0;
  while (nl_forward()) {
		check_abort();
    point--;
    re_search(-1, "[ \t]*");		/* to beginning of area */
    delete(point, point + parse_string(1, "[ \t]*", (char *) 0));
    point++;
  }
  re_search(-1, "[ \t]*");		/* to beginning of area */
  delete(point, point + parse_string(1, "[ \t]*", (char *) 0));
  say("Trim of %s complete.",bufname);
	this_cmd = iter = 0;
}
