/************************************************************************
* "Epsilon", "EEL" and "Lugaru" are trademarks of Lugaru Software, Ltd. *
*                                                                       *
*  Copyright (C) 1988, 1990 Lugaru Software Ltd.  All rights reserved.  *
*                                                                       *
* Limited permission is hereby granted to reproduce and modify this     *
* copyrighted material provided that the resulting code is used only in *
* conjunction with Lugaru products and that this notice is retained in  *
* any such reproduction or modification.                                *
************************************************************************/

/*
* Changes to code Copyright (C), 1991 by K. Shane Hartman.  You are free
* to distribute them so long as you do not forbid anyone else to use them 
* or charge more than a reasonable fee for distribution and Lugaru's
* Copyright terms above are observed.  This notice must be preserved in 
* addition to the notice above.  Most changes are marked KSH.  This file
* replaces Lugaru's tags.e, just compile, load and save state.  Send bugs,
* comments, suggestions to shane@ai.mit.edu.
* 
* Version 1.3: 7/17/91 shane@ai.mit.edu
* Version 1.4: 7/17/91 shane@ai.mit.edu Commented call to push_point.  Its not 
*                      in this file.  You should uncomment it if you have 
*                      pointsk.e.
* Version 1.5: 7/26/91 shane@ai.mit.edu Corrected handling of C++ comments in
*                      skip_c_comments and traverse_c_exp.  Replaced some calls
*                      to parse_string with looking_at which I had erroneously 
*                      changed before (broke tagging defines).
*
* The changes here accomplish the following:
* 
* [1] Faster tagging by use of insertion sort instead of always resorting
*     the whole buffer when only a small number of tags have been added.
*
* [2] Smarter C tagging (will tag typedef structs, structs and function
*     like macros).
*
* [3] M-x tag-project command will tag a whole slew of directories.
*
* [4] Quoting of special characters (for regex) so that tagging 
*     languages like Lisp will work (*global-foo*).
*/

#include "eel.h"

/*
 * A list of subdirectories or absolute directories that tag-project will 
 * search in.  It is semicolon separated list just like PATH environment 
 * variable.  If a component is not absolute, it will be interpreted as 
 * relative to project_directory variable.  For example, suppose that 
 * project_directory is "c:\project" and this variable is set to
 * ".;foo;d:\bar", then the following directories will be tagged, in order,
 *
 *  the current directory
 *  c:\project\foo
 *  d:\bar
 */
char project_directories[256] = "";
/* 
 * This is the root pathname for the tag-project command. Directories 
 * mentioned in project_directories are interpreted as relative to this.  It 
 * should be absolute, for example, "c:\project".
 */
char project_directory[FNAMELEN] = "";

char initial_tag_file[FNAMELEN] = "tags"; /* KSH */
char tag_relative = 0; 
char *retag;

#undef NULL
#define NULL ((char *)0)

#undef void
#define void int

when_loading ()
{
  retag = NULL;
}

void init_tags ()
{
  char buf[FNAMELEN];

  if (!exist ("-tags"))
  {
    strcpy (buf, initial_tag_file);
    absolute (buf);
    load_tags (buf);
  }
}

void load_tags (file)
char *file; 
{
  char *oldbuf = bufname;
  int i;

  zap ("-tags");
  bufname = "-tags";
  i = read_file (file, strip_returns.default);
  case_fold = case_fold.default;        /* KSH */
  bufname = oldbuf;
  if (i && i != 2)
  {
    delete_buffer ("-tags");
    quick_abort ();
  }
}

void insert_tags (from, to)
char *from;
char *to;
{
  char tagline[100];
  char func[100];
  
  bufname = to;
  point = 0;
  bufname = from;
  point = 0;
  while (parse_string (1, "[^;\n \t]+;[^;\n \t]+;[0-9]+$", tagline))
  {
    char *tail = index (tagline, ';');

    tail[0] = 0;
    bufname = to;
    while (parse_string (1, "[^;\n \t]", func))
    {
      if (strfcmp (tagline, func) <= 0)
      {
        to_begin_line();
        break;
      }
      nl_forward ();
    }
    tail[0] = ';';
    bprintf ("%s\n", tagline);
    bufname = from;
    point++;                            /* Over the newline */
  }
}

/* save tags to their file if unsaved */
void do_save_tags ()
{
  char *oldbuf = bufname;

  if (exist ("-tags"))
  {
    bufname = "-tags";
    if (modified)
    {
      if (!retag)
      {
        sayput ("Sorting tags...");
        /* saved tags must always be sorted */
        sort_another ("-tags");
      }
      else
      {
        insert_tags (retag, "-tags");
      }
      bufname = "-tags";
      do_save_file (1, 1, 1);
    }
    bufname = oldbuf;
  }
}

void re_enquote (targ, source)
char *targ;
char *source;
{
  char ch;
  while (ch = *source++)
  {
    if (index ("^*%()\\[]|", ch)) *targ++ = '%';
    *targ++ = ch;
  }
  *targ++ = '\0';
}

char tag_mat[80]; /* value returned by tag_match during completion */

char *tag_match (s, start) 
char *s;
{
  char quoted[80];
  char *oldbuf = bufname, *res = 0, tmp[80];
  int found;
  int old_fold = case_fold;
  
  case_fold = 0;
  re_enquote (quoted, s);               /* KSH */
  bufname = "-tags";
  if ((start & STARTMATCH) && modified)
    do_save_tags ();
  if (start & STARTMATCH)
  {
    point = 0;
    sprintf (tmp, "\n%s", s);
    if (!parse_string (1, quoted, NULL) && *quoted) /* KSH */
      search (1, tmp);
    to_begin_line();
  }
  if ((!*quoted || parse_string (1, quoted, NULL)) /* KSH */
      && (found = parse_string (1, "^[^;\n]+;", tag_mat))) 
  {
    tag_mat[found - 1] = 0;
    nl_forward ();
    res = tag_mat;
  }
  bufname = oldbuf;
  case_fold = old_fold;
  return (res);
}

void get_tag (res, pr) /* do completion on tags */
char *res, *pr;
{
  comp_read (res, pr, tag_match, 0, "");
}

void go_tag (s)  /* if none, go to next tag */
char *s;
{
  short resp;

  if (do_go_tag(s))
    return;
  do
  {
    sayput ("Tag %s has moved, retag file %s [Y]? ", s, filename);
    refresh ();
    resp = tolower (getkey());
    check_abort ();
  } while (!index ("yn \r\n", resp));
  say ("");
  if (resp != 'n')
  {
    do_retag_file (filename);
    if (!do_go_tag (s))
      error ("Tag %s is not in file %s", s, filename);
  }
}

void do_go_tag(s)   /* go to tag s and return nonzero, or 0 if we can't */
char *s;    /* if s is empty, use next tag & fill in s */
{
  char pat[150], *oldbuf = bufname, *file, *p;
  char quoted[150];                     /* KSH */
  int pos;

  re_enquote (quoted, s);               /* KSH */
  bufname = "-tags";                    
  if (*quoted)
  {
    sprintf (pat, "^%s;.*", quoted);
    point = 0;
    if (!re_search (1, pat))
      error ("%s is not in the tag list", s);
  } 
  else if (!re_search(1, "^.*;.*"))
    error ("no more tags");
  grab (matchstart, point, pat);  /* tag, file, line # */
  file = index (pat, ';');
  *file++ = 0;
  if (!*quoted)                         /* KSH */
  {
    strcpy(s, pat);                     /* save tag */
    re_enquote (quoted, s);             /* KSH */    
  }
  p = index (file, ';');    /* find start of line # */
  pos = strtoi (p + 1, 10);
  *p = 0;
  bufname = oldbuf;
  absolute (file);
#ifdef HAVE_PUSH_POINT
  push_point ();                        /* This is in pointsk.e */
#endif  
  locate_window ("", file);
  find_it (file, strip_returns.default);
  sprintf (pat, "%s[^a-zA-Z0-9_]", quoted);
  point = pos;
  return (parse_string (1, pat, NULL));
}

command
select_tag_file () on cx_tab[ALT(',')]
{       /* switch to a particular tags file */
  char file[80], *def, *old = bufname;

  do_save_tags ();
  bufname = "-tags";
  def = exist ("-tags") ? filename : initial_tag_file;
  bufname = old;
  get_file (file, "Tag file", def);
  load_tags (file);
  say ("Tags loaded from %s", file);
}

command 
clear_tags ()                           /* erase all tags */
{
  init_tags ();
  zap ("-tags");
  do_save_tags ();
}

command
tag_files () on cx_tab[ALT('.')]
{
  char pat[FNAMELEN], *s;

  init_tags ();
  get_file (pat, "Add/update tags for files matching", filename);
  iter = 0;
  s = file_match (pat, 2);
  if (!s)
    error ("No matches");
  for (; s; s = file_match (pat, 0))
  {
    delete_tags (s);
    tag_a_file (s);
  }
  do_save_tags ();
  say ("%s tagged.", pat);
}

void tag_a_file (s)
char *s;
{
  char subr[40], *ext, *orig = bufname, *temp = 0;
  int ok, err = 0, opoint;

  if (!look_file(s))
  {
    if (!temp)
      temp = temp_buf ();
    bufname = temp;
    err = read_file (s, strip_returns.default);
    if (!err)
      call_mode (filename);
  }
  if (!err)
  {
    ext = get_extension (s);
    sprintf (subr, "tag-suffix-%s", *ext ? (ext + 1) : "none");
    opoint = point;
    point = 0;
    ok = try_calling (subr) || try_calling ("tag-suffix-default");
    point = opoint;
  }
  bufname = orig;
  if (temp)
    delete_buffer (temp);
  if (err)                              /* couldn't read file */
    quick_abort ();                     /* already showed error msg */
  else if (!ok)
    error ("Don't know how to tag the file %s", s);
}

void add_tag (func, file, pos)
char *func, *file;
{
  char rel[FNAMELEN];
  char *oldbuf = bufname;
  
  if (tag_relative)
  {
    /* use relative version instead */
    relative (file, rel);
    file = rel;
  }
  say ("Adding %s in %s", func, file);
  bufname = "-tags";
  modified = 1;
  point = 0;
  if (retag)
  {
    char comp[100];
    
    bufname = retag;
    point = 0;
    while (parse_string (1, "^[^; \t\n]+", comp))
    {
      if (strcmp (comp, func) <= 0)
      {
        to_begin_line();
        break;
      }
      nl_forward ();
    }
  }
  bprintf ("%s;%s;%d\n", func, file, pos);
  bufname = oldbuf;
}

void do_retag_file (file)
char *file;
{
	jmp_buf *old_level = top_level;
  jmp_buf this_level;
  int ret;
  
  retag = "-retag";
  top_level = &this_level;
  if (ret = setjmp (top_level))         /* the verbose way of saying */
  {                                     /* unwind-protect, fuck you, C */
    delete_buffer (retag);
    retag = NULL;
    top_level = old_level;
    longjmp (top_level, ret);
  }
  zap (retag);
  delete_tags (file);
  tag_a_file (file);
  do_save_tags ();
  delete_buffer (retag);  
  top_level = old_level;
  retag = NULL;
}

void delete_tags (file)   /* delete all tags pointing to file */
char *file;
{
  int start;
  char rel[FNAMELEN], pat[FNAMELEN], *oldbuf = bufname;

  if (tag_relative)
  {
    /* use relative version instead */
    relative (file, rel);
    file = rel;
  }
  bufname = "-tags";
  point = 0;
  sprintf (pat, ";%s;", file);
  while (search (1, pat)) 
  {
    to_begin_line();
    start = point;
    nl_forward ();
    delete (start, point);
  }
  bufname = oldbuf;
}

/* tag all labels or procs in the file */
void tag_suffix_asm ()
{
  char func[70];
  int start;
  int old_fold = case_fold;

  case_fold = 1;
  while (re_search (1, "^[ \t]*([a-z0-9@$_]+)[ \t]*:"))
  {
    grab (start = find_group (1, 1), find_group (1, 0), func);
    add_tag (func, filename, start);
  }
  point = 0;
  while (re_search (1, "^[ \t]*([a-z0-9@$_]+)[ \t]+proc[ \t\n;]+"))
  {
    grab (start = find_group (1, 1), find_group (1, 0), func);
    add_tag (func, filename, start);
  }
  case_fold = old_fold;
}

void pathname_as_directory(spec)             /* KSH */
char *spec;
{
  int i = strlen (spec);
  if (i && !is_path_separator (spec[i - 1]))
  {
		spec[i] = path_sep, spec[i + 1] = 0;    /* add final / if none */
  }
}

void init_tags_path()                        /* KSH */
{
  strcpy(initial_tag_file, project_directory);
  pathname_as_directory(initial_tag_file);
  strcat(initial_tag_file, "tags");
}
 
void init_tags_default()                     /* KSH */
{
  struct file_info finfo;

  if (!check_file(initial_tag_file, &finfo))
  {
    init_tags_path();
  }
	init_tags();
}

command tag_project()                   /* KSH */
{
  char str[sizeof(project_directories)];
  char *s = str;
  char *ss = s;
  char files[80];
  char *fs;
  int i;
  char *hfiles = "*.h";
  char *cfiles = "*.c";
  char *ext = cfiles;

  if (has_arg)
  {
    ext = hfiles;
  }
  iter = 0;
  delete_buffer ("-tags");
  init_tags_path();
  init_tags();
  while (1)
  {
    strcpy (str, project_directories);
    s = str;
    while (s)
    {
      ss = index (s, ';');
      if (ss) *ss++ = 0;
      if (strcmp (s, ".") == 0)
      {
        strcpy (files, project_directory);
      }
      else
      {
        strcpy (files, s);
        absolute (files);
        if (strcmp (files, s) != 0)
        {
          strcpy (files, project_directory);
          pathname_as_directory (files);
          strcat (files, s);
        }
      }
      pathname_as_directory (files);    
      strcat (files, ext);
      s = ss;
      for (fs = file_match (files, 2); fs; fs = file_match (files, 0)) 
      {
        tag_a_file (fs);
      }
    }
    if (ext == cfiles)
      ext = hfiles;
    else
      break;
  }
  do_save_tags ();
}

command pluck_tag() on cx_tab[',']
{		 /* read a function name at point & go there via tags */
	char tag[80];

  init_tags_default ();                 /* KSH */
	iter = 0;
	point--;
	re_search(1, word_pattern);
	re_search(-1, word_pattern);
	grab(point, matchstart, tag);
	go_tag(tag);
}

command goto_tag() on cx_tab['.'] /* asks for a tag, then goes there */
{
	char tag[80];

	init_tags_default();                  /* KSH */
	iter = 0;
	if (!has_arg)
		get_tag(tag, "Find tag [next tag]: ");
	else
		*tag = 0;
	go_tag(tag);
}

tag_suffix_e () { tag_suffix_c(); }
tag_suffix_h () { tag_suffix_c(); }

/*
*** KSH - Completely rewrote tags c shit 
*/

#define C_THING "([[\"'{(])|(#[a-z]+)|(/%*)|(//)|([a-zA-Z0-9_]+)"

/*
 * The following stuff is from my port of Gnu c-indenter. It does not hurt to 
 * load it twice, I included it here so that this file could stand alone.
 * You can defines HAVE_C_INDENTER to skip the compilation if you have it.
 */
#ifdef HAVE_C_INDENTER

void skip_c_comments();
int looking_at();
int traverse_cexp();
int matchend;

#else

int matchend = 0;
char matching_ends[] = "][]}{})()\"\"''";
char opening_ends[] = "[{(";
char closing_ends[] = "]})";

int looking_at (dir, pat, res)
int dir;
char *pat;
char *res;
{
  int start = point;
  int ret = 0;
  char fmh[256];
  
  matchend = start;
  if (!res) res = fmh;
  if (parse_string (dir, pat, res))
  {
    matchend = point;
    ret = 1;
  }
  point = start;
  return (ret);
}

char matching_end (c)
char c;
{
  char *s = index (matching_ends, c);
  
  if (s == NULL) 
    return (0);
  else 
    return (s[1]);
}

#define opening_end(c) (index (opening_ends, (c)) != NULL)

#define closing_end(c) (index (closing_ends, (c)) != NULL)

#ifndef opening_end
int opening_end (c) 
char c;
{
  return (index (opening_ends, c) != NULL);
}
#endif

#ifndef closing_end
int closing_end (c) 
char c;
{
  return (index (closing_ends, c) != NULL);
}
#endif

int is_slashified (dir)
int dir;
{
  int pos = point;
  int slash_count = 0;

  if (dir > 0) pos--;
  while ((pos-- > 0) && (character (pos) == '\\'))
    slash_count++;
  return (slash_count & 1);
}

void skip_c_comments(dir)
int dir;
{
  int offset = 1;
  int last = size();
  
  if (dir != 1) 
  {
    dir = -1;
    offset = 0;
  }
  while (re_search (dir, "[^ \t\n\f]") && (point > 0) && (point < last))
  {
    char c = character (point - offset);
    char cc = character (point - offset + dir);
    
    if (c == '/')
    {
      if (cc == '*')
        search (dir, dir > 0 ? "*/" : "/*");
      else if (cc == '/')		/* c++ comment */
      {
        if (dir > 0)
          nl_forward ();
        else
          point--;
      }
    }
    else
    {
      if (dir > 0) point -= dir;
      break;
    }
  }
}

int traverse_cexp (dir)
int dir;
{
	int level = 0;
  int orig = point;
  char c = 0;
  char start = 0;
  char end = 0;
  int offset = 1;
  char buf[2];
  char patbuf[32];
  
  if (dir != 1) 
  {
    dir = -1;
    offset = 0;
  }
  if (dir > 0 && point < size () && index (":;?,", character (point)))
    point++;
  skip_c_comments (dir);
  if (!index (matching_ends, character (point)))
  {
    if (re_search(dir, "[][)(}{\"';:,? \t\n\f]"))
    {
      point -= dir;
      return (1);
    }
    return (0);
  }
  else if ((opening_end(character (point)) && dir > 0) ||
           (closing_end(character (point)) && dir < 0) ||
           (character (point) == '"') ||
           (character (point) == '\''))
  {
    if (dir < 0) point++;
    strcpy (patbuf, "[][)(}{\"']|/%*|%*/|//");
    while (re_search (dir, patbuf))
    {
      buf[0] = c = character (point - offset);
      buf[1] = 0;
      if (start == 0) 
      {
        start = c;
        end = matching_end (start);
        if (!end) 
          start = 0;
        else
        {
          strcpy (patbuf, "%X|%X|[\"']|/%*|%*/|//");
          patbuf[1] = start;
          patbuf[4] = end;
        }
      }
      if (c == '"' || c == '\'')
      { 
        char strpat[8];
        
        strcpy (strpat, "%X|\n");
        strpat[1] = c;
        while (re_search (dir, buf) && is_slashified (dir));
        if (character (point - 1) == '\n')
          break;
      }
      else if (c == '*')
      {
        search (dir, dir > 0 ? "*/" : "/*");
      }
      else if (c == '/')		/* c++ comment */
      {
        if (dir > 0)
          nl_forward ();
      }
      if (c == start)
        level++;
      if (c == end && !--level)
        break;
    }
    return (level == 0 && start != 0);
  }
  else
  {
    point = orig;
    return (0);
  }
}

#endif /* HAVE_C_INDENTER */

tag_suffix_c()   /* tag all c functions in this file */
{
  int end;

  while (re_search (1, C_THING)) 
  {
    char c;
    
    end = point;    /* find {, comment open, or ident */
    point = matchstart;
    c = character (point);
    if (c == '{' || c == '"' || c == '\'' || c == '(' || c == '[')
    {
      traverse_cexp (1);
    }
    else if (c == '/')
    {
      skip_c_comments (1);
    }
    else if (!good_c_tag ())
    {
      point = end;
      if (c == '#') re_search (1, "[^\\]\n");
    }
  }
}

/* return 1 if at a valid c func def & tag it */
good_c_tag ()
{
  char func[150];
  int start = point;
  int good = 0;
  
  if (character (point) == '#') 
  {
    if (looking_at (1, "#define[ \t]+", NULL))
    {
      start = point = matchend;
      if (parse_string (1, "[a-zA-Z0-9_]+", func))
      {
        if (character (point) == '(')
        {
          good = 1;
          add_tag (func, filename, start);
          re_search (1, "[^\\]\n");
        }
      }
    }
  }
  else if (looking_at (1, "struct", NULL))
  {
    point = matchend;
    skip_c_comments (1);
    start = point;
    if (parse_string (1, "[a-zA-Z0-9_$]+", func))
    {
      skip_c_comments (1);
      if (character (point) == '{')
      {
        add_tag (func, filename, start);
        good = 1;
        traverse_cexp (1);
      }
    }
  }
  else if (looking_at (1, "typedef", NULL))
  {
    int found = 0;

    point = matchend;
    if (re_search (1, "[ \t\n]+struct[ \t\n]+[a-zA-Z0-9_$]*[ \t\n]*{"))
    {
      int end = point;

      point--;
      if (traverse_cexp (1))
      {
        while (re_search (1, "(/%*)|(//)|;"))
        {
          point = matchstart;
          if (character (point) == ';')
          {
            break;
          }
          skip_c_comments (1);
        }
        end = point;
        re_search (-1, "[ \t\n]*");
        while (parse_string (-1, "[a-zA-Z0-9_]+", func))
        {
          add_tag (func, filename, point);
          found++;
          if (!looking_at (-1, "[ \t\n]*,[ *\t\n]*", NULL))
          {
            break;
          }
          else
          {
            point = matchend;
          }
        }
        point = end;
      }
    }
    good = found;
  }
  else if (parse_string (1, "[a-zA-Z0-9_]+", func))
  {
    while (1)
    {
      if (character (point) == '(')
        break;
      if (index (" \t\n/", (int) character (point)))
      {
        int pos = point;
        
        skip_c_comments (1);
        if (point == pos) break;
      }
      else
        break;
    }    
    if (character (point) == '(')
    {
      if (traverse_cexp (1))
      {
        if (re_search (1, "([ \t\n]|(/%*([^*]|%*[^/])*%*/)|//.*)*"))
        {
          if (parse_string (1, "[A-Za-z{]", NULL))
          {
            good = 1;
            add_tag (func, filename, start);
          }
        }
      }
    }
  }
  return (good);
}

