/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include "getch.h"

struct key_values
{
 unsigned char *mnemonic;
 unsigned short key_value;
};
typedef struct key_values KEYS;

#if defined(DOS) || defined(OS2)
#define MAX_NUMBER_KEYS 312
#else
#define MAX_NUMBER_KEYS 248
#endif

KEYS key_table[MAX_NUMBER_KEYS] =
{
#if defined(DOS) || defined(OS2)
/* normal characters */
  {(unsigned char *)"A",KEY_a },
  {(unsigned char *)"B",KEY_b },
  {(unsigned char *)"C",KEY_c },
  {(unsigned char *)"D",KEY_d },
  {(unsigned char *)"E",KEY_e },
  {(unsigned char *)"F",KEY_f },
  {(unsigned char *)"G",KEY_g },
  {(unsigned char *)"H",KEY_h },
  {(unsigned char *)"I",KEY_i },
  {(unsigned char *)"J",KEY_j },
  {(unsigned char *)"K",KEY_k },
  {(unsigned char *)"L",KEY_l },
  {(unsigned char *)"M",KEY_m },
  {(unsigned char *)"N",KEY_n },
  {(unsigned char *)"O",KEY_o },
  {(unsigned char *)"P",KEY_p },
  {(unsigned char *)"Q",KEY_q },
  {(unsigned char *)"R",KEY_r },
  {(unsigned char *)"S",KEY_s },
  {(unsigned char *)"T",KEY_t },
  {(unsigned char *)"U",KEY_u },
  {(unsigned char *)"V",KEY_v },
  {(unsigned char *)"W",KEY_w },
  {(unsigned char *)"X",KEY_x },
  {(unsigned char *)"Y",KEY_y },
  {(unsigned char *)"Z",KEY_z },
  {(unsigned char *)"0",KEY_0 },
  {(unsigned char *)"1",KEY_1 },
  {(unsigned char *)"2",KEY_2 },
  {(unsigned char *)"3",KEY_3 },
  {(unsigned char *)"4",KEY_4 },
  {(unsigned char *)"5",KEY_5 },
  {(unsigned char *)"6",KEY_6 },
  {(unsigned char *)"7",KEY_7 },
  {(unsigned char *)"8",KEY_8 },
  {(unsigned char *)"9",KEY_9 },
  {(unsigned char *)"`",KEY_BQUOTE },
  {(unsigned char *)"-",KEY_MINUS },
  {(unsigned char *)"=",KEY_EQUAL },
  {(unsigned char *)"[",KEY_LBRACKET },
  {(unsigned char *)"]",KEY_RBRACKET },
  {(unsigned char *)"\\",KEY_BSLASH },
  {(unsigned char *)";",KEY_SEMICOLON },
  {(unsigned char *)"'",KEY_FQUOTE },
  {(unsigned char *)",",KEY_COMMA },
  {(unsigned char *)".",KEY_STOP },
  {(unsigned char *)"/",KEY_FSLASH },
  {(unsigned char *)"SPACE",KEY_SPACE },
  {(unsigned char *)"ENTER",KEY_ENTER },
  {(unsigned char *)"TAB",KEY_TAB },
  {(unsigned char *)"ESC",KEY_ESC },
  {(unsigned char *)"BKSP",KEY_BKSP },
  {(unsigned char *)"F1",KEY_F1},
  {(unsigned char *)"F2",KEY_F2},
  {(unsigned char *)"F3",KEY_F3},
  {(unsigned char *)"F4",KEY_F4},
  {(unsigned char *)"F5",KEY_F5},
  {(unsigned char *)"F6",KEY_F6},
  {(unsigned char *)"F7",KEY_F7},
  {(unsigned char *)"F8",KEY_F8},
  {(unsigned char *)"F9",KEY_F9},
  {(unsigned char *)"F10",KEY_F10},
  {(unsigned char *)"F11",KEY_F11},
  {(unsigned char *)"F12",KEY_F12},
  {(unsigned char *)"HOME",KEY_HOME},
  {(unsigned char *)"PGUP",KEY_PGUP},
  {(unsigned char *)"PGDN",KEY_PGDN},
  {(unsigned char *)"CURU",KEY_CURU},
  {(unsigned char *)"CURD",KEY_CURD},
  {(unsigned char *)"CURL",KEY_CURL},
  {(unsigned char *)"CURR",KEY_CURR},
  {(unsigned char *)"END",KEY_END},
  {(unsigned char *)"INS",KEY_INS},
  {(unsigned char *)"DEL",KEY_DEL},
  {(unsigned char *)"CENTER",KEY_NUMCENTER },
  {(unsigned char *)"PLUS",KEY_NUMPLUS},
  {(unsigned char *)"MINUS",KEY_NUMMINUS},
  {(unsigned char *)"SLASH",KEY_NUMSLASH},
  {(unsigned char *)"STAR",KEY_NUMSTAR},
  {(unsigned char *)"NUMENTER",KEY_NUMENTER},
/* shifted characters */
  {(unsigned char *)"S-A",KEY_S_a  },
  {(unsigned char *)"S-B",KEY_S_b  },
  {(unsigned char *)"S-C",KEY_S_c  },
  {(unsigned char *)"S-D",KEY_S_d  },
  {(unsigned char *)"S-E",KEY_S_e  },
  {(unsigned char *)"S-F",KEY_S_f  },
  {(unsigned char *)"S-G",KEY_S_g  },
  {(unsigned char *)"S-H",KEY_S_h  },
  {(unsigned char *)"S-I",KEY_S_i  },
  {(unsigned char *)"S-J",KEY_S_j  },
  {(unsigned char *)"S-K",KEY_S_k  },
  {(unsigned char *)"S-L",KEY_S_l  },
  {(unsigned char *)"S-M",KEY_S_m  },
  {(unsigned char *)"S-N",KEY_S_n  },
  {(unsigned char *)"S-O",KEY_S_o  },
  {(unsigned char *)"S-P",KEY_S_p  },
  {(unsigned char *)"S-Q",KEY_S_q  },
  {(unsigned char *)"S-R",KEY_S_r  },
  {(unsigned char *)"S-S",KEY_S_s  },
  {(unsigned char *)"S-T",KEY_S_t  },
  {(unsigned char *)"S-U",KEY_S_u  },
  {(unsigned char *)"S-V",KEY_S_v  },
  {(unsigned char *)"S-W",KEY_S_w  },
  {(unsigned char *)"S-X",KEY_S_x  },
  {(unsigned char *)"S-Y",KEY_S_y  },
  {(unsigned char *)"S-Z",KEY_S_z  },
  {(unsigned char *)"S-0",KEY_S_0  },
  {(unsigned char *)"S-1",KEY_S_1  },
  {(unsigned char *)"S-2",KEY_S_2  },
  {(unsigned char *)"S-3",KEY_S_3  },
  {(unsigned char *)"S-4",KEY_S_4  },
  {(unsigned char *)"S-5",KEY_S_5  },
  {(unsigned char *)"S-6",KEY_S_6  },
  {(unsigned char *)"S-7",KEY_S_7  },
  {(unsigned char *)"S-8",KEY_S_8  },
  {(unsigned char *)"S-9",KEY_S_9  },
  {(unsigned char *)"S-`",KEY_S_BQUOTE  },
  {(unsigned char *)"S--",KEY_S_MINUS  },
  {(unsigned char *)"S-=",KEY_S_EQUAL  },
  {(unsigned char *)"S-[",KEY_S_LBRACKET  },
  {(unsigned char *)"S-]",KEY_S_RBRACKET  },
  {(unsigned char *)"S-\\",KEY_S_BSLASH  },
  {(unsigned char *)"S-;",KEY_S_SEMICOLON  },
  {(unsigned char *)"S-'",KEY_S_FQUOTE  },
  {(unsigned char *)"S-,",KEY_S_COMMA  },
  {(unsigned char *)"S-.",KEY_S_STOP  },
  {(unsigned char *)"S-/",KEY_S_FSLASH  },
  {(unsigned char *)"S-TAB",KEY_S_TAB },
  {(unsigned char *)"S-F1",KEY_S_F1},
  {(unsigned char *)"S-F2",KEY_S_F2},
  {(unsigned char *)"S-F3",KEY_S_F3},
  {(unsigned char *)"S-F4",KEY_S_F4},
  {(unsigned char *)"S-F5",KEY_S_F5},
  {(unsigned char *)"S-F6",KEY_S_F6},
  {(unsigned char *)"S-F7",KEY_S_F7},
  {(unsigned char *)"S-F8",KEY_S_F8},
  {(unsigned char *)"S-F9",KEY_S_F9},
  {(unsigned char *)"S-F10",KEY_S_F10},
  {(unsigned char *)"S-F11",KEY_S_F11},
  {(unsigned char *)"S-F12",KEY_S_F12},
  {(unsigned char *)"S-HOME",KEY_S_HOME},
  {(unsigned char *)"S-PGUP",KEY_S_PGUP},
  {(unsigned char *)"S-PGDN",KEY_S_PGDN},
  {(unsigned char *)"S-CURU",KEY_S_CURU},
  {(unsigned char *)"S-CURD",KEY_S_CURD},
  {(unsigned char *)"S-CURL",KEY_S_CURL},
  {(unsigned char *)"S-CURR",KEY_S_CURR},
  {(unsigned char *)"S-END",KEY_S_END},
  {(unsigned char *)"S-INS",KEY_S_INS},
  {(unsigned char *)"S-DEL",KEY_S_DEL},
  {(unsigned char *)"S-CENTER",KEY_S_NUMCENTER},
  {(unsigned char *)"S-NUMSTOP",KEY_S_NUMSTOP},
  {(unsigned char *)"S-NUM0",KEY_S_NUM0},
  {(unsigned char *)"S-NUM1",KEY_S_NUM1},
  {(unsigned char *)"S-NUM2",KEY_S_NUM2},
  {(unsigned char *)"S-NUM3",KEY_S_NUM3},
  {(unsigned char *)"S-NUM4",KEY_S_NUM4},
  {(unsigned char *)"S-NUM6",KEY_S_NUM6},
  {(unsigned char *)"S-NUM7",KEY_S_NUM7},
  {(unsigned char *)"S-NUM8",KEY_S_NUM8},
  {(unsigned char *)"S-NUM9",KEY_S_NUM9},
/* control characters */
  {(unsigned char *)"C-A",KEY_C_a  },
  {(unsigned char *)"C-B",KEY_C_b  },
  {(unsigned char *)"C-C",KEY_C_c  },
  {(unsigned char *)"C-D",KEY_C_d  },
  {(unsigned char *)"C-E",KEY_C_e  },
  {(unsigned char *)"C-F",KEY_C_f  },
  {(unsigned char *)"C-G",KEY_C_g  },
  {(unsigned char *)"C-H",KEY_C_h  },
  {(unsigned char *)"C-I",KEY_C_i  },
  {(unsigned char *)"C-J",KEY_C_j  },
  {(unsigned char *)"C-K",KEY_C_k  },
  {(unsigned char *)"C-L",KEY_C_l  },
  {(unsigned char *)"C-M",KEY_C_m  },
  {(unsigned char *)"C-N",KEY_C_n  },
  {(unsigned char *)"C-O",KEY_C_o  },
  {(unsigned char *)"C-P",KEY_C_p  },
  {(unsigned char *)"C-Q",KEY_C_q  },
  {(unsigned char *)"C-R",KEY_C_r  },
  {(unsigned char *)"C-S",KEY_C_s  },
  {(unsigned char *)"C-T",KEY_C_t  },
  {(unsigned char *)"C-U",KEY_C_u  },
  {(unsigned char *)"C-V",KEY_C_v  },
  {(unsigned char *)"C-W",KEY_C_w  },
  {(unsigned char *)"C-X",KEY_C_x  },
  {(unsigned char *)"C-Y",KEY_C_y  },
  {(unsigned char *)"C-Z",KEY_C_z  },
  {(unsigned char *)"C-2",KEY_C_2  },
  {(unsigned char *)"C-6",KEY_C_6  },
  {(unsigned char *)"C--",KEY_C_MINUS  },
  {(unsigned char *)"C-[",KEY_C_LBRACKET  },
  {(unsigned char *)"C-]",KEY_C_RBRACKET  },
  {(unsigned char *)"C-\\",KEY_C_BSLASH  },
  {(unsigned char *)"C-ENTER",KEY_C_ENTER },
  {(unsigned char *)"C-TAB",KEY_C_TAB},
  {(unsigned char *)"C-BKSP",KEY_C_BKSP  },
  {(unsigned char *)"C-F1",KEY_C_F1},
  {(unsigned char *)"C-F2",KEY_C_F2},
  {(unsigned char *)"C-F3",KEY_C_F3},
  {(unsigned char *)"C-F4",KEY_C_F4},
  {(unsigned char *)"C-F5",KEY_C_F5},
  {(unsigned char *)"C-F6",KEY_C_F6},
  {(unsigned char *)"C-F7",KEY_C_F7},
  {(unsigned char *)"C-F8",KEY_C_F8},
  {(unsigned char *)"C-F9",KEY_C_F9},
  {(unsigned char *)"C-F10",KEY_C_F10},
  {(unsigned char *)"C-F11",KEY_C_F11},
  {(unsigned char *)"C-F12",KEY_C_F12},
  {(unsigned char *)"C-HOME",KEY_C_HOME},
  {(unsigned char *)"C-PGUP",KEY_C_PGUP},
  {(unsigned char *)"C-PGDN",KEY_C_PGDN},
  {(unsigned char *)"C-CURU",KEY_C_CURU},
  {(unsigned char *)"C-CURD",KEY_C_CURD},
  {(unsigned char *)"C-CURL",KEY_C_CURL},
  {(unsigned char *)"C-CURR",KEY_C_CURR},
  {(unsigned char *)"C-END",KEY_C_END},
  {(unsigned char *)"C-INS",KEY_C_INS},
  {(unsigned char *)"C-DEL",KEY_C_DEL},
  {(unsigned char *)"C-CENTER",KEY_C_NUMCENTER},
  {(unsigned char *)"C-NUMSTOP",KEY_C_NUMSTOP},
  {(unsigned char *)"C-NUM0",KEY_C_NUM0},
  {(unsigned char *)"C-NUM1",KEY_C_NUM1},
  {(unsigned char *)"C-NUM2",KEY_C_NUM2},
  {(unsigned char *)"C-NUM3",KEY_C_NUM3},
  {(unsigned char *)"C-NUM4",KEY_C_NUM4},
  {(unsigned char *)"C-NUM6",KEY_C_NUM6},
  {(unsigned char *)"C-NUM7",KEY_C_NUM7},
  {(unsigned char *)"C-NUM8",KEY_C_NUM8},
  {(unsigned char *)"C-NUM9",KEY_C_NUM9},
  {(unsigned char *)"C-PLUS",KEY_C_NUMPLUS},
  {(unsigned char *)"C-MINUS",KEY_C_NUMMINUS},
  {(unsigned char *)"C-SLASH",KEY_C_NUMSLASH},
  {(unsigned char *)"C-STAR",KEY_C_NUMSTAR},
  {(unsigned char *)"C-NUMENTER",KEY_C_NUMENTER},
/* alt characters */
  {(unsigned char *)"A-A",KEY_A_a},
  {(unsigned char *)"A-B",KEY_A_b},
  {(unsigned char *)"A-C",KEY_A_c},
  {(unsigned char *)"A-D",KEY_A_d},
  {(unsigned char *)"A-E",KEY_A_e},
  {(unsigned char *)"A-F",KEY_A_f},
  {(unsigned char *)"A-G",KEY_A_g},
  {(unsigned char *)"A-H",KEY_A_h},
  {(unsigned char *)"A-I",KEY_A_i},
  {(unsigned char *)"A-J",KEY_A_j},
  {(unsigned char *)"A-K",KEY_A_k},
  {(unsigned char *)"A-L",KEY_A_l},
  {(unsigned char *)"A-M",KEY_A_m},
  {(unsigned char *)"A-N",KEY_A_n},
  {(unsigned char *)"A-O",KEY_A_o},
  {(unsigned char *)"A-P",KEY_A_p},
  {(unsigned char *)"A-Q",KEY_A_q},
  {(unsigned char *)"A-R",KEY_A_r},
  {(unsigned char *)"A-S",KEY_A_s},
  {(unsigned char *)"A-T",KEY_A_t},
  {(unsigned char *)"A-U",KEY_A_u},
  {(unsigned char *)"A-V",KEY_A_v},
  {(unsigned char *)"A-W",KEY_A_w},
  {(unsigned char *)"A-X",KEY_A_x},
  {(unsigned char *)"A-Y",KEY_A_y},
  {(unsigned char *)"A-Z",KEY_A_z},
  {(unsigned char *)"A-0",KEY_A_0},
  {(unsigned char *)"A-1",KEY_A_1},
  {(unsigned char *)"A-2",KEY_A_2},
  {(unsigned char *)"A-3",KEY_A_3},
  {(unsigned char *)"A-4",KEY_A_4},
  {(unsigned char *)"A-5",KEY_A_5},
  {(unsigned char *)"A-6",KEY_A_6},
  {(unsigned char *)"A-7",KEY_A_7},
  {(unsigned char *)"A-8",KEY_A_8},
  {(unsigned char *)"A-9",KEY_A_9},
  {(unsigned char *)"A-`",KEY_A_BQUOTE},
  {(unsigned char *)"A--",KEY_A_MINUS},
  {(unsigned char *)"A-=",KEY_A_EQUAL},
  {(unsigned char *)"A-[",KEY_A_LBRACKET},
  {(unsigned char *)"A-]",KEY_A_RBRACKET},
  {(unsigned char *)"A-\\",KEY_A_BSLASH},
  {(unsigned char *)"A-;",KEY_A_SEMICOLON},
  {(unsigned char *)"A-'",KEY_A_FQUOTE},
  {(unsigned char *)"A-,",KEY_A_COMMA},
  {(unsigned char *)"A-.",KEY_A_STOP},
  {(unsigned char *)"A-/",KEY_A_FSLASH},
  {(unsigned char *)"A-ENTER",KEY_A_ENTER},
  {(unsigned char *)"A-TAB",KEY_A_TAB},
  {(unsigned char *)"A-ESC",KEY_A_ESC },
  {(unsigned char *)"A-BKSP",KEY_A_BKSP },
  {(unsigned char *)"A-F1",KEY_A_F1},
  {(unsigned char *)"A-F2",KEY_A_F2},
  {(unsigned char *)"A-F3",KEY_A_F3},
  {(unsigned char *)"A-F4",KEY_A_F4},
  {(unsigned char *)"A-F5",KEY_A_F5},
  {(unsigned char *)"A-F6",KEY_A_F6},
  {(unsigned char *)"A-F7",KEY_A_F7},
  {(unsigned char *)"A-F8",KEY_A_F8},
  {(unsigned char *)"A-F9",KEY_A_F9},
  {(unsigned char *)"A-F10",KEY_A_F10},
  {(unsigned char *)"A-F11",KEY_A_F11},
  {(unsigned char *)"A-F12",KEY_A_F12},
  {(unsigned char *)"A-HOME",KEY_A_HOME},
  {(unsigned char *)"A-PGUP",KEY_A_PGUP},
  {(unsigned char *)"A-PGDN",KEY_A_PGDN},
  {(unsigned char *)"A-CURU",KEY_A_CURU},
  {(unsigned char *)"A-CURD",KEY_A_CURD},
  {(unsigned char *)"A-CURL",KEY_A_CURL},
  {(unsigned char *)"A-CURR",KEY_A_CURR},
  {(unsigned char *)"A-END",KEY_A_END},
  {(unsigned char *)"A-INS",KEY_A_INS},
  {(unsigned char *)"A-DEL",KEY_A_DEL},
  {(unsigned char *)"A-PLUS",KEY_A_NUMPLUS},
  {(unsigned char *)"A-MINUS",KEY_A_NUMMINUS},
  {(unsigned char *)"A-SLASH",KEY_A_NUMSLASH},
  {(unsigned char *)"A-STAR",KEY_A_NUMSTAR},
  {(unsigned char *)"A-NUMENTER",KEY_A_NUMENTER}
#else
  {(unsigned char *)"KEY_MIN"      ,KEY_MIN },
  {(unsigned char *)"KEY_Help"     ,KEY_Help},
  {(unsigned char *)"KEY_Do"       ,KEY_Do},
  {(unsigned char *)"KEY_PF1"      ,KEY_PF1},
  {(unsigned char *)"KEY_PF2"      ,KEY_PF2},
  {(unsigned char *)"KEY_PF3"      ,KEY_PF3},
  {(unsigned char *)"KEY_PF4"      ,KEY_PF4},
  {(unsigned char *)"KEY_Pad0"     ,KEY_Pad0},
  {(unsigned char *)"KEY_Pad1"     ,KEY_Pad1},
  {(unsigned char *)"KEY_Pad2"     ,KEY_Pad2},
  {(unsigned char *)"KEY_Pad3"     ,KEY_Pad3},
  {(unsigned char *)"KEY_Pad4"     ,KEY_Pad4},
  {(unsigned char *)"KEY_Pad5"     ,KEY_Pad5},
  {(unsigned char *)"KEY_Pad6"     ,KEY_Pad6},
  {(unsigned char *)"KEY_Pad7"     ,KEY_Pad7},
  {(unsigned char *)"KEY_Pad8"     ,KEY_Pad8},
  {(unsigned char *)"KEY_Pad9"     ,KEY_Pad9},
  {(unsigned char *)"KEY_PadEnter" ,KEY_PadEnter},
  {(unsigned char *)"KEY_PadMinus" ,KEY_PadMinus},
  {(unsigned char *)"KEY_PadPeriod",KEY_PadPeriod},
  {(unsigned char *)"KEY_PadComma" ,KEY_PadComma},
  {(unsigned char *)"KEY_Pad00"    ,KEY_Pad00},
  {(unsigned char *)"KEY_BackTab"  ,KEY_BackTab},
  {(unsigned char *)"KEY_Find"     ,KEY_Find},
  {(unsigned char *)"KEY_InsertHere",KEY_InsertHere},
  {(unsigned char *)"KEY_Remove"   ,KEY_Remove},
  {(unsigned char *)"KEY_Select"   ,KEY_Select},
  {(unsigned char *)"KEY_PrevScreen",KEY_PrevScreen},
  {(unsigned char *)"KEY_PrevScrn" ,KEY_PrevScrn},
  {(unsigned char *)"KEY_NextScreen",KEY_NextScreen},
  {(unsigned char *)"KEY_NextScrn" ,KEY_NextScrn},
  {(unsigned char *)"KEY_SF1"      ,KEY_SF1},
  {(unsigned char *)"KEY_SF2"      ,KEY_SF2},
  {(unsigned char *)"KEY_SF3"      ,KEY_SF3},
  {(unsigned char *)"KEY_SF4"      ,KEY_SF4},
  {(unsigned char *)"KEY_SF5"      ,KEY_SF5},
  {(unsigned char *)"KEY_SF6"      ,KEY_SF6},
  {(unsigned char *)"KEY_SF7"      ,KEY_SF7},
  {(unsigned char *)"KEY_SF8"      ,KEY_SF8},
  {(unsigned char *)"KEY_SF9"      ,KEY_SF9},
  {(unsigned char *)"KEY_SF10"     ,KEY_SF10},
  {(unsigned char *)"KEY_SF11"     ,KEY_SF11},
  {(unsigned char *)"KEY_SF12"     ,KEY_SF12},
  {(unsigned char *)"KEY_SF13"     ,KEY_SF13},
  {(unsigned char *)"KEY_SF14"     ,KEY_SF14},
  {(unsigned char *)"KEY_SF15"     ,KEY_SF15},
  {(unsigned char *)"KEY_SHelp"    ,KEY_SHelp},
  {(unsigned char *)"KEY_SF16"     ,KEY_SF16},
  {(unsigned char *)"KEY_SDo"      ,KEY_SDo},
  {(unsigned char *)"KEY_SF17"     ,KEY_SF17},
  {(unsigned char *)"KEY_SF18"     ,KEY_SF18},
  {(unsigned char *)"KEY_SF19"     ,KEY_SF19},
  {(unsigned char *)"KEY_SF20"     ,KEY_SF20},
  {(unsigned char *)"ControlA"     ,ControlA},
  {(unsigned char *)"ControlB"     ,ControlB},
  {(unsigned char *)"ControlC"     ,ControlC},
  {(unsigned char *)"ControlD"     ,ControlD},
  {(unsigned char *)"ControlE"     ,ControlE},
  {(unsigned char *)"ControlF"     ,ControlF},
  {(unsigned char *)"ControlG"     ,ControlG},
  {(unsigned char *)"ControlH"     ,ControlH},
  {(unsigned char *)"BackSpace"    ,BackSpace},
  {(unsigned char *)"ControlI"     ,ControlI},
  {(unsigned char *)"Tab"          ,Tab},
  {(unsigned char *)"ControlJ"     ,ControlJ},
  {(unsigned char *)"LineFeed"     ,LineFeed},
  {(unsigned char *)"ControlK"     ,ControlK},
  {(unsigned char *)"ControlL"     ,ControlL},
  {(unsigned char *)"ControlM"     ,ControlM},
  {(unsigned char *)"Return"       ,Return},
  {(unsigned char *)"ControlN"     ,ControlN},
  {(unsigned char *)"ControlO"     ,ControlO},
  {(unsigned char *)"ControlP"     ,ControlP},
  {(unsigned char *)"ControlQ"     ,ControlQ},
  {(unsigned char *)"ControlR"     ,ControlR},
  {(unsigned char *)"ControlS"     ,ControlS},
  {(unsigned char *)"ControlT"     ,ControlT},
  {(unsigned char *)"ControlU"     ,ControlU},
  {(unsigned char *)"ControlV"     ,ControlV},
  {(unsigned char *)"ControlW"     ,ControlW},
  {(unsigned char *)"ControlX"     ,ControlX},
  {(unsigned char *)"ControlY"     ,ControlY},
  {(unsigned char *)"ControlZ"     ,ControlZ},
  {(unsigned char *)"Escape"       ,Escape},
  {(unsigned char *)"Del"          ,Del},
  {(unsigned char *)"CSI"          ,CSI},
  {(unsigned char *)"KEY_BREAK"    ,KEY_BREAK },
  {(unsigned char *)"KEY_DOWN"     ,KEY_DOWN },
  {(unsigned char *)"KEY_UP"       ,KEY_UP },
  {(unsigned char *)"KEY_LEFT"     ,KEY_LEFT },
  {(unsigned char *)"KEY_RIGHT"    ,KEY_RIGHT},
  {(unsigned char *)"KEY_HOME"     ,KEY_HOME},
  {(unsigned char *)"KEY_BACKSPACE",KEY_BACKSPACE},
  {(unsigned char *)"KEY_F0"       ,KEY_F0},
  {(unsigned char *)"KEY_F1"       ,(KEY_F(0)+1)},
  {(unsigned char *)"KEY_F2"       ,(KEY_F(0)+2)},
  {(unsigned char *)"KEY_F3"       ,(KEY_F(0)+3)},
  {(unsigned char *)"KEY_F4"       ,(KEY_F(0)+4)},
  {(unsigned char *)"KEY_F5"       ,(KEY_F(0)+5)},
  {(unsigned char *)"KEY_F6"       ,(KEY_F(0)+6)},
  {(unsigned char *)"KEY_F7"       ,(KEY_F(0)+7)},
  {(unsigned char *)"KEY_F8"       ,(KEY_F(0)+8)},
  {(unsigned char *)"KEY_F9"       ,(KEY_F(0)+9)},
  {(unsigned char *)"KEY_F10"      ,(KEY_F(0)+10)},
  {(unsigned char *)"KEY_F11"      ,(KEY_F(0)+11)},
  {(unsigned char *)"KEY_F12"      ,(KEY_F(0)+12)},
  {(unsigned char *)"KEY_F13"      ,(KEY_F(0)+13)},
  {(unsigned char *)"KEY_F14"      ,(KEY_F(0)+14)},
  {(unsigned char *)"KEY_F15"      ,(KEY_F(0)+15)},
  {(unsigned char *)"KEY_F16"      ,(KEY_F(0)+16)},
  {(unsigned char *)"KEY_F17"      ,(KEY_F(0)+17)},
  {(unsigned char *)"KEY_F18"      ,(KEY_F(0)+18)},
  {(unsigned char *)"KEY_F19"      ,(KEY_F(0)+19)},
  {(unsigned char *)"KEY_F20"      ,(KEY_F(0)+20)},
  {(unsigned char *)"KEY_F21"      ,(KEY_F(0)+21)},
  {(unsigned char *)"KEY_F22"      ,(KEY_F(0)+22)},
  {(unsigned char *)"KEY_F23"      ,(KEY_F(0)+23)},
  {(unsigned char *)"KEY_F24"      ,(KEY_F(0)+24)},
  {(unsigned char *)"KEY_F25"      ,(KEY_F(0)+25)},
  {(unsigned char *)"KEY_F26"      ,(KEY_F(0)+26)},
  {(unsigned char *)"KEY_F27"      ,(KEY_F(0)+27)},
  {(unsigned char *)"KEY_F28"      ,(KEY_F(0)+28)},
  {(unsigned char *)"KEY_F29"      ,(KEY_F(0)+29)},
  {(unsigned char *)"KEY_F30"      ,(KEY_F(0)+30)},
  {(unsigned char *)"KEY_F31"      ,(KEY_F(0)+31)},
  {(unsigned char *)"KEY_F32"      ,(KEY_F(0)+32)},
  {(unsigned char *)"KEY_F33"      ,(KEY_F(0)+33)},
  {(unsigned char *)"KEY_F34"      ,(KEY_F(0)+34)},
  {(unsigned char *)"KEY_F35"      ,(KEY_F(0)+35)},
  {(unsigned char *)"KEY_F36"      ,(KEY_F(0)+36)},
  {(unsigned char *)"KEY_F37"      ,(KEY_F(0)+37)},
  {(unsigned char *)"KEY_F38"      ,(KEY_F(0)+38)},
  {(unsigned char *)"KEY_F39"      ,(KEY_F(0)+39)},
  {(unsigned char *)"KEY_F40"      ,(KEY_F(0)+40)},
  {(unsigned char *)"KEY_F41"      ,(KEY_F(0)+41)},
  {(unsigned char *)"KEY_F42"      ,(KEY_F(0)+42)},
  {(unsigned char *)"KEY_F43"      ,(KEY_F(0)+43)},
  {(unsigned char *)"KEY_F44"      ,(KEY_F(0)+44)},
  {(unsigned char *)"KEY_F45"      ,(KEY_F(0)+45)},
  {(unsigned char *)"KEY_F46"      ,(KEY_F(0)+46)},
  {(unsigned char *)"KEY_F47"      ,(KEY_F(0)+47)},
  {(unsigned char *)"KEY_F48"      ,(KEY_F(0)+48)},
  {(unsigned char *)"KEY_F49"      ,(KEY_F(0)+49)},
  {(unsigned char *)"KEY_F50"      ,(KEY_F(0)+50)},
  {(unsigned char *)"KEY_F51"      ,(KEY_F(0)+51)},
  {(unsigned char *)"KEY_F52"      ,(KEY_F(0)+52)},
  {(unsigned char *)"KEY_F53"      ,(KEY_F(0)+53)},
  {(unsigned char *)"KEY_F54"      ,(KEY_F(0)+54)},
  {(unsigned char *)"KEY_F55"      ,(KEY_F(0)+55)},
  {(unsigned char *)"KEY_F56"      ,(KEY_F(0)+56)},
  {(unsigned char *)"KEY_F57"      ,(KEY_F(0)+57)},
  {(unsigned char *)"KEY_F58"      ,(KEY_F(0)+58)},
  {(unsigned char *)"KEY_F59"      ,(KEY_F(0)+59)},
  {(unsigned char *)"KEY_F60"      ,(KEY_F(0)+60)},
  {(unsigned char *)"KEY_F61"      ,(KEY_F(0)+61)},
  {(unsigned char *)"KEY_F62"      ,(KEY_F(0)+62)},
  {(unsigned char *)"KEY_F63"      ,(KEY_F(0)+63)},
  {(unsigned char *)"KEY_F64"      ,(KEY_F(0)+64)},
  {(unsigned char *)"KEY_DL"       ,KEY_DL},
  {(unsigned char *)"KEY_IL"       ,KEY_IL},
  {(unsigned char *)"KEY_DC"       ,KEY_DC},
  {(unsigned char *)"KEY_IC"       ,KEY_IC},
  {(unsigned char *)"KEY_EIC"      ,KEY_EIC},
  {(unsigned char *)"KEY_CLEAR"    ,KEY_CLEAR},
  {(unsigned char *)"KEY_EOS"      ,KEY_EOS},
  {(unsigned char *)"KEY_EOL"      ,KEY_EOL},
  {(unsigned char *)"KEY_SF"       ,KEY_SF},
  {(unsigned char *)"KEY_SR"       ,KEY_SR},
  {(unsigned char *)"KEY_NPAGE"    ,KEY_NPAGE},
  {(unsigned char *)"KEY_PPAGE"    ,KEY_PPAGE},
  {(unsigned char *)"KEY_STAB"     ,KEY_STAB},
  {(unsigned char *)"KEY_CTAB"     ,KEY_CTAB},
  {(unsigned char *)"KEY_CATAB"    ,KEY_CATAB},
  {(unsigned char *)"KEY_ENTER"    ,KEY_ENTER},
  {(unsigned char *)"KEY_SRESET"   ,KEY_SRESET},
  {(unsigned char *)"KEY_RESET"    ,KEY_RESET},
  {(unsigned char *)"KEY_PRINT"    ,KEY_PRINT},
  {(unsigned char *)"KEY_LL"       ,KEY_LL},
  {(unsigned char *)"KEY_A1"       ,KEY_A1},
  {(unsigned char *)"KEY_A3"       ,KEY_A3},
  {(unsigned char *)"KEY_B2"       ,KEY_B2},
  {(unsigned char *)"KEY_C1"       ,KEY_C1},
  {(unsigned char *)"KEY_C3"       ,KEY_C3},
  {(unsigned char *)"KEY_BTAB"     ,KEY_BTAB},
  {(unsigned char *)"KEY_BEG"      ,KEY_BEG},
  {(unsigned char *)"KEY_CANCEL"   ,KEY_CANCEL},
  {(unsigned char *)"KEY_CLOSE"    ,KEY_CLOSE},
  {(unsigned char *)"KEY_COMMAND"  ,KEY_COMMAND},
  {(unsigned char *)"KEY_COPY"     ,KEY_COPY},
  {(unsigned char *)"KEY_CREATE"   ,KEY_CREATE},
  {(unsigned char *)"KEY_END"      ,KEY_END},
  {(unsigned char *)"KEY_EXIT"     ,KEY_EXIT},
  {(unsigned char *)"KEY_FIND"     ,KEY_FIND},
  {(unsigned char *)"KEY_HELP"     ,KEY_HELP},
  {(unsigned char *)"KEY_MARK"     ,KEY_MARK},
  {(unsigned char *)"KEY_MESSAGE"  ,KEY_MESSAGE},
  {(unsigned char *)"KEY_MOVE"     ,KEY_MOVE},
  {(unsigned char *)"KEY_NEXT"     ,KEY_NEXT},
  {(unsigned char *)"KEY_OPEN"     ,KEY_OPEN},
  {(unsigned char *)"KEY_OPTIONS"  ,KEY_OPTIONS},
  {(unsigned char *)"KEY_PREVIOUS" ,KEY_PREVIOUS},
  {(unsigned char *)"KEY_REDO"     ,KEY_REDO},
  {(unsigned char *)"KEY_REFERENCE",KEY_REFERENCE},
  {(unsigned char *)"KEY_REFRESH"  ,KEY_REFRESH},
  {(unsigned char *)"KEY_REPLACE"  ,KEY_REPLACE},
  {(unsigned char *)"KEY_RESTART"  ,KEY_RESTART},
  {(unsigned char *)"KEY_RESUME"   ,KEY_RESUME},
  {(unsigned char *)"KEY_SAVE"     ,KEY_SAVE},
  {(unsigned char *)"KEY_SBEG"     ,KEY_SBEG},
  {(unsigned char *)"KEY_SCANCEL"  ,KEY_SCANCEL},
  {(unsigned char *)"KEY_SCOMMAND" ,KEY_SCOMMAND},
  {(unsigned char *)"KEY_SCOPY"    ,KEY_SCOPY},
  {(unsigned char *)"KEY_SCREATE"  ,KEY_SCREATE},
  {(unsigned char *)"KEY_SDC"      ,KEY_SDC},
  {(unsigned char *)"KEY_SDL"      ,KEY_SDL},
  {(unsigned char *)"KEY_SELECT"   ,KEY_SELECT},
  {(unsigned char *)"KEY_SEND"     ,KEY_SEND},
  {(unsigned char *)"KEY_SEOL"     ,KEY_SEOL},
  {(unsigned char *)"KEY_SEXIT"    ,KEY_SEXIT},
  {(unsigned char *)"KEY_SFIND"    ,KEY_SFIND},
  {(unsigned char *)"KEY_SHELP"    ,KEY_SHELP},
  {(unsigned char *)"KEY_SHOME"    ,KEY_SHOME},
  {(unsigned char *)"KEY_SIC"      ,KEY_SIC},
  {(unsigned char *)"KEY_SLEFT"    ,KEY_SLEFT},
  {(unsigned char *)"KEY_SMESSAGE" ,KEY_SMESSAGE},
  {(unsigned char *)"KEY_SMOVE"    ,KEY_SMOVE},
  {(unsigned char *)"KEY_SNEXT"    ,KEY_SNEXT},
  {(unsigned char *)"KEY_SOPTIONS" ,KEY_SOPTIONS},
  {(unsigned char *)"KEY_SPREVIOUS",KEY_SPREVIOUS},
  {(unsigned char *)"KEY_SPRINT"   ,KEY_SPRINT},
  {(unsigned char *)"KEY_SREDO"    ,KEY_SREDO},
  {(unsigned char *)"KEY_SREPLACE" ,KEY_SREPLACE},
  {(unsigned char *)"KEY_SRIGHT"   ,KEY_SRIGHT},
  {(unsigned char *)"KEY_SRSUME"   ,KEY_SRSUME},
  {(unsigned char *)"KEY_SSAVE"    ,KEY_SSAVE},
  {(unsigned char *)"KEY_SSUSPEND" ,KEY_SSUSPEND},
  {(unsigned char *)"KEY_SUNDO"    ,KEY_SUNDO},
  {(unsigned char *)"KEY_SUSPEND"  ,KEY_SUSPEND},
  {(unsigned char *)"KEY_UNDO"     ,KEY_UNDO},
  {(unsigned char *)"KEY_CLEFT"    ,KEY_CLEFT},
  {(unsigned char *)"KEY_CRIGHT"   ,KEY_CRIGHT},
  {(unsigned char *)"KEY_CUP"      ,KEY_CUP},
  {(unsigned char *)"KEY_CDOWN"    ,KEY_CDOWN},
  {(unsigned char *)"KEY_CHOME"    ,KEY_CHOME},
  {(unsigned char *)"KEY_CEND"     ,KEY_CEND},
  {(unsigned char *)"KEY_CPGUP"    ,KEY_CPGUP},
  {(unsigned char *)"KEY_CPGDN"    ,KEY_CPGDN},
  {(unsigned char *)"KEY_MAX"      ,KEY_MAX}
#endif
};
