/***********************************************************************/
/* FILE.C - File and view related functions.                           */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"
#include "directry.h"

/*#define TRACE*/
/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern char number_of_views;
extern char number_of_files;
extern char display_screens;                      /* number of screens */
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char *cmd_rec;
extern unsigned short cmd_rec_len;
extern unsigned char in_profile;    /* indicates if processing profile */
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern char file_disposition;
extern struct stat stat_buf;
extern unsigned char temp_cmd[150];
extern unsigned char dir_filename[MAX_FILE_NAME+1];
extern unsigned char dir_pathname[MAX_FILE_NAME+1];
extern unsigned char sp_path[MAX_FILE_NAME+1] ;
extern unsigned char sp_fname[MAX_FILE_NAME+1] ;
extern unsigned char dir_path[MAX_FILE_NAME+1] ;    /* for dir and ls commands */
/*---------------------- function definitions -------------------------*/
#ifdef PROTO
VIEW_DETAILS * find_file(unsigned char *,unsigned char *);
#else
VIEW_DETAILS * find_file();
#endif
/***********************************************************************/
#ifdef PROTO
short get_file(unsigned char *filename)
#else
short get_file(filename)
unsigned char *filename;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern unsigned char CMD_LINEx;
 extern unsigned char ERROR_ROWx;
 extern unsigned char TAB_ROWx;
 extern unsigned char TAB_ONx;
 extern unsigned char SCALE_ROWx;
 extern unsigned char SCALE_ONx;
 extern unsigned char PRE_ONx;
 extern unsigned char PRE_LEFTx;
 extern unsigned char CURRENT_ROW_POSx;
 extern unsigned char STAYx;
 extern unsigned char CASE_Ex;
 extern unsigned char CASE_Lx;
 extern unsigned char CASE_Cx;
 extern unsigned char TABO_ONx;
 extern unsigned char TABO_Nx;
 extern unsigned char TABSx;
/*--------------------------- local data ------------------------------*/
 char fno;
 LINE *curr;
 char work_filename[MAX_FILE_NAME+1] ;
 VIEW_DETAILS *save_current_view,*found_file;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    get_file");
#endif
/*---------------------------------------------------------------------*/
/* Split the filename supplied into directory and filename parts.      */
/* This is done before allocating a new current_file number.           */
/*---------------------------------------------------------------------*/

 if (splitpath(filename) == ERROR)
   {
    display_error(10,filename);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* If the filename portion of the splithpath is empty, then we are     */
/* editting a directory. So create the new file with the appropriate OS*/
/* command and set the filename to DIR.DIR.                            */
/*---------------------------------------------------------------------*/
 if (strcmp(sp_fname,"") == 0)
   {
    if (read_directory() == ERROR)
       {
#ifdef TRACE
        trace_return();
#endif
        return(ERROR);
       }
    strcpy(sp_path,dir_pathname);
    strcpy(sp_fname,dir_filename);
   }
/*---------------------------------------------------------------------*/
/* If this is the first file to be editted, don't check to see if the  */
/* file is already in the ring. Obvious hey!                           */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW == (VIEW_DETAILS *)NULL)     /* no files in ring yet */
   {
    if (defaults_for_first_file() == ERROR)
      {
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
   }
 else
   {
/*---------------------------------------------------------------------*/
/* Here we should check if we already have the file to be editted in   */
/* the ring. If the file is there and it is DIR.DIR, QQUIT out of it   */
/* otherwise set the current pointer to it and exit.                   */
/*---------------------------------------------------------------------*/
    save_current_view = CURRENT_VIEW;
    if ((found_file = find_file(sp_path,sp_fname)) != (VIEW_DETAILS *)NULL)
      {
       CURRENT_VIEW = found_file;
       if (strcmp(CURRENT_FILE->fname,dir_filename) == 0
       &&  strcmp(CURRENT_FILE->fpath,dir_pathname) == 0)
         {
          Qquit("");
          if (CURRENT_VIEW == (VIEW_DETAILS *)NULL)
             rc = defaults_for_first_file();
          else
             rc = defaults_for_other_files();
          if (rc == ERROR)
            {
#ifdef TRACE
             trace_return();
#endif
             return(ERROR);
            }
         }
       else
          {
#ifdef TRACE
           trace_return();
#endif
           return(OK);
          }
      }
    else
      {
       CURRENT_VIEW = save_current_view;
       if (defaults_for_other_files() == ERROR)
         {
#ifdef TRACE
          trace_return();
#endif
          return(ERROR);
         }
      }
    }
/*---------------------------------------------------------------------*/
/* Allocate memory to file pointer.                                    */
/*---------------------------------------------------------------------*/
 if ((CURRENT_FILE = (FILE_DETAILS *)memMalloc(sizeof(FILE_DETAILS),"current_file")) == NULL)
   {
    free_view_memory();
    display_error(30,"");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* Set up default file attributes.                                     */
/*---------------------------------------------------------------------*/
 default_file_attributes();
/*---------------------------------------------------------------------*/
/* Copy the filename and path strings split up at the start of the     */
/* function.                                                           */
/*---------------------------------------------------------------------*/
 if ((CURRENT_FILE->fname = (unsigned char *)memMalloc(strlen(sp_fname)+1,"get_file name")) == NULL)
   {
    free_view_memory();
    display_error(30,"");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 if ((CURRENT_FILE->fpath = (unsigned char *)memMalloc(strlen(sp_path)+1,"get_file path")) == NULL)
   {
    free_view_memory();
    display_error(30,"");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 strcpy(CURRENT_FILE->fname,sp_fname);
 strcpy(CURRENT_FILE->fpath,sp_path);

 strcpy(work_filename,sp_path);
 strcat(work_filename,sp_fname);
/*---------------------------------------------------------------------*/
/* If the file is not readable, then display error.                    */
/*---------------------------------------------------------------------*/
 if (!file_readable(work_filename))
   {
    display_error(8,work_filename);
    free_view_memory();
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* If the file doesn't exist create a new one                          */
/*---------------------------------------------------------------------*/
 if ((CURRENT_FILE->fp = fopen(work_filename,"r")) == NULL)
   {
    file_disposition = FILE_NEW;
    if (!in_profile)
       display_error(0,"New file...");
   }
 else
    if (file_writable(work_filename))
       file_disposition = FILE_NORMAL;
    else
      {
       file_disposition = FILE_READONLY;
       if (!in_profile)
          display_error(0,"File is read-only...");
      }
/*---------------------------------------------------------------------*/
/* first_line is set to "Top of FIle"                                  */
/*---------------------------------------------------------------------*/

 if ((CURRENT_FILE->first_line = add_line(CURRENT_FILE->first_line,NULL,TOP_OF_FILE,
     strlen(TOP_OF_FILE))) == NULL)
   {
    free_view_memory();
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }

 curr = CURRENT_FILE->first_line;

 CURRENT_FILE->number_lines = 0L;
 if (file_disposition != FILE_NEW)
   {
    stat(work_filename,&stat_buf);
    CURRENT_FILE->fmode = stat_buf.st_mode;
    if ((curr = read_file(CURRENT_FILE->fp,curr,work_filename)) == NULL)
      {
       free_view_memory();
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
   }
 else
    CURRENT_FILE->fmode = FMODE;
/*---------------------------------------------------------------------*/
/* last line is set to "Bottom of File"                                */
/*---------------------------------------------------------------------*/

 if (add_line(CURRENT_FILE->first_line,curr,BOTTOM_OF_FILE,
     strlen(BOTTOM_OF_FILE)) == NULL)
   {
    free_view_memory();
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }

 if (file_disposition != FILE_NEW)
    fclose(CURRENT_FILE->fp);

 number_of_files++;

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
LINE *read_file(FILE *fp,LINE *curr,unsigned char *filename)
#else
LINE *read_file(fp,curr,filename)
FILE *fp;
LINE *curr;
unsigned char *filename;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern unsigned char TABI_ONx;
 extern unsigned char TABI_Nx;
/*--------------------------- local data ------------------------------*/
 register unsigned short i;
 short ch;
 LINE *temp;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    read_file");
#endif
 temp = curr;
 memset(rec,' ',MAX_LINE_LENGTH);
 i = 0;
 while(1)
  {
   ch = fgetc(fp);
   if (feof(fp))
      break;
   if (ch == '\t'&& TABI_ONx)
     {
      do
       {
        rec[i] = ' ';
        i++;
        if (i >= MAX_LINE_LENGTH)
          {
           display_error(29,"line too long");
#ifdef TRACE
           trace_return();
#endif
           return(NULL);
          }
       }
      while ((i % TABI_Nx) != 0);
/*      while (((i+1) % TABI_Nx) != 0);*/
      continue;
     }
   if (ch == '\n')
     {
      rec[i] = '\0';
      if ((temp = add_line(CURRENT_FILE->first_line,temp,rec,i)) == NULL)
        {
#ifdef TRACE
         trace_return();
#endif
         return(NULL);
        }
      CURRENT_FILE->number_lines++;
      i = 0;
      memset(rec,' ',MAX_LINE_LENGTH);
      continue;
     }
   if (ch == '\r')
     {
      rec[i] = ch;
      i++;
      ch = fgetc(fp);
      if (feof(fp))
         break;
      if (ch == '\n')
        {
         --i;
         rec[i] = '\0';
         if ((temp = add_line(CURRENT_FILE->first_line,temp,rec,i)) == NULL)
           {
#ifdef TRACE
            trace_return();
#endif
            return(NULL);
           }
         CURRENT_FILE->number_lines++;
         i = 0;
         memset(rec,' ',MAX_LINE_LENGTH);
         continue;
        }
     }
#ifdef SUN
   if (ch > 128)
       {
             sprintf(rec,"Line: %d; Col: %d  '%1.1c'=%2.2X/%3.3d",
                       CURRENT_FILE->number_lines+1,i+2,ch,ch,ch);
             display_error(29,rec);
#ifdef TRACE
             trace_return();
#endif
             return(NULL);
             break;
       }
#endif
   rec[i] = ch;
   i++;
   if (i >= MAX_LINE_LENGTH)
     {
      sprintf(rec,"Line too long: %d",CURRENT_FILE->number_lines+1);
      display_error(29,rec);
#ifdef TRACE
      trace_return();
#endif
      return(NULL);
     }
  }
#ifdef TRACE
 trace_return();
#endif
 return(temp);
}
/***********************************************************************/
#ifdef PROTO
short save_file(unsigned char *new_fname,char force,long in_lines,
                char append)
#else
short save_file(new_fname,force,in_lines,append)
unsigned char *new_fname;
char force,append;
long in_lines;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned char *bak_filename;
 unsigned char *write_fname;
 register int i;
 long j;
 long num_lines=in_lines;
 LINE *curr;
 FILE *fp;
 unsigned short col,newcol;
 short off;
 unsigned char c;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    save_file");
#endif
 if ((write_fname = (unsigned char *)memMalloc(MAX_FILE_NAME,"write_fname")) == NULL)
   {
    display_error(30,"");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* If a new filename is specified, use it as the old filename.         */
/*---------------------------------------------------------------------*/
 if (strcmp(new_fname,"") != 0)                  /* new_fname supplied */
   {
/*---------------------------------------------------------------------*/
/* Split the supplied new filename.                                    */
/*---------------------------------------------------------------------*/
    if (splitpath(new_fname) == ERROR)
      {
       display_error(10,new_fname);
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
    strcpy(write_fname,sp_path);
    strcat(write_fname,sp_fname);
/*---------------------------------------------------------------------*/
/* Test to make sure that the write fname doesn't exist...             */
/* ...unless we are forcing the write.                                 */
/*---------------------------------------------------------------------*/
    if ((!force) && file_exists(write_fname))
      {
       display_error(31,write_fname);
       memFree(write_fname,"write_fname");
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
   }
 else
   {
/*---------------------------------------------------------------------*/
/* Create the name of the current file.                                */
/*---------------------------------------------------------------------*/
    strcpy(write_fname,CURRENT_FILE->fpath);
    strcat(write_fname,CURRENT_FILE->fname);
/*---------------------------------------------------------------------*/
/* Rename the current file to filename.bak.                            */
/*---------------------------------------------------------------------*/
    if ((bak_filename =
           (unsigned char *)memMalloc(strlen(CURRENT_FILE->fpath)+strlen(CURRENT_FILE->fname)+5,
           "bak_filename")) == NULL)
      {
       display_error(30,"");
       memFree(write_fname,"write_fname");
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
    new_filename(CURRENT_FILE->fpath,CURRENT_FILE->fname,bak_filename,".bak");
    if (CURRENT_FILE->fp != NULL)
      {
       remove_file(bak_filename);
       if (rename(write_fname,bak_filename) != 0)
         {
          display_error(8,write_fname);
          memFree(write_fname,"write_fname");
#ifdef TRACE
          trace_return();
#endif
          return(ERROR);
         }
      }
   }
/*---------------------------------------------------------------------*/
/* Test to make sure that we can write the file.                       */
/*---------------------------------------------------------------------*/
 if (!file_writable(write_fname))
   {
    display_error(8,write_fname);
    memFree(write_fname,"write_fname");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* Ensure the file is writeable.                                       */
/*---------------------------------------------------------------------*/
 if (append == YES)
    fp = fopen(write_fname,"ab");
 else
    fp = fopen(write_fname,"wb");
 if (fp == NULL)
   {
    display_error(8,"could not open for writing");
    memFree(write_fname,"write_fname");
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* Determine where to start writng from in the linked list.            */
/*---------------------------------------------------------------------*/
 if (num_lines > 0L)   /* called from put(d) command */
    curr = ll_find(CURRENT_FILE->first_line,CURRENT_VIEW->current_line);
 else
   {
    curr = CURRENT_FILE->first_line;
    num_lines = CURRENT_FILE->number_lines + 1; /* forces following for to work */
   }
/*---------------------------------------------------------------------*/
/* Now write out the contents of the file array to the new filename.   */
/*---------------------------------------------------------------------*/
 for (j=0L;j<num_lines && curr->next != NULL;j++)
   {
    if (curr->prev != NULL)  /* not first line */
      {
       if (CURRENT_FILE->tabsout_on)
         {
          col = 0;
          off = 0;
          while (1)
            {
             newcol = col;
             while ((c = next_char(curr,&off)) == ' ')
               {
                newcol++;
                if ((newcol % CURRENT_FILE->tabsout_num) == 0)
                  {
                   fputc('\t',fp);
                   col = newcol;
                  }
               }
             for (;col<newcol;col++)
                 fputc(' ',fp);
             if (off == (-1))  /* end of line */
                break;
             fputc(c,fp);
             col++;
            }
         }
       else
          for (i=0;i<curr->length;i++)
              fputc(*(curr->line+i),fp);
       col = 0;
       if (CURRENT_FILE->eolout == EOLOUT_LF)
          fputc('\n',fp);
       else
         {
          fputc('\r',fp);
          fputc('\n',fp);
         }
      }
    curr = curr->next;
   }
 fclose(fp);
 if (CURRENT_FILE->fmode != 0)
    chmod(write_fname,CURRENT_FILE->fmode);
/*---------------------------------------------------------------------*/
/* If a new filename was not supplied, free up temporary memory.       */
/*---------------------------------------------------------------------*/
 if (strcmp(new_fname,"") == 0)
    memFree(bak_filename,"bak_filename");
 memFree(write_fname,"write_fname");
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
void increment_alt(void)
#else
void increment_alt()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i;
 unsigned char *aus_filename;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    increment_alt");
#endif
 CURRENT_FILE->autosave_alt++;
 CURRENT_FILE->save_alt++;
/*---------------------------------------------------------------------*/
/* We can now test for autosave_alt exceeding the defined limit and    */
/* carry out an autosave if necessary.                                 */
/*---------------------------------------------------------------------*/
 if (CURRENT_FILE->autosave != 0
 && CURRENT_FILE->autosave_alt >= CURRENT_FILE->autosave)
   {
    if ((aus_filename =
       (unsigned char *)memMalloc(strlen(CURRENT_FILE->fpath)+strlen(CURRENT_FILE->fname)+5,
                        "aus_filename")) == NULL)
      {
       display_error(30,"");
#ifdef TRACE
       trace_return();
#endif
       return;
      }
    new_filename(CURRENT_FILE->fpath,CURRENT_FILE->fname,aus_filename,".aus");
    save_file(aus_filename,YES,0L,NO);
    memFree((unsigned char *)aus_filename,"aus_filename");
    CURRENT_FILE->autosave_alt = 0;
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
unsigned char *new_filename(unsigned char *ofp,unsigned char *ofn,
                            unsigned char *nfn,unsigned char *ext)
#else
unsigned char *new_filename(ofp,ofn,nfn,ext)
unsigned char *ofp,*ofn,*nfn,*ext;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    new_filename");
#endif
 strcpy(nfn,ofp);
 strcat(nfn,ofn);
#ifdef DOS
 rc = strzeq(nfn,'.');
 if (rc != (-1))
    *(nfn+rc) = '\0';
#endif
#ifdef OS2
 if (FATFileSystem(nfn)) /* returns TRUE if FAT filesystem */
   {
    rc = strzeq(nfn,'.');
    if (rc != (-1))
       *(nfn+rc) = '\0';
   }
#endif
 strcat(nfn,ext);
#ifdef TRACE
#endif
 return(nfn);
}
/***********************************************************************/
#ifdef PROTO
int free_view_memory(void)
#else
int free_view_memory()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 char save_current_screen;
 short original_number_of_files=number_of_files;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    free_view_memory");
#endif
 if (--CURRENT_FILE->file_views == 0)
    free_file_memory();
/*---------------------------------------------------------------------*/
/* If the marked block is within the current view, unset the variables.*/
/*---------------------------------------------------------------------*/
 if (MARK_VIEW == CURRENT_VIEW)
    MARK_VIEW = (VIEW_DETAILS *)NULL;
/*---------------------------------------------------------------------*/
/* Delete the windows associated with the current view.                */
/* Only do this if we are running interactively.                       */
/*---------------------------------------------------------------------*/
 if (!in_profile && CURRENT_WINDOW_MAIN != (WINDOW *)NULL)
   {
    if (CURRENT_VIEW->prefix_on)
       delwin(CURRENT_WINDOW_PREFIX);
    delwin(CURRENT_WINDOW_MAIN);
    delwin(CURRENT_WINDOW_COMMAND);
    delwin(CURRENT_WINDOW_ARROW);
    delwin(CURRENT_WINDOW_IDLINE);
   }
 if ((CURRENT_VIEW = vll_del(vd_first,CURRENT_VIEW,DIRECTION_FORWARD)) == (VIEW_DETAILS *)NULL)
    vd_first = (VIEW_DETAILS *)NULL;

 number_of_views--;

/*---------------------------------------------------------------------*/
/* The following procedures are only carried out when the number of    */
/* screens is > 1.                                                     */
/*---------------------------------------------------------------------*/
 if (display_screens > 1)
   {
/*---------------------------------------------------------------------*/
/* +---+---+     +---+---+                  +---+---+     +---+---+    */
/* | a | b |     | a | a |         or       | a | b |  c  | a | a |    */
/* |   |   | --> |   |   |                  |   |   |     |   |   |    */
/* |   |qq |     |   |   |                  |   |qq |     |   |   |    */
/* +---+---+     +---+---+                  +---+---+     +---+---+    */
/* number_of_files > 1                                                 */
/*---------------------------------------------------------------------*/
    if (original_number_of_files > 1 && OTHER_SCREEN.screen_view != (VIEW_DETAILS *)NULL)
       if (CURRENT_SCREEN.screen_view->file_for_view !=
           OTHER_SCREEN.screen_view->file_for_view)
         {
          if (defaults_for_other_files() == ERROR)
            {
#ifdef TRACE
             trace_return();
#endif
             return(ERROR);
            }
          CURRENT_FILE = OTHER_SCREEN.screen_view->file_for_view;
          CURRENT_FILE->file_views++;
          set_up_windows();
          CURRENT_SCREEN.screen_view = CURRENT_VIEW;
/*        repaint_screen(); */
         }
       else
/*---------------------------------------------------------------------*/
/* +---+---+     +---+---+                  +---+---+     +---+---+    */
/* | a | a |  b  | b | b |         or       | a | a | b c | b | b |    */
/* |   |   | --> |   |   |                  |   |   |     |   |   |    */
/* |   |qq |     |   |   |                  |   |qq |     |   |   |    */
/* +---+---+     +---+---+                  +---+---+     +---+---+    */
/* number_of_files > 1                                                 */
/*---------------------------------------------------------------------*/
         {
         }
/*---------------------------------------------------------------------*/
/* +---+---+                                                           */
/* | a | a |                                                           */
/* |   |   | --> exit                                                  */
/* |qq |   |                                                           */
/* +---+---+                                                           */
/* number_of_files = 1                                                 */
/*---------------------------------------------------------------------*/
    if (original_number_of_files == 1 && OTHER_SCREEN.screen_view != (VIEW_DETAILS *)NULL)
       if (CURRENT_SCREEN.screen_view->file_for_view ==
           OTHER_SCREEN.screen_view->file_for_view)
          free_view_memory();
   }

 if (number_of_views > 0)
   {
    pre_process_line(CURRENT_VIEW->focus_line);
    show_page();
    if (CURRENT_VIEW->prefix_on)
       touchwin(CURRENT_WINDOW_PREFIX);
    touchwin(CURRENT_WINDOW_COMMAND);
    touchwin(CURRENT_WINDOW_MAIN);
    touchwin(CURRENT_WINDOW);
    show_heading(0);
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
int free_file_memory(void)
#else
int free_file_memory()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    free_file_memory");
#endif
 if (CURRENT_FILE->fname != NULL)
   {
    memFree(CURRENT_FILE->fname,CURRENT_FILE->fname);
    CURRENT_FILE->fname = (unsigned char *)NULL;
   }
 if (CURRENT_FILE->fpath != NULL)
   {
    memFree(CURRENT_FILE->fpath,CURRENT_FILE->fpath);
    CURRENT_FILE->fpath = (unsigned char *)NULL;
   }
 ll_free(CURRENT_FILE->first_line);
 if (CURRENT_FILE != NULL)
   {
    memFree(CURRENT_FILE,"current file");
    CURRENT_FILE = (FILE_DETAILS *)NULL;
   }

 number_of_files--;

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
int read_directory(void)
#else
int read_directory()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 struct dirfile *dpfirst=NULL,*dplast=NULL,*dp;
 char str_attr[11];
 char str_date[10];
 char str_time[6];
#ifdef UNIX
 struct tm *timp;
#endif
 int rc;
 FILE *fp;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    read_directory");
#endif
/*---------------------------------------------------------------------*/
/* dir_path is set up here so that subsequent sos_edit commands can use*/
/* the directory path as a prefix to the edit files filename.          */
/*---------------------------------------------------------------------*/
 strcpy(dir_path,sp_path);
/*---------------------------------------------------------------------*/
/* Get all file info for the selected files into structure. If no file */
/* name specified, force it to '*'.                                    */
/*---------------------------------------------------------------------*/
 if (strcmp(sp_fname,"") == 0)
    rc = getfiles(sp_path,"*",&dpfirst,&dplast);
 else
    rc = getfiles(sp_path,sp_fname,&dpfirst,&dplast);
 if (rc != 0)
   {
    display_error(rc,sp_path);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 if (dpfirst == dplast)
   {
    display_error(9,sp_path);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* sort the array of file structures.                                  */
/*---------------------------------------------------------------------*/
 qsort(dpfirst,dplast - dpfirst,sizeof(struct dirfile),fcomp);
/*---------------------------------------------------------------------*/
/* open the DIR.DIR file for output, overwriting any previous data     */
/*---------------------------------------------------------------------*/
 strcpy(temp_cmd,dir_pathname);
 strcat(temp_cmd,dir_filename);
 if ((fp = fopen(temp_cmd,"w")) == NULL)
   {
    display_error(8,sp_path);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* write out the formatted contents of the file structures.            */
/*---------------------------------------------------------------------*/
 for (dp=dpfirst;dp<dplast;dp++)
    {
#ifdef UNIX
     timp = localtime(&(dp->ftime));
#endif
     fprintf(fp,"%s ",file_attrs(dp->fattr,str_attr));
     fprintf(fp,"%8ld ",dp->fsize);
     fprintf(fp,"%s ",file_date(D_NAME,str_date));
     fprintf(fp,"%s ",file_time(T_NAME,str_time));
     fprintf(fp,"%s\n",dp->fname);
     free(dp->fname);
    }
 free(dpfirst);
 fclose(fp);

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
VIEW_DETAILS * find_file(unsigned char *fp,unsigned char *fn)
#else
VIEW_DETAILS * find_file(fp,fn)
unsigned char *fp,*fn;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 VIEW_DETAILS *save_current_view,*found_file;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    find_file");
#endif
/*---------------------------------------------------------------------*/
/* dir_path is set up here so that subsequent sos_edit commands can use*/
/* the directory path as a prefix to the edit files filename.          */
/*---------------------------------------------------------------------*/
 save_current_view = CURRENT_VIEW;
 CURRENT_VIEW = vd_first;
 while(CURRENT_VIEW != (VIEW_DETAILS *)NULL)
   {
#ifdef UNIX
    if (strcmp(CURRENT_FILE->fname,fn) == 0
    &&  strcmp(CURRENT_FILE->fpath,fp) == 0)
#else
    if (memcmpi(CURRENT_FILE->fname,fn,max(strlen(CURRENT_FILE->fname),strlen(fn))) == 0
    &&  memcmpi(CURRENT_FILE->fpath,fp,max(strlen(CURRENT_FILE->fpath),strlen(fp))) == 0)
#endif
      {
#ifdef TRACE
       trace_return();
#endif
       found_file = CURRENT_VIEW;
       CURRENT_VIEW = save_current_view;
       return(found_file);
      }
    CURRENT_VIEW = CURRENT_VIEW->next;
   }
#ifdef TRACE
 trace_return();
#endif
 CURRENT_VIEW = save_current_view;
 return((VIEW_DETAILS *)NULL);
}
