#include "pt.h"
#include "malloc.h"

struct piece * pascal
/* XTAG:dupPieces */
dupPieces(pp)
	register struct piece *pp;
{
	register struct piece *pp2;
	struct piece *lastpp, *retpp;

	lastpp = retpp = NULL;
	while( pp != NULL ) {
		pp2 = getFreePiece();
		/* link to the previous piece */
		if( lastpp != NULL )
			lastpp->nextPiece = pp2;
		else	/* first time through, remember the first piece */
			retpp = pp2;
		pp2->prevPiece = lastpp;
		/* copy the field values */
		pp2->file = pp->file;
		pp2->position = pp->position;
		pp2->length = pp->length;
		lastpp = pp2;
		pp = pp->nextPiece;
	}
	/* pp2->nextPiece == NULL already since getFreePiece does that */
	return retpp;
}

struct piece * pascal
/* XTAG:getFreePiece */
getFreePiece()
{
	extern unsigned char msgBuffer[];
	extern struct piece *freePList;
	extern unsigned char *userMessages[];
	extern unsigned int bytesLeft;
	extern unsigned int piecesLeft;
	extern int debug;
	
	register struct piece *pp;
	/* start this at six since replace in search.c will issue the */
	/* message when it occurs in a replace (the most likely case) */
	/* six times will use 6*16 = 96 bytes. */
	static int errorMsgCount = 6;
	
	pp = freePList;
	if( pp != NULL ) {
		--piecesLeft;
		freePList = freePList->nextPiece;
		pp->nextPiece = pp->prevPiece = NULL;
		return pp;
	}
	/* else we have to allocate a piece structure from the free space */
	pp = (struct piece *)malloc(sizeof(struct piece));
	bytesLeft = _memavl();
	if( bytesLeft < SPACELOW ) {
		if( --errorMsgCount <= 0 ) {
			msg(userMessages[LOWSPACEMSG], 3);
			errorMsgCount = 9;
		}
	}
	pp->nextPiece = pp->prevPiece = NULL;
	return pp;
}

void pascal
/* XTAG:freePieces */
freePieces(pp)
	struct piece *pp;
{
	extern struct piece *freePList;
	extern unsigned int piecesLeft;
	
	register struct piece *pp2;
	
	if( pp == NULL )
		return;
	pp2 = pp;
	while( pp2->nextPiece != NULL ) {
		pp2 = pp2->nextPiece;
		++piecesLeft;
	}
	pp2->nextPiece = freePList;
	freePList = pp;
	++piecesLeft;
}

struct piece * pascal
/* XTAG:findPiece */
findPiece(logPos, ff, beginLogPos)
	long logPos, *beginLogPos;
	register struct openFile *ff;
{
	extern unsigned char msgBuffer[];

	register struct piece *pp;
	long nn, n2;

	/* see if we already know what piece it is in */
	if( ff->loLogPiece <= logPos && logPos <= ff->hiLogPiece ) {
		pp = ff->logPiece;
		nn = ff->loLogPiece;
		/* now nn = first logical byte in this piece */
	} else {	/* go through the piece table */
		pp = ff->logPiece;
		nn = ff->loLogPiece;
		if( logPos < nn ) {	/* below this piece? */
			if( logPos < 0 ) {  /* error checking to be safe */
				msg("findPiece: byte number < 0", 3);
				return pp;	/* what else? */
			}
			/* search down for the piece */
			while( logPos < nn ) {
				pp = pp->prevPiece;
				nn -= pp->length;
			}
		} else {	/* must be at or above this piece */
			if( logPos >= ff->fileSize ) {
				/* return the last piece */
				while( pp->nextPiece != NULL ) {
					nn += pp->length;
					pp = pp->nextPiece;
				}
			} else {
				/* search up for the piece */
				while( 1 ) {
					n2 = nn + pp->length;
					if( logPos < n2 )
						break;
					nn = n2;
					pp = pp->nextPiece;
				}
			}
		}
	}
	*beginLogPos = nn;
	return pp;
}

void pascal
/* XTAG:hidePiece */
hidePiece(beginLogPos)
	long beginLogPos;
{
	extern unsigned char msgBuffer[];
	extern struct window *selWindow;
	extern struct openFile *files;
	extern int debug;

	register struct piece *pp;
	register struct openFile *ff;
	long nn;

	/* NOTE: This code implies that the piece begin hidden */
	/* MUST be in the selection window */
	ff = &files[selWindow->fileId];
	pp = findPiece(beginLogPos, ff, &nn);
	if( beginLogPos != nn ) {
		sprintf(msgBuffer, "hidePiece: pos=%ld beginPiece=%ld",
			beginLogPos, nn);
		msg(msgBuffer, 3);
		return;
	}

	/* Now we fix up the piece to be of zero length */
	/* First subtract the length we are zeroing from the file size */
	ff->fileSize -= pp->length;
	
	/* we have to recompute posBotline so incorrect values do */
	/* not mess other things up */
	if( selWindow->posTopline <= beginLogPos
	 && beginLogPos < selWindow->posBotline )
		selWindow->posBotline -= pp->length;

	/* Then zero the length of the piece.  Now the contents of the */
	/* piece are still in the add file but the piece will not show */
	/* up in the file itself. */
	pp->length = 0L;

	/* Make the file handle a special value for hidden pieces */
	pp->file = 999;

	/* now we have to make sure the caches are correct */
	ff->hiLogBuffer = -1L;	/* invalidate the buffer cache */
	/* Make the first piece in the file the cached piece */
	ff->logPiece = ff->pieceList;
	ff->loLogPiece = 0L;	/* first piece is at logical offset 0 */
	ff->hiLogPiece = ff->logPiece->length;
}

int pascal
/* XTAG:deleteHiddenText */
deleteHiddenText(w)
	struct window *w;
{
	extern unsigned char msgBuffer[];
	extern struct openFile *files;

	register struct piece *pp;
	struct piece *ppNext, *ppPrev;

	pp = files[w->fileId].pieceList;
	while( pp != NULL ) {
		ppNext = pp->nextPiece;
		if( pp->file == 999 ) {
			ppPrev = pp->prevPiece;
			if( ppPrev != NULL )
				ppPrev->nextPiece = ppNext;
			if( ppNext != NULL )
				ppNext->prevPiece = ppPrev;
			pp->nextPiece = NULL;
			/* freePieces only looks at nextPiece */
			/* (not prevPiece) so we only NULL nextPiece */
			freePieces(pp);
		}
		pp = ppNext;
	}
	return 0;
}

long pascal
/* XTAG:findHiddenPiece */
findHiddenPiece(w, startPos, offset)
	struct window *w;
	long startPos, *offset;
{
	extern unsigned char msgBuffer[];
	extern struct openFile *files;

	register struct piece *pp;
	struct openFile *ff;
	long beginPos;

	ff = &files[w->fileId];
	/* We have to treat startPos=0 as a special case since hidden */
	/* pieces have zero length and the piece after them will be found */
	/* first if a hidden piece is first in the piece list */
	if( startPos == 0L ) {
		beginPos = 0L;
		pp = ff->pieceList;
	} else
		pp = findPiece(startPos, ff, &beginPos);
	while( pp != NULL && pp->file != 999 ) {
		beginPos += pp->length;
		pp = pp->nextPiece;
	}
	if( pp == NULL )
		return -1L;
	*offset = pp->position;
	return beginPos;
}
