#include "pt.h"

void pascal
/* XTAG:insChar */
insChar(c, nlAfterCr)
	unsigned char c;
	int nlAfterCr;
{
	extern unsigned char msgBuffer[];
	extern unsigned char textBuffer[];
	extern struct window *selWindow;
	extern long selBegin, selEnd;
	extern int selMode;
	extern struct window *windowList;
	extern unsigned char *screenMap;
	extern int scrCols;
	extern int overType;
	extern int autoIndent;
	extern int rightMargin;
	extern unsigned char scrMapReset;
	extern union REGS rin, rout;
	extern int unixMode;
	extern int debug;

	static int insrow1, inscol1, inscol2;
	static long inscp;
	long cp;
	long saveSelBegin, saveSelEnd;
	int n, row, col;
	register unsigned char ch;
	unsigned char scan;
	int insertPending = 0;
/* CPC 4-26-88 */
	int currentCol = -1;	/* horizontal char pos cache */
/* CPC 4-26-88 */
	
	/* erase the old selection in case it covers two or more lines */
	eraseSelection();

	/* selection mode is character after an insert */
	selMode = SELCHAR;

nextChar:
	if( c == '\177') {	/* del or Ctrl-Backspace */
		cp = selBegin;
		/* first scan back over white space */
		while( 1 ) {
			ch = readChar(selWindow->fileId, --cp);
			switch( ch ) {
			case ' ':
			case '\t':
			case '\r':
			case '\n':
				break;
			default:
				goto endWhite;	/* break out of while loop */
			}
		}
	endWhite:
		/* now scan over alphanumerics */
		if( isalnum(ch) ) {
			while( isalnum(ch) ) {
				if( cp <= 0 )
					break;
				ch = readChar(selWindow->fileId, --cp);
			}
		} else {
			while( !isalnum(ch) && !isspace(ch) && !iscntrl(ch) ) {
				if( cp <= 0 )
					break;
				ch = readChar(selWindow->fileId, --cp);
			}
		}
		selEnd = selBegin - 1;
		selBegin = cp + 1;
		if( selBegin <= selEnd ) {
			if( deleteChars(selWindow->fileId, NOUPDATE, 0) )
				c = '\r'; /* if so, force a redrawWindow */
		} else
			selEnd = selBegin;
		flush();	/* flush the input buffer */
	} else if( c == '\b') {
		if( selBegin > 0 ) {
			if( readChar(selWindow->fileId, selBegin-1) == '\n'
			 || !delChar() ) {
				selEnd = --selBegin;
				if( readChar(selWindow->fileId, selBegin-1)
								== '\r' )
					--selBegin;
				/* deleted a newline? */
				if(deleteChars(selWindow->fileId,NOUPDATE,0))
					/* if so, force a redrawWindow */
					c = '\r';
			}
			flush();	/* flush the input buffer */
		}
	} else {
		/* for UNIX files only use '\n' not '\r\n' */
		/* state bit 1 == 0 means it is a DOS file */
		if( c != '\r' || (selWindow->state & 0x2) == 0 )
			insertChar(c);
		if( rightMargin < 999 && c != '\r' ) {
/* CPC 4-26-88 */
			if( currentCol == -1 )
				posToxy(selWindow, selBegin, &row, &col);
			else
				col = currentCol;
/* CPC 4-26-88 */
			if( col >
		 	    (rightMargin+selWindow->col1-selWindow->indent+1)
			) {
				saveSelBegin = selBegin;
				saveSelEnd = selEnd;
				while( 1 ) {
					ch = readChar(selWindow->fileId,
						--selBegin);
					if( ch == ' ' || ch == '\n' 
							|| selBegin <= 0 )
						break;
				}
				if( ch == ' ' )
					++selBegin;
				else
					selBegin = saveSelBegin - 1;
				/* no need to set selEnd since */
				/* insertChar does not use it */
				if( (selWindow->state & 0x2) == 0 )
					insertChar('\r');
				insertChar('\n');
/* CPC 4-26-88 */
				currentCol = -1;
/* CPC 4-26-88 */
				if( autoIndent )
					n = doAutoIndent();
				else
					n = 0;
				selBegin = saveSelBegin + n + 2;
				selEnd = saveSelEnd + n + 2;
				updateFile(selWindow->fileId,selBegin,0L,0);
			}
		}
		if( c == '\r' && nlAfterCr ) {
			insertChar('\n');
			if( autoIndent )
				(void)doAutoIndent();
		}
		if( overType ) {
			selEnd = selBegin;
			ch = readChar(selWindow->fileId, selBegin);
			if( ch == '\r' ) {
				if( readChar(selWindow->fileId, selBegin + 1)
				    == '\n' )
					++selEnd;
			}
			else if( ch != '\n' )
				deleteChars(selWindow->fileId, NOUPDATE, 0);
		}
	}
	if( c == '\r' ) {
		posToxy(selWindow, selBegin-2, &insrow1, &n/*dummy*/);
		/* auto-scroll at the bottom of a page */
		if( insrow1+1 >= selWindow->row2 ) {
			n = (selWindow->row2-selWindow->row1+1)/3;
			selWindow->posTopline = nextLine(selWindow->fileId,
				selWindow->posTopline, &n);
			selWindow->numTopline += n;
		}
		/* this is to fix the problem of the very first line of */
		/* a new file not updating correctly */
		if( selWindow->posBotline <= 0 )
			selWindow->posBotline = selBegin;
		n = indentToShowSelection(-1);
		updateFile(selWindow->fileId, selWindow->posTopline, 0L, 0);
		if( n ) {
			redrawWindow(selWindow);
			return;
		}
	} else {
		if( selBegin < selWindow->posTopline )
			doGoSel(selWindow);
		if( !insertPending ) {
			/* set up the screen mask for the selection window */
			inscp = posToxy(selWindow, selBegin, &insrow1,
/* CPC 4-26-88 */
				&currentCol);
/* CPC 4-26-88 */
			inscol1 = selWindow->col1 + 1;
			inscol2 = selWindow->col2 - 1;
			setMap(insrow1, inscol1, insrow1, inscol2, 1, 0x07);
			if( selWindow != windowList ) {
				maskTop(selWindow);
				/* see if the first character of the */
				/* selection is covered by another window, */
				/* if so, top it */
				if( *(screenMap+scrCols*insrow1+currentCol)
								== 0 ) {
					doTopWindow(selWindow, 0);
					/* do it again since the windows */
					/* have changed */
					setMap(insrow1, inscol1, insrow1,
						inscol2, 1, 0x07);
				}
			}
		}

		/* if we have to indent, then redraw the screen */
/* CPC 4-26-88 */
		if( indentToShowSelection(currentCol) ) {
/* CPC 4-26-88 */
			redrawWindow(selWindow);
			updateScreen(selWindow->row1, selWindow->row2);
			return;
		}

		/* do not reset the screen map while doing this drawing */
		/* this is os if the next block loops back with */
		/* insertPending=1, then the "setMap" above will still */
		/* be valid */
		scrMapReset = 1;
		fillLine(selWindow, inscp, insrow1, inscol1, inscol2);
		scrMapReset = 0;
		updateScreen(insrow1, insrow1);
	}
	/* see if another character is waiting */
	if( isKeystroke() != 0 && c != '\r' ) {
/* CPC 4-26-88 */
		/* invalidate the column caching when you see a tab */
		/* or a backspace */
		if( c == '\t' || c == '\b' )
			currentCol = -1;
		else
			++currentCol;
/* CPC 4-26-88 */
		/* call BIOS keyboard handler to get the next character */
		/* but do not remove it from the buffer */
		c = peekKeystroke(&scan);
		/* is it between a backspace and a '~'? */
		/* scan test disallows the Grey keys */
		if( 8 <= c && c <= 126 && scan < 56 ) {
			/* remove it from the buffer */
			(void)getKeystroke(&scan/*dummy*/);
			insertPending = 1;
			goto nextChar;
		}
	}
}


int pascal
/* XTAG:doAutoIndent */
doAutoIndent()
{
	extern unsigned char msgBuffer[];
	extern long selBegin;
	extern struct window *selWindow;

	unsigned char scan;
	long cp;
	int n, charsInserted;

	n = -1;
	cp = prevLine(selWindow->fileId, selBegin-2, &n);
	charsInserted = 0;
	while( 1 ) {
		scan = readChar(selWindow->fileId, cp);
		switch( scan ) {
			case ' ':
			case '\t':
				insertChar(scan);
				++charsInserted;
				break;
			default:
				return charsInserted;
		}
		++cp;
	}
}

void pascal
/* XTAG:insAscii */
insAscii()
{
	int i;
	register unsigned char *fileName;

	fileName = getInput("Enter ASCII code (20=024=0x14): ", "", 0);
	if( fileName == NULL ) {
		msg("Enter ASCII cancelled, no character inserted", 1);
		return;
	}
	if( fileName[0] == '0' && fileName[1] != '\0' ) {
		if( fileName[1] == 'x' )
			sscanf(&fileName[2], "%x", &i);
		else
			sscanf(&fileName[1], "%o", &i);
	} else
		sscanf(fileName, "%d", &i);
	insChar((unsigned char)i, 0);	/* 0 => no NL after CR */
}
