/* CHESS FUNCTION(S): getkeyval, wait_press
/*              DATE: 3/1/93
/*            AUTHOR: C. Schanck
/*
/*       DESCRIPTION:    
/* getkeyval:
/* this routine will wait for a keystroke and return one of three 
/* things, depending on the parameter 'type'.  
/*    type = 0          return 16-bit scancode+ascii value
/*    type = 1          return 8-bit scancode
/*    type = 2          return 8-bit ascii value
/*
/* wait_press:
/* this routine waits until a key is pressed, but does not
/* process the keystroke.
/*
/* These routines illustrate the use of Bingo's BIOS interface.
getkeyval
int type
{
   clear_regs();        /* clear the registers out 
   set_reg("ah",0);     /* set AH to 0 for service 0
   gen_interrupt(22);   /* generate interupt 22 (16 hex)
   if(type==0)       
      return(get_reg("ax"));  /* type 0 returns AX (scancode+ascii value)
   else if(type==1)
      return(get_reg("ah"));  /* type 1 returns AH (scancode)
   else if(type==2)
      return(get_reg("al"));  /* type 2 returns AL (ascii value)
}
/* this will wait until a key is pressed, but it will not 
/* actually process the key.
wait_press
{
   int ok;
   ok=0;
   while(ok==0){
      clear_regs();           /* clear the registers out 
      set_reg("ah",1);        /* set AH to 1 for service 1
      gen_interrupt(22);      /* generate interupt 22 (16 hex) (keyboard)
      ok=get_reg("flags");    /* get the flags
      ok=(ok%128)<64;         /* check if bit 7 is clear
   }
}
