title WRITE PROTECT V2
; wprot2 - Protect Hard disk against write attempts
;
; Assembly: TASM wprot2;
;           TLINK /t wprot2;
;
; Use:      Just type 'wprot2'.
;
; Remarks:  Wprot2 first started as a program to protect hard disks software
;           installation against some very abusive users at the FCT/UNL
;       ( Faculdade de Cincias e Tecnologia da Universidade Nova de Lisboa )
;
; Author:   Jos Pedro T. Pina Coelho
;
; Disclaimer: I do not warrant that wprot2 operates as designed and I
;           will not be liable for any damages caused by the use of
;           this program, by using  this  program  you accept these
;           terms.
;
; Comments & Sugestions:  They are welcome, please send them to:
;               jpc@fctunl.rccn.pt
;       or
;               Jos Pedro T. Pina Coelho
;               Rua Jau N1 2 Dto.
;               1300 Lisboa
;               Portugal
;
; Money: Any amount, any colour, any flavour.  Send/Teleport it to the
;       comments address :  (to me is a comment on this software quality)
;

CR              EQU     13
LF              EQU     10

.model  tiny
.code
org     0100h

start:          jmp     init

old13           dd      (?)             ; Keep this one to chain requests

new13:
                cmp     ah, 03h         ; Write Disk
                je      write_disk
                cmp     ah, 05h         ; Format Cylinder
                je      format_disk
                cmp     ah, 06h         ; Format Cylinder Set Bad Sector Flags
                je      format_disk
                cmp     ah, 07h         ; Format Drive Starting at Cylinder
                je      format_disk
                cmp     ah, 17h         ; Set DASD Type for Format
                je      format_disk
                cmp     ah, 18h         ; Set Media Type for Format
                je      format_disk
                cmp     ah, 1Ah         ; Format Unit
                je      format_disk
        ; I just consider all other calls to be harmless

harmless:       jmp     dword ptr cs:[ old13 ]
wayout:         iret

;
; Here you can do several things:
;       REBOOT
;               - Don't give them a chance
;       Return with status = OK ( 0 )
;               - Make them think the operation succeeded
;       Return with status = Attempted write on protected diskette ( 3 )
;               - State it's forbidden
;       Return with any other status (1,2,4..17,32,64,128,170,187,204,224,255)
;               - If you can't convince them, confuse them
;
write_disk:     test    dl, 80h         ; Bit 7 is 1 for hard drives
                jz      harmless        ; Was to diskette
                call    test_indos      ; Test if both indos and allowed part.
                jnc     harmless        ; It's allowed
                jmp     wprotected      ; Slam the door
format_disk:    test    dl, 80h         ; Bit 7 is 1 for hard drives
                jz      harmless        ; Was to diskette
wprotected:     mov     ah, 3           ; STATUS = Write Protected
                push    bp              ;
                mov     bp, sp          ;
                or      word ptr [bp+6], 0001h  ; Set carry flag in call stack
                pop     bp              ;
                jmp     wayout          ; this one shoud bother you no more


partition:      db      66 dup (?)      ; Partition table

; RETURN: CARRY = FORBIDDEN ( on this partition )
test_partAX     proc    near            ; Test partition AX (0..3)
                push    cx
                mov     cl, 4           ; The size of a partition descriptor is
                shl     ax, cl          ; 16 (2^4) bytes
                pop     cx
                add     ax, offset partition
                mov     si, ax

                mov     al, byte ptr [si+2]     ; AL = C9 C8 S5 S4 S3 S2 S1 S0
                and     al, 0C0h                ; AL = C9 C8 0 0 0 0 0 0
                mov     ah, cl                  ; AH = c9 c8 s5 s4 s3 s2 s1 s0
                and     ah, 0C0h                ; AH = c9 c8 0 0 0 0 0 0
                cmp     ah, al
                jb      forbidd                 ; Was a previous cyl
                ja      test_end                ; In this case we don't need
                                                ; to check others
                cmp     ch, byte ptr [si+3]     ; CH = c7 c6 c5 c4 c3 c2 c1 c0
                jb      forbidd                 ; Was a previous cyl
                ja      test_end                ; In this case we don't need
                                                ; to check others
                mov     al, byte ptr [si+2]     ; AL = C9 C8 S5 S4 S3 S2 S1 S0
                and     al, 03Fh                ; AL = 0 0 S5 S4 S3 S2 S1 S0
                mov     ah, cl                  ; AH = c9 c8 s5 s4 s3 s2 s1 s0
                and     ah, 03Fh                ; AH = 0 0 s5 s4 s3 s2 s1 s0
                cmp     ah, al
                jb      forbidd                 ; Was a previous sect
                ja      test_end                ; In this case we don't need
                                                ; to check others
                cmp     dh, byte ptr [si+1]     ; Compare head number
                jb      forbidd
        ; This part (test_end) is a quick & dirty aproach, it only checks to see
        ; if the write is starting off-limits, not if it writes off-limits
        ; This will be corrected in version 3.0
test_end:
                mov     al, byte ptr [si+6]     ; AL = C9 C8 S5 S4 S3 S2 S1 S0
                and     al, 0C0h                ; AL = C9 C8 0 0 0 0 0 0
                mov     ah, cl                  ; AH = c9 c8 s5 s4 s3 s2 s1 s0
                and     ah, 0C0h                ; AH = c9 c8 0 0 0 0 0 0
                cmp     ah, al
                ja      forbidd                 ; Was a later cyl
                jb      test_type               ; In this case we don't need
                                                ; to check others
                cmp     ch, byte ptr [si+7]     ; CH = c7 c6 c5 c4 c3 c2 c1 c0
                ja      forbidd                 ; Was a later cyl
                jb      test_type               ; In this case we don't need
                                                ; to check others
                mov     al, byte ptr [si+6]     ; AL = C9 C8 S5 S4 S3 S2 S1 S0
                and     al, 03Fh                ; AL = 0 0 S5 S4 S3 S2 S1 S0
                mov     ah, cl                  ; AH = c9 c8 s5 s4 s3 s2 s1 s0
                and     ah, 03Fh                ; AH = 0 0 s5 s4 s3 s2 s1 s0
                cmp     ah, al
                ja      forbidd                 ; Was a later sect
                jb      test_type               ; In this case we don't need
                                                ; to check others
                cmp     dh, byte ptr [si+5]     ; Compare head number
                ja      forbidd                 ; Is over the top

test_type:      mov     al, byte ptr [si+4]
                cmp     al, 00h         ; Unused
                je      forbidd
                cmp     al, 01h         ; DOS Primary 12-Bit Fat
                je      forbidd         ; I consider it to be off-limits
                cmp     al, 04h         ; DOS Primary 16-Bit Fat
                je      forbidd         ; I consider it to be off-limits
                cmp     al, 05h         ; DOS Extended
                je      test_ok         ; The only thing they can write
                cmp     al, 0DBh        ; Concurrent DOS
                je      forbidd         ; I don't know if data is compatible
                                        ; If anybody knows please email.
        ; Other types can be added, some weird DOS versions use weird ID's on
        ; their partition tables, if this program locks your Extended partition
        ; then you probably have one of those versions, use BIOS read to find
        ; out the types your computer uses.
                ; ALL Other types are forbidden by default
                jmp     forbidd

test_ok:        xor ax, ax              ; Clear carry to indicate allowed
                ret
forbidd:        stc                     ; Set carry to indicate forbidden
                ret
test_partAX     endp

; RETURN: CARRY = FORBIDDEN ( on all partitions )
test_indos      proc    near
                push    ax
                push    ds
                mov     ax, cs
                mov     ds, ax

                mov     al, 0
                call    test_partAX
                jnc     testall_ok      ; Is allowed
                mov     al, 1
                call    test_partAX
                jnc     testall_ok      ; Is allowed
                mov     al, 2
                call    test_partAX
                jnc     testall_ok      ; Is allowed
                mov     al, 3
                call    test_partAX

testall_ok:     pop     ds
                pop     ax
                ret
test_indos      endp

init:           mov     ax,cs
                mov     es,ax           ; Initialize ES
                mov     ds,ax           ; Initialize DS
                mov     ss,ax           ; Initialize SS
                mov     sp,offset stke

                mov     ah, 02h         ; Read Disk
                mov     al, 01h         ; # Sectors to read
                mov     bx, offset bootsect ;  offset of pointer to read buffer
                mov     cx, 0001h       ; Cyl 0, Sect 1
                mov     dh, 00h         ; Head 0
                mov     dl, 80h         ; Drive 80h ( First hard disk )
                int     13h             ;

                jnc     readok          ;

                mov     ah,09h          ; Print string$
                mov     dx, offset readerrmess
                int     21h

                mov     ax, 4c01h       ; exit(1)
                int     21

readok:         mov     si, offset bootsect + 01BEh
                mov     di, offset partition
                mov     cx, 66          ; 4 partitons (16b) + 1 signature (2b)
                rep     movsb           ; copy to a safe place

                push    es
                mov     ah,35h          ; Get interrupt vector
                mov     al,13h          ; Number 13h
                int     21h

                lea     di, old13
                mov     word ptr [di],bx
                mov     word ptr [di+2],es
                pop     es

                cmp     bx,offset new13
                jnz     skip

                mov     ah,09h
                mov     dx,offset errmes
                int     21h

                mov     ax,4c01h
                int     21h

skip:           mov     ah,09h
                mov     dx,offset initmes
                int     21h

                mov     ah,25h          ; Set interrupt vector
                mov     al,13h          ; Number 13h
                lea     dx,new13
                int     21h

                lea     dx,init         ; Cutting point for release mem.
                inc     dx
                int     27h

initmes db "   WPROT2.COM   By Jos Pedro T. Pina Coelho   18-Jul-89",LF,CR
        db LF,CR
        db "   Write requests to drive C: will be ignored.",LF,CR
        db "   Format requests to drives C: & D: will be ignored.",LF,CR
        db "   Reboot for normal operation.",LF,CR,"$"
errmes  db "   ERROR: wprot2 is already installed",LF,CR
        db "   wprot2 Chaining not allowed",LF,CR,"$"
readerrmess     db "ERROR: wprot2 can't read partition table",LF,CR,"$"
; Copy of boot sector
bootsect db     512 dup (?)

        dw      512 dup (?)
stke    equ     this word

end     start
