;****************************************************************************
; file: opener.asm     by: Steven M. Gibson, Irvine, CA	    created: 06/06/87
;****************************************************************************
;
;	      * * * PUBLIC DOMAIN COPYRIGHT RELEASE NOTICE * * *
;
; THIS PROGRAM, IN BOTH SOURCE CODE AND OBJECT FORM, HAS BEEN EXPLICITLY
; PLACED INTO THE PUBLIC DOMAIN BY ITS SOLE AUTHOR AND OWNER, STEVEN GIBSON,
; OF IRVINE, CA.  IT MAY THEREFORE BE FREELY REPRODUCED, EXCHANGED, UPLOADED
; AND DOWNLOADED.   HOWEVER THE AUTHOR REQUESTS THAT THIS NOTICE OF RELEASE
; AND ORIGIN OF AUTHORSHIP BE LEFT INTACT IN THIS SOURCE CODE FILE, AND THAT
; THIS PROGRAM OR ITS DIRECT DERRIVATIVES *NOT* BE SOLD FOR PROFIT.   ALSO,
; PLEASE KEEP THE ENTIRE SET OF FILES TOGETHER AS ONE PACKAGE. ----> THANKS.
;
;****************************************************************************
;
;			   About The Program: OPENER
;
; This little utility was written to determine how many handles DOS 3.x will
; ACTUALLY allow to be open at once.  It determines this with the simple
; brute-force approach of opening/creating files until the open/create fails.
; It generates files with sequential alphabetical names which are easy to
; delete:  !AAAA, !AAAB, !AAAC, !AAAD, ..., !AAAZ, !AABA, !AABB, ... 
; As this is done, it displays the file name, its sequence in the
; opening/creation process, and the handle returned by DOS to the
; open/create request.
;
; To delete all files created by this program, simply give the DOS command:
; DEL !*   ...to remove all files beginning with "!".
;
; Since it might be interesting to compare pre-DOS 3.3 opening performance,
; this program, unlike "FILES.COM", *WILL* run under DOS vers 2.0 and later.
;****************************************************************************
;
;			 About These SOURCE CODE FILES:
;
;  This source code file, and the companion FILES.ASM source code file, were
;  written to be instructional, clear, and a bit tutorial in nature. As such
;  they have been commented more heavily than normal self-communication
;  would normally dictate.  I hope you will find them to be interesting,
;  useful, and not overly verbose.  They are also examples of a general
;  coding style I've found to endure quite well.  Adopt it if you like it.
;
;  NOTE: These files were created using the incredible file editor: BRIEF
;
;****************************************************************************
;
;	To make a COM file from this ASM source code:
;
;	masm opener;			<--- assemble the .asm to .obj
;	link opener;			<--- link the .obj to .exe
;	exe2bin opener opener.com	<--- convert .exe to .com
;	del opener.obj			<--- delete the intermediate debris
;	del opener.exe
;
;****************************************************************************


;----------------------------------------------------------------------------
;				 E Q U A T E S
;----------------------------------------------------------------------------
CR			equ	0Dh
LF			equ	0Ah
COM_TERMINATE		equ	20h		; .COM program termination

DOS_FUNC		equ	21h		; Interrupt to call DOS
 DOS_PRINTSTRING	equ	09h		; Dos Sub-Function Defs
 DOS_VERSION_NUMBER	equ	30h		;	"	"
 DOS_CREATE		equ	3Ch		;	"	"
  READ_AND_WRITE	equ	2		;	"	"

VIDEO_IO		equ	10h		; Video BIOS Interrupt Call
 SET_CURSOR_POS		equ	2		; Video Bios Sub Functions
 SCROLL_UP		equ	6		;	"	"
 WRITE_TTY		equ	14		;	"	"
  NORMAL		equ	07h		; Normal Text Video Attribute

MINIMUM_VERSION		equ	2 * 256 + 00	; run with "2"."00" and later

;----------------------------------------------------------------------------
;				  M A C R O S
;----------------------------------------------------------------------------
zero	MACRO p1			; this little macro is just too
		xor	p1,p1		; handy to be without.  It cleanly
	ENDM				; zeros any register.  (You'll see it
					; a lot below)

;----------------------------------------------------------------------------
;			   C O D E    S E G M E N T
;----------------------------------------------------------------------------
CODESEG	SEGMENT BYTE PUBLIC
	ASSUME	CS:CODESEG, DS:CODESEG
	ORG	100h

ComStart:	jmp	StartupStuff

;----------------------------------------------------------------------------
;			       D A T A   A R E A
;----------------------------------------------------------------------------
Iteration	dw	0			; our general purpose counter
ResultStr1	db	"Sequence Number:"	; these amount to two zero-
NumberStr	db	"xxxx,    Filename: "	; terminated strings for disp.
FileName	db	"!AAAA",0		; <--- FileName str for DOS
ResultStr2	db	",    Open Handle ID:"
HandleStr	db	"xxxx",CR,LF,0

WrongDosMsg	db	CR,LF,"You *NEED* DOS 2.00 or later, sorry.",CR,LF,0
FailureMsg:	db	CR,LF,"The file after the last one has "
		db	"FAILED to create/open", CR,LF,0


;----------------------------------------------------------------------------
;		    P R O G R A M    C O D E    B E G I N S
;----------------------------------------------------------------------------
StartupStuff:	mov	ah, DOS_VERSION_NUMBER	; first we need to make sure
		int	DOS_FUNC		; this guy is okay to run
		xchg	ah, al			; make the number linear
		cmp	ax, MINIMUM_VERSION
		jae	Creations		; yep, DOS ver 2.00 or later!

		mov	si, OFFSET WrongDosMsg	; nope, he's using a version
		Call	WriteStringToScreen	; of DOS prior to 2.00!
		int	COM_TERMINATE		; we're not "supposed" to quit
						; this way anymore, but it's
						; so easy! <sigh>

;----------------------------------------------------------------------------
;  Note:  This programs used to start out by closing any open handles, like
;  those which DOS pre-opens for us, but it still wouldn't allow any more
;  than a maximum of 252 files.  So, we'll just leave those open and proceed
;  from there....
;                  So, we open file handles until we fail at that task....
;----------------------------------------------------------------------------
Creations:	inc	Iteration		; bump our open counter
		mov	ax, Iteration		; and display this value
		mov	di, OFFSET NumberStr
		Call	ConvertFourDigits

		Call	AttemptToOpen		; now ask for an "opening"
		jnc	Opened			; ah, No Carry is good...

		mov	si, OFFSET FailureMsg	; that's all folks!
		Call	WriteStringToScreen	; show 'em we're done
		int	COM_TERMINATE		; and quit the easy way!

;----------------------------------------------------------------------------
Opened:		mov	di, OFFSET HandleStr	; opened!... so show the
		Call	ConvertFourDigits	; returned handle number
		mov	si, OFFSET ResultStr1	; and send all this great
		Call	WriteStringToScreen	; stuff out to the screen
		mov	si, OFFSET ResultStr2
		Call	WriteStringToScreen

		Call	GetNextFileName		; Now form the next filename
		jmp	Creations		; and see if we can open it!


;****************************************************************************
;			     S U B R O U T I N E S
;****************************************************************************

AttemptToOpen:
;----------------------------------------------------------------------------
;	     Open the file: "FileName" returning the result in CY
;----------------------------------------------------------------------------
		mov	ah, DOS_CREATE		; Create or Truncate to Zero
		mov	al, READ_AND_WRITE
		zero	cx			; normal file (not hidden,etc)
		mov	dx, OFFSET FileName
		int	DOS_FUNC
Return:		ret


GetNextFileName:
;----------------------------------------------------------------------------
;		Handle Alphabetic-Style FileName Incrementation
;----------------------------------------------------------------------------
		mov	bx, OFFSET FileName+4	; start with last char of name
IncrementChar:	inc	BYTE PTR [bx]		; bump it up
		cmp	BYTE PTR [bx], "Z"	; does it wrap?
		jbe	Return			; borrow neighbor's "ret"

		mov	BYTE PTR [bx], "A"	; yep, return to "A"
		dec	bx			; and advance to prior char
		jmp	IncrementChar		; and increment that one now


ConvertFourDigits:
;---------------------------------------------------------------------------
; Entering with a binary number to convert in AX and the String start in DX,
; begin by "space" blanking the string, then convert into ASCII.
; NOTE: The algorithm for this routine descended directly from BRETT SALTER.
;---------------------------------------------------------------------------
		mov	cx, 4			; our strings are 4 chars long
BlankIt:	mov	BYTE PTR [di], " "	; blank to space
		inc	di			; and head to the end
		loop	BlankIt
		mov	cx, 10			; decimal divisor

ConvertDigit:	zero	dx			; clear any past remainder
		div	cx			; divide by 10
		add	dl, "0"			; convert to ascii
		dec	di			; back up 1 byte to the left
		mov	[di], dl		; stuff the ascii digit
		cmp	ax, 0			; anything left?
		jnz	ConvertDigit		; yep, do another digit!
Return2:	ret


WriteStringToScreen:
;----------------------------------------------------------------------------
;  This writes an ASCIZ string out (quickly) to the screen.  It was chosen
;  over the DOS Int21.09 because it's much faster than 21.09 and because
;  it stops on ZERO rather than "$" making it compatible with the DOS ASCIIZ
;  requirement for FileNames.
;  CALL with "si" pointing to the first character to write.
;----------------------------------------------------------------------------
		lodsb				; si points to the character
		cmp	al, 0			; are we done yet?
		je	Return2			; yep, borrow return above

		mov	ah, WRITE_TTY		; sub function of Int10
		zero	bh			; to screen zero
		int	VIDEO_IO
		jmp	WriteStringToScreen	; and do us 'till done


ClearAndHome:	
;----------------------------------------------------------------------------
;  Okay, starting with a clean slate is always nice, so we'll quickly blank
;  our screen and home the cursor.
;----------------------------------------------------------------------------
		mov	ax, SCROLL_UP*256	; blank the screen
		mov	bh, NORMAL		; this is the normal attrib
		zero	cx			; UpperLeft corner
		mov	dx, 184FH		; LowerRight corner
		int	VIDEO_IO		; call video bios

		mov	ax, SET_CURSOR_POS*256	; position the cursor
		zero	dx			; to Upper Left
		zero	bh			; on page 0
		int	VIDEO_IO
		ret

;----------------------------------------------------------------------------
;		       E N D    O F    T H E    C O D E
;----------------------------------------------------------------------------
CODESEG	ENDS
	END	ComStart

;End of the source code...

