/*        COMBI-Disk demonstration/test program
 *        by Vadim V. Vlasov, Moscow, 1991, 1992.
 *
 * This program may be used to test the reliability of COMBI-disk strategy of
 * memory reallocation between RAM disk and disk cache.
 * It also may demonstrate/test reliability of write caching.
 * 
 * You may modify this program at Your wish, however I'm not responsible
 * for changes You make.
 * 
 * The idea is the following: this program creates 14 files in a directory
 * You specify and randomly writes, seeks, deletes some of the files or
 * performes some DOS command (I've chosen CHKDSK since it reads much from
 * (hard) disk another useful alternative would be some XMS test program).
 * On its exit it leaves some of the files (maybe not all) which contain
 * text: "This text is written to file #<file number>, series <number>..."
 * where <file number> should coincide with the number in the file name,
 * number of lines in each series may be different and moreover the texts
 * may appear not ordered due to random seek. Since pseudo-random number 
 * generator is used the resulting files should be the same regardless of 
 * the target directory provided other command line parameters are the same.
 * So You may run it first on a hard disk and then on COMBI's RAM disk
 * (or vice versa) and compare all the resulting files. If the files are
 * the same there is no error.
 * 
 * Usage:
 *
 * cmbtest [<path> [/c<cycles>] [/r<repetitions>] [/s <command>]
 *
 * where "path"        is a drive letter with ':' or a path ending with '\';
 *       "cycles"      is number of cycles (default - 200); this affects the
 *                     time it takes to run the program and contents of files
 *                     but not necessarily increases file sizes;
 *       "repetitions" is maximum number of lines per write (default - 60),
 *                     it is also used for initialization of random number
 *                     generator; as a rule increases file sizes (and disk 
 *                     storage required);
 *       "command"     is a DOS command to run (default - chkdsk)
 *                     (if command consists of few words it should be
 *                     written in double quotes e.g. "dir *.exe /s").
 *
 * The source is written for MS C 6.0 and may be compiled in TINY or
 * SMALL memory model.
 * 
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

#define  rep_dflt 60
#define  cycles_dflt   200
#define  NUMFILES 14


main(int argc, char *argv[])
{
    int     fhs[NUMFILES]={0};        /* for file handles */
    int     i, j, rn, fn, len;        /* miscellaneous variables */
    int     cycles=cycles_dflt;       /* number of cycles */
    int     repetition=rep_dflt;      /* max number of repetitions  */
    char    name[128];                /* this stores name of file we open */
    char   *command = "CHKDSK";       /* CHKDSK makes a lot of job for
                                       * hard disk and hence for cache  */
    long    nowlen[NUMFILES], nowpos[NUMFILES], seek_shift;
    char    dirname[128] = "";        /* target directory name      */
    char    text1[128];
    char   *form1="This text is written to file #%d, series %d...\n";
                                      /* format of output text  */

    if(argc > 1)          /* if there is an argument it is directory name */
        strcpy(dirname,argv[1]);
    i = strlen(dirname);
    if( i && dirname[i-1] != '\\' && dirname[i-1] != ':') {
      dirname[i] = '\\';    /* add backslash if necessary */
      dirname[i+1] = '\0';
    }

    if(argc > 2) {
      for( i = 2; i < argc; i++) {
        if(argv[i][0] == '/') {
          switch(argv[i][1]){
            case 'c':
            case 'C':
              cycles = atoi(argv[i]+2);
              if ( (cycles <= 0) || (cycles > 1000))
                cycles = cycles_dflt;
              printf("Cycles = %d\n",cycles);
              break;
            case 'r':
            case 'R':
              repetition = atoi(argv[i]+2);
              if ( (repetition <= 0) || (repetition > 1000))
                repetition = rep_dflt;
              printf("Repetitions = %d\n", repetition);
              break;
            case 's':
            case 'S':
              command = argv[i+1];
              i++;
              break;
          }
        }
      }
    }

    srand(repetition + 11);   /* init (pseudo)random number generator */

    for(i=0; i < cycles; i++) {
        fn = rand() % NUMFILES; /* first, choose file we will deal with
                                 * in this series */
        if( fhs[fn] == 0) {     /* open if it is closed */
            sprintf(name,"%sfile%04d.tst",dirname,fn);
            if((fhs[fn]=open(name,O_RDWR|O_CREAT|O_TRUNC|O_TEXT,S_IWRITE|S_IREAD))==-1) {
                perror(name);
                exit(1);
            }
            printf("File #%d opened.\n", fn);
            nowlen[fn] = 0;
            nowpos[fn] = 0;
        }

        rn = rand();
        j = rn % 23;        /* j is afunction number - what will we do to
                             * the file */
        switch(j) {
/*          case 0: */
          case 1: {         /* kill the file  */
            sprintf(name,"%sfile%04d.tst",dirname,fn);
            close(fhs[fn]);
            fhs[fn]=0;
            remove(name);
            printf("File #%d deleted.\n", fn);
            break;
          }
          case 2: {         /* seek backwards or to the beginning of file */
            seek_shift = (long)(rn % repetition)*47;
            if(seek_shift < nowpos[fn])
              nowpos[fn] = lseek(fhs[fn], -seek_shift, SEEK_CUR);
            else
              nowpos[fn] = lseek(fhs[fn], 0L, SEEK_SET);
            break;
          }
          case 3: {         /* seek forward */
            seek_shift = (long)(rn % repetition)*53;
            if( seek_shift + nowpos[fn] < nowlen[fn])
              nowpos[fn] = lseek(fhs[fn], seek_shift, SEEK_CUR);
            else
              nowpos[fn] = lseek(fhs[fn], 0L, SEEK_END);
            break;
          }
          case 4: {         /* seek absolute from beginning of file */
            seek_shift = (long)(rn % repetition)*41;
            if( seek_shift < nowlen[fn])
              nowpos[fn] = lseek(fhs[fn], seek_shift, SEEK_SET);
            else
              nowpos[fn] = lseek(fhs[fn], 0L, SEEK_END);
            break;
          }
          case 5: {         /* seek absolute from end of file */
            seek_shift = (long)(rn % repetition)*37;
            if( seek_shift < nowlen[fn])
              nowpos[fn] = lseek(fhs[fn], -seek_shift, SEEK_END);
            else
              nowpos[fn] = lseek(fhs[fn], 0L, SEEK_SET);
            break;
          }
          case 6: {         /* run DOS command  */
            system(command);
            break;
          }
          default: {        /* for all the others just write random number
                             * of lines into file from current position */
            sprintf(text1,form1,fn,i);
            len=strlen(text1);
            rn = rn % repetition;
            for(j=0; j < rn; j++)
                write(fhs[fn],text1,len);
            nowpos[fn] += rn*len;
            if(nowpos[fn] > nowlen[fn])
               nowlen[fn] = nowpos[fn];
          }
        }
      if(errno) {
        fprintf(stderr,"File number %d :", fn);
        perror(NULL);
        exit(1);
      }
    }

    printf("    Good bye!!!\n");  /* all done */
    for (i = 0; i < NUMFILES; i++)
        if(fhs[i])
        close(fhs[i]);            /* close all files  */
    return(0);
}
