/*
 * pc98.c: demacs.exe pc98 function key support
 *
 * Author: HIRANO Satoshi
 * (C) 1991  Halca Computer Science Laboratory  TM
 *
 * Edition History:
 * 1.1 91/11/18 Halca.Hirano creation
 * 1.2 91/11/26 Halca.Hirano change ESC _ ? -> ESC O ?
 * 1.3 91/11/27 Halca.Hirano DEL generates ^? instead of ESC O ..
 */

#include <dos.h>

struct functionKeyTable {
	char normal[15][16];
	char shift[15][16];
	char cursor[11][6];
	char ctrl[15][16];
};
static struct functionKeyTable newFunkey;
static struct functionKeyTable oldFunkey;

void setOneFunctionKey(char *at, int numFunkey, int len, int base);

void setFunctionKey()
{
	union REGS rg;

	/*
	 * save old settings
	 */
	rg.h.cl = 0x0c;				/* get function key	*/
	rg.x.ax = 0x00ff;			/* get all fkeys	*/
	rg.x.dx = (short)&oldFunkey;
	int86(0xdc, &rg, &rg);

	setOneFunctionKey((char *)(newFunkey.normal), 15, 16, 'A');
	setOneFunctionKey((char *)(newFunkey.shift), 15, 16, 'A'+15);
	setOneFunctionKey((char *)(newFunkey.ctrl), 15, 16, 'A'+30);
	setOneFunctionKey((char *)(newFunkey.cursor), 11, 6, 'A'+45);
	newFunkey.cursor[3][0] = '\x7f'; /* overrides ESC */
	newFunkey.cursor[3][1] = '\0';   /* O */
	newFunkey.cursor[3][2] = '\0';   /* * */
	
	
	rg.h.cl = 0x0d;				/* set function key	*/
	rg.x.ax = 0x00ff;			/* set all fkeys	*/
	rg.x.dx = (short)&newFunkey;
	int86(0xdc, &rg, &rg);

	rg.h.cl = 0x0f;		/* ctrl function key control	*/
	rg.x.ax = 0;		/* enable			*/
	int86(0xdc, &rg, &rg);
}

void setOneFunctionKey(char *at, int numFunkey, int len, int base)
{
    int i, j;

    for (i = 0; i < numFunkey; i++) {
	sprintf(at, "\x1bO%c", base++);
	at += len;
    }
}

void restoreFunctionKey()
{
	union REGS rg;

	rg.h.cl = 0x0d;				/* set function key	*/
	rg.x.ax = 0x00ff;			/* set all fkeys	*/
	rg.x.dx = (short)&oldFunkey;
	int86(0xdc, &rg, &rg);

	rg.h.cl = 0x0f;		/* ctrl function key control	*/
	rg.x.ax = 1;		/* disable			*/
	int86(0xdc, &rg, &rg);
}

