LM0Listing 1: Best of Clipper Aquarium, August 1991

1 /*  
2    Program: GETTEST.PRG  
3    Author:  Greg Lief  
4    Copyright (c) 1991 Greg Lief  
5    Dialect: Clipper 5.01  
6    Compile with: clipper gettest /n  
7    Link with:    rtlink fi gettest /free  
8    If you want to use the @..GGET command, copy the  
9    @..GGET directive to your own header file and then  
10   #include that at the top of your programs.  
11 */  
12 #xcommand @ <row>, <col> GGET <var>                   	;
13                [PICTURE <pic>]                         	;
14                [VALID <valid>]                       	;
15                [WHEN <when>]                        		;
16                [COLOR <color>]   				;
17                [MESSAGE <message>]                 		;
18                                                       	;
19   => SetPos( <row>, <col> )                            	;
20     ; AAdd(                                           	;
21      GetList,                                        	;
22       _GET_( <var>, <(var)>, <pic>, <{valid}>, <{when}>)	;
23           )                                           	; 
24								;
25      ATail(GetList):reader := { | g | MyReader(g) }   	;
26        [ 							; 
27		Atail(GetList):colorDisp( <color> )]  		;
28		[ 						; 
29		Atail(GetList):cargo := <message> ]  
30 
31 #define TEST    // for compiling test code (optional) 
32 #ifdef TEST     // begin test code  
33  
34 function main  
35 local x := 0, y := 0, z := 0  
36 memvar getlist  
37 cls  
38 @ 10, 10 gget x message "This is the first GET"  
39 @ 11, 10 gget y                      // no message  
40 @ 12, 10 gget z message "This is the last GET"  
41 read  
42 return nil  
43  
44 #endif                // end test code  
45 #include "getexit.ch" // needed for exitState constants
46  
47 /*  
48   Function: MyReader()  
49   Purpose:  Alternate to GetReader()  
50   Author:   Greg Lief  
51   Copyright (c) 1991 Greg Lief  
52   Dialect: Clipper 5.01  
53 */  
54 function MyReader( get )  
55 local mess_row := set(_SET_MESSAGE) 
56 // row for displaying messages 
57
58 // read the GET if the WHEN condition is satisfied  
59  if ( GetPreValidate(get) )  
60  
61   /*  
62   the above LOCAL declaration and following IF..ENDIF are
63   the only modifications to the stock GetReader() function
64   */  
65
66   // show message if there is one for this GET  
67   // note that current SET MESSAGE row will be used  
68   // if you prefer, you could default these to another row  
69
70   if get:cargo != NIL  
71      @ mess_row, 0 say padc( get:cargo, maxcol() + 1)  
72   else  
73      scroll(mess_row, 0, mess_row, maxcol(), 0)  
74   endif  
75  
76   // activate the GET for reading  
77   get:SetFocus()  
78  
79   do while ( get:exitState == GE_NOEXIT )  
80  
81      // check for initial typeout (no editable positions)  
82      if ( get:typeOut )  
83         get:exitState := GE_ENTER  
84      endif  
85  
86      // apply keystrokes until exit  
87      do while ( get:exitState == GE_NOEXIT )  
88         GetApplyKey( get, Inkey(0) )  
89      enddo  
90  
91      // disallow exit if VALID condition is not satisfied
92      if ( !GetPostValidate(get) )  
93         get:exitState := GE_NOEXIT  
94      endif  
95  
96   enddo  
97  
98   // de-activate the GET  
99   get:KillFocus()  
100 
101 endif  
102 return  
103 * eof GETS2.PRG  
