Listing 3


/*-------------------------------------------------------------------------*/
/*                                                                         */
/* Oracle OCI Transaction #14  v1.2                                        */
/*                                                                         */
/* Copyright (c) 1991 - M&T Publishing                                     */
/*                                                                         */
/* Programmer : Brian Butler                                               */
/*                                                                         */
/* Description:  Add New Account                                           */
/*                                                                         */
/* Input Fields:                                                           */
/*                                                                         */
/*      AccountID   char(10)                                               */
/*      AccountName char(33)                                               */
/*      AccountType char(4)                                                */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#include "ocidef.h"

extern char AccountID  [11];
extern char Account    [33];
extern char AccountType[4];

long Transaction14 (USHORT usLevel,USHORT usGroup,FILE *df, struct csrdef *cursor)
{
   struct DataFileRecord14 DFR;

   if (fread((char *) &DFR,sizeof(DFR),1,df) > 0) {
      Status.Input[14]++;

      strncpy(AccountID, DFR.AcctID, 9);
      strtrim(AccountID, 10);

      strncpy(Account, DFR.AcctName, 32);
      strtrim(Account, 33);

      strncpy(AccountType, DFR.AcctType, 3);
      strtrim(AccountType, 4);

      if (Status.ShowHeader == TRUE)
       {
         printf ("\n\nOracle 6.0 (OCI) =- Transaction #14 - Add New Account -= [%ld]\n\n",Status.Input[14]);
         printf ("AccountID: %s:\n"   ,AccountID);
         printf ("Account Name: %s:\n",Account);
         printf ("Account Type: %s:\n",AccountType);
       }

      /*-------------------------------------------*/
      /*                                           */
      /*   TRANSACTION 14: Add New Account         */
      /*                                           */
      /*-------------------------------------------*/

      SetStartTime();

      if (osql3 (cursor,

      "INSERT INTO Accounts (ID,Name,Type) \
       VALUES (:AccountID,:Account,:AccountType)",-1)

      || obndrv (cursor,":AccountID",   -1,AccountID,  sizeof(AccountID),  CHRSTR,-1,(short *)-1,(char *)-1,-1,-1)
      || obndrv (cursor,":Account",     -1,Account,    sizeof(Account),    CHRSTR,-1,(short *)-1,(char *)-1,-1,-1)
      || obndrv (cursor,":AccountType", -1,AccountType,sizeof(AccountType),CHRSTR,-1,(short *)-1,(char *)-1,-1,-1))
         {
         ShowError (cursor,"14001 - Parse/Bind of Insert Accounts failed",14);
         goto Op14Failed;
         }

      oexec (cursor);

      if (cursor->csrarc != SUCCESS)
         {
         ShowError(cursor,"14001 - Insert into Accounts failed.",14);
         goto Op14Failed;
         }

      ocom (&LDA);   /* EXEC SQL COMMIT WORK */

      SetEndTime(usLevel,14,usGroup,1L);

      return(1L);

Op14Failed:
      orol (&LDA); /* EXEC SQL ROLLBACK WORK; */

      SetEndTime(usLevel,14,usGroup,-1L);

      return(-1L);
   }
   return((long) EOF);
}
