LISTING 4

class Table
    {
    protected:
        int initialized;
        char *name;
        DWORD NumRecs, CurRec;
        int NumFlds, RecSize, RecDispSize;
        DataField **Fields;

        void SetDefaults(void);
        void Reset(void);

        virtual void GetRec(void) = 0;
        virtual void _GotoRec(DWORD) = 0;
        virtual void _Close(void) = 0;
        virtual int _Open(void) = 0;

    public:
        Table(char *tablename);
        Table(void);
        void SetName(char *tablename);
        int Open(char *tablename);
        int Open(void);
        char *GetNextRecord(void);
        void GotoRec(DWORD rec);
        DWORD GetRecNo(void);
        void Close(void);
        int GetRecDispSize(void);
        DWORD GetNumRecs(void);
        int GetNumFields(void);
        DataField *GetField(int n);

        virtual char *GetRecord(void) = 0;
        virtual void PutRecord(void *) = 0;
        virtual int NextRecord(void) = 0;
        virtual int PrevRecord(void) = 0;
    };
