// == eb_edit.cpp === program to demonstrate edit objects for Emerald Bay
//                    Copyright 1991 Wes Peterson

#include "eb_edit.h"

main()
{
    // initialize the C Toolkit library's data formatting system

 	int check = FmtInit();
    if(check < 0)	{
    	printf("FmtInit() failed.  %s", errormsg(check));
        exit(0);
        }

    // initialize the database handling system & check for engine

    check = DbInit("admin");
    if(!check)    {
        printf("\n  error: Emerald Bay engine not loaded.");
        exit(0);
        }
    if(check < 0) {
        printf("\n  error: %s", errormsg(check));
        exit(0);
        }

    // open the database

    int db = DbLogin("cedit", "");
    if(db < 0)  {
        printf("\n  error: %s", errormsg(db));
        exit(0);
        }

    table names(db, "names");   // create a table object
    names.open();               // open the table

    // create field objects for each field we want to access

    field last_name(names, "last_name");
    field first_name(names, "first_name");
    field addr(names, "addr");
    field city(names, "city");
    field state(names, "state");
    field zip(names, "zip");
    field hourly_wage(names, "hourly_wage");
	field birthdate(names, "birthdate");
    field sex(names, "sex");
	field phone(names, "Phone");
    names.top();                // position the table to the first record
    scr_form f(23, 63, 71);     // create a form, specifying the colors
    f.register_table(&names);   // register our table with the form

    // use at, say, get, a la X-base, to define text & fields

    f.at(22, 16); f.say("Demo supports only PG-UP, PG-DN, ESC, CTRL-ENTER");
    f.at( 6, 12); f.say("Last Name: ");  f.get(last_name);
    f.at( 7, 11); f.say("First Name: "); f.get(first_name);
    f.at( 8, 14); f.say("Address: ");    f.get(addr);
    f.at( 9, 17); f.say("City: ");       f.get(city);  f.set_width(10);
    f.at( 9, 44); f.say("State: ");      f.get(state);
    f.at( 9, 55); f.say("Zip: ");        f.get(zip);
    f.at(10, 12); f.say("Birthdate: ");  f.get(birthdate);
	f.at(10, 46); f.say("Sex: ");        f.get(sex); 
    f.at(11, 17); f.say("Wage: ");       f.get(hourly_wage);
    f.at(11, 44); f.say("Phone: ");      f.get(phone);

    f.read();                   // process the form
    names.close();              // close the table
    DbLogout(db);               // close the database
}
