//== llist.h === Header for LinkedList class ========================
//               Wes Peterson

#include <stdio.h>              // for NULL pointer definition


class LinkedList;


// == ll_node class === has virtual destructor, display, edit members

class ll_node   {               // base class for list nodes
    friend LinkedList;
	ll_node	*prev_node;
    ll_node *next_node;
public:
	virtual ~ll_node(void) {;}; // virtual -- does nothing
} ;


// == LinkedList class ==============================================

class LinkedList    {
	ll_node *first_node;
    ll_node *last_node;
    ll_node *curr_node;
public:
    LinkedList(void) {
        first_node = last_node = curr_node = NULL;
		}
    ~LinkedList(void);
    void    add_node(ll_node *);
    void	drop_curr_node(void);
    ll_node *get_first_node(void)
    	{curr_node = first_node; return(curr_node); }
    ll_node *get_last_node(void)
    	{curr_node = last_node; return(curr_node); }
    ll_node *get_next_node(void); 
    ll_node *get_prev_node(void);
    ll_node *get_curr_node(void) { return(curr_node); }
};

