// == llist.cpp === member functions for LinkedList class ===========
//                  Wes Peterson

#include "llist.h"

LinkedList::~LinkedList(void)   // destructor
{
	ll_node *this_node = first_node;

    while(this_node != NULL)	{
    	first_node = this_node->next_node;
        delete this_node;
        this_node = first_node;
        }
} 

void LinkedList::add_node(ll_node *new_node)
{
	if(curr_node == NULL)	{
    	new_node->prev_node = NULL;
        if(first_node != NULL)	{
        	new_node->next_node = first_node;
            first_node->prev_node = new_node;
            }
        else	{
        	new_node->next_node = NULL;
            last_node = new_node;
            }
        first_node = new_node;
        }
    else	{
    	new_node->next_node = curr_node->next_node;
        new_node->prev_node = curr_node;
        if(curr_node == last_node)
        	last_node = new_node;
        else
        	curr_node->next_node->prev_node = new_node;
        curr_node->next_node = new_node;
    }
    curr_node = new_node;
}

ll_node *LinkedList::get_next_node(void)
{
	if(curr_node == NULL)
    	curr_node = first_node;
    else
    	curr_node = curr_node->next_node;

    return(curr_node);
}

ll_node *LinkedList::get_prev_node(void)
{
	if(curr_node == NULL)
    	curr_node = last_node;
    else
    	curr_node = curr_node->prev_node;

    return(curr_node);
}

