/*****************************************************************
*  MyGroups.C
*  written by Kathy Cea, Platinum Software Int'l.
*
*  Lists all the groups to which the user belongs.
*
*  Calling Syntax:
*     MyGroups
*
*  Compiled in Turbo C 2.0 with NetWare C function calls
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <nit.h>
#include <niterror.h>
#define NO 0
#define YES 1

main() {
    WORD ConnectNumber;
    BYTE loginTime[7];
    long objectId;
    WORD objectType;
    char objectName[48],
         groupName[48];
    BYTE propertyValue[128];
    BYTE moreSegs,
         propertyFlag;
    int segNum;
    BYTE temp[3];
    BYTE holdobjId[9];
    char *endptr;
    int i,j,done;

    segNum = 1;
    moreSegs = 255;

    /* Get the current connection number */
    ConnectNumber = GetConnectionNumber();

    /* Get the Object Name and Object Type */
    GetConnectionInformation(ConnectNumber, objectName,
            &objectType, &objectId, loginTime);

    printf("Groups I'm in:\n");

    /* Read the GROUP_I'M_IN property set until no more groups */
    while (moreSegs) {
       ReadPropertyValue(objectName, OT_USER, "GROUPS_I'M_IN", segNum,
             propertyValue, &moreSegs, &propertyFlag);

        segNum++;
        /* Convert each 4-byte value into a long Object ID */
        i = 0;
        temp[2] = '\0';
        holdobjId[0] = '\0';
        done = NO;
        while (i < 128 && !done) {
            for (j=0; j < 4; j++) {
                sprintf(temp, "%02x", propertyValue[i]);
                temp[2] = '\0';
                strcat(holdobjId, temp);
                i++;
            } /* for */
            objectId = strtoul(holdobjId, &endptr, 16);
            if (objectId == 0)
                done = YES;
            else {
                /* Now that we have the Object ID, get the Group Name */
                GetBinderyObjectName(objectId, groupName, &objectType);
                printf("%s\n",groupName);
                holdobjId[0] = '\0';
             } /* else */
        } /* while (i < 128) */
    } /* while (moreSegs) */
} /* main */

