/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced String class for Turbo C++/Borland C++.                     */
/* Copyright 1991, 1992 by Borland International                        */
/*                                                                      */
/* strng.cpp                                                            */
/* -------------------------------------------------------------------- */

#ifndef _STRNG_H
#include "Strng.h"
#endif

#ifndef __STDLIB_H
#include <stdlib.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef __IOSTREAM_H
#include <iostream.h>
#endif

String::isEqual(const Object& testString) const
{
  return (strLen == ((String &)testString).strLen &&
          !strcmp(strPtr, ((String &)testString).strPtr));
}

int String::isLessThan(const Object& testString) const
{
  return (strcmp(strPtr, ((String &)testString).strPtr) < 0 );
}

hashValueType String::hashValue() const
{
  hashValueType value = hashValueType(0);
  for(int i = 0; i < strLen; i++ )
  {
    value ^= strPtr[i];
    value = _rotl(value, 1);
  }
  return value;
}

void String::printOn(ostream& outputStream) const
{
  outputStream << strPtr;
}
