/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced string class for Turbo C++/Borland C++.                     */
/* Copyright 1991-1993 by Carl W. Moreland                              */
/*                                                                      */
/* parsestr.h                                                           */
/* -------------------------------------------------------------------- */
/* String-derived class for parsing routines.                           */
/* -------------------------------------------------------------------- */

#ifndef _PARSESTR_H
#define _PARSESTR_H

#ifdef BCCL
#include "strng.h"
#else
#include "str.h"
#endif

class ParseString: public String
{
protected:
  unsigned offset;			// offset for parsing

public:
  ParseString();			// default constructor;
  ParseString(const char* p);		// initialize with a char *
  ParseString(const String& s);		// initialize with another String
 ~ParseString(void);

protected:
  void SetStr(const char* p);
  void SetStr(const String& s);
  void AddStr(const char c);
  void AddStr(const char* p);
  void AddStr(const String& s);

public:
  int  Offset(void) { return offset; }	// return the current offset
  const char* Offset(unsigned n);	// set the absolute offset
  void Reset(void);			// set offset = 0

  String& operator=(const char*);	// str1 = char*
  String& operator=(const String&);	// str1 = str
  const char* operator++();		// ++str - increment strPtr
  const char* operator++(int);		// str++ - increment strPtr
  const char* operator--();		// --str - decrement strPtr
  const char* operator--(int);		// str-- - decrement strPtr
  const char* operator+=(const unsigned); // str+=n - increment strPtr
  const char* operator-=(const unsigned); // str-=n - decrement strPtr
};

#endif
