/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced string class for Turbo C++/Borland C++.                     */
/* Copyright 1991-1993 by Carl W. Moreland                              */
/*                                                                      */
/* filestr.h                                                            */
/* -------------------------------------------------------------------- */
/* Class for decomposing a filespec into its drive, path, name, and     */
/* extension.                                                           */
/* -------------------------------------------------------------------- */

#ifndef _FILESTR_H
#define _FILESTR_H

#ifdef BCCL
#include "strng.h"
#else
#include "str.h"
#endif

class FileString
{
public:
  String Drive;			// Ex: "C:"
  String Path;			// Ex: "\BC\CLASSLIB\INCLUDE"
  String FileName;		// Ex: "STRNG.H"
  String Name;			// Ex: "STRNG"
  String Ext;			// Ex: "H"

  FileString(void) {};
  FileString(const char*);
  FileString(const String&);
  void operator=(const char*);
  void operator=(const String&);

private:
  void Process(const String&);
};

#endif
