//**************************************************************************
//      This is a demo program to show how to use some of the features of
//      the VIDBIOS libraries of the ObjectEase package. To compile and run
//      this program create a project file including the files TUI_L.LIB,
//      VIDBIOSL.LIB, and VIDDEMO.CPP. Make sure that these files are located
//      where the project says they are. You may also need to modify the path
//      to the files VIDBIOS.H and TUI.H in the #includes portion of this
//      file.
//
//      BE SURE YOU ARE COMPILING FOR THE LARGE MEMORY MODEL!!!
//**************************************************************************

#include "tui.h"
#include "vidbios.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

//*************************  FUNCTION PROTOTYPES  **************************

void intro();
void demo1();
void demo2();
void demo3();
void demo4();
void demo5();
void demo6();
void outro();

//***************************  GLOBAL VARIABLES  ***************************

unsigned char def_pal[17];
extern Mcursor the_mouse;

//**************************************************************************
//              MAIN
//**************************************************************************

void main()
{
	the_mouse.init();
	cursoroff();
	settext(7,0);
	clrscr();
	intro();
	demo1();
	settext(7,0);
	clrscr();
	demo2();
	settext(7,0);
	clrscr();
	demo3();
	settext(7,0);
	clrscr();
	demo4();
	settext(7,0);
	clrscr();
	demo5();
	settext(7,0);
	clrscr();
	demo6();
	clear(32,0,0);
	dlay(18);

	settext(7,0);
	clrscr();
	cursoron();
	puts("Thank you for previewing the ObjectEase library from");
	puts("David S. Reinhart Associates");
	exit(0);
}

//*************************************************************************

void intro()
{
	Twindow introwindow;
	introwindow.init(4,6,77,18,14,2,0,0);
	introwindow.title("Introduction");
	introwindow.show();

	printc(8,14,2,"This short demo program highlights the video bios features of the");
	printc(9,14,2,"ObjectEase library. Note that these library functions will work ONLY on");
	printc(10,14,2,"VGA cards. If the program you are developing is intended for use on");
	printc(11,14,2,"a variety of video equipment, be sure to test for the existence of");
	printc(12,14,2,"a VGA card before calling these functions. If using an accelerated");
	printc(13,14,2,"video card the fade routines will happen too quickly to be" );
	printc(14,14,2,"appreciated. They will work fine on any standard VGA card.");
	printc(16,15,2,"Press any key now to get on with the show...");

	getch();
	introwindow.hide();
	flushkeys();
}

//*************************************************************************

void demo1()
{
	Twindow demo1window;

	demo1window.init(40,8,76,13,15,1,0,0);
	demo1window.show();
	printat(42,10,15,1," Fade any individual palette color");
	printat(42,11,15,1,"     in and out as desired.     ");

	printat(5,5,1,0,"Blue         ");
	printat(5,6,2,0,"Green        ");
	printat(5,7,3,0,"Cyan         ");
	printat(5,8,4,0,"Red          ");
	printat(5,9,5,0,"Magenta      ");
	printat(5,10,6,0,"Brown        ");
	printat(5,11,7,0,"Lt. Gray     ");
	printat(5,12,8,0,"Dk. Gray     ");
	printat(5,13,9,0,"Br. Blue     ");
	printat(5,14,10,0,"Br. Green    ");
	printat(5,15,11,0,"Br. Cyan     ");
	printat(5,16,12,0,"Br. Red      ");
	printat(5,17,13,0,"Br. Magenta  ");
	printat(5,18,14,0,"Yellow       ");
	printat(5,19,15,0,"White        ");

	delay(1500);
	for(int i=1;i<16;i++) {
		fadeout(i);
		fadein(i);
		}
	demo1window.fill();
	printat(42,11,15,1,"         Press any key...   ");
	getch();
	flushkeys();
	demo1window.hide();
}

//**************************************************************************

void demo2()
{
	Twindow demo2window;
	demo2window.init(20,5,61,10,15,1,0,0);
	demo2window.show();
	printc(7,15,1,"Instantly set any color to black,");
	printc(8,15,1,"then fade in when appropriate.");

	Twindow greenwindow;
	Twindow cyanwindow;
	Twindow redwindow;
	Twindow magentawindow;
	Twindow brownwindow;

	greenwindow.init(15,12,25,17,2,2,0,0);
	blankcolor(2);
	cyanwindow.init(25,12,35,17,3,3,0,0);
	blankcolor(3);
	redwindow.init(35,12,45,17,4,4,0,0);
	blankcolor(4);
	magentawindow.init(45,12,55,17,5,5,0,0);
	blankcolor(5);
	brownwindow.init(55,12,65,17,6,6,0,0);
	blankcolor(6);

	greenwindow.show();
	cyanwindow.show();
	redwindow.show();
	magentawindow.show();
	brownwindow.show();

	delay(1500);
	fadein(2);
	delay(500);
	fadein(3);
	delay(500);
	fadein(4);
	delay(500);
	fadein(5);
	delay(500);
	fadein(6);
	delay(500);

	demo2window.fill();
	printc(8,15,1,"Press any key...");
	getch();
	flushkeys();
	brownwindow.hide();
	magentawindow.hide();
	redwindow.hide();
	cyanwindow.hide();
	greenwindow.hide();
	demo2window.hide();
}

//**************************************************************************

void demo3()
{
	Twindow demo3window;

	demo3window.init(10,5,71,7,15,2,0,0);
	demo3window.show();
	printc(6,15,2,"\"Slide\" from one color into the next for exciting effects!");

	Twindow slidewindow;
	slidewindow.init(20,12,61,22,1,1,0,0);
	slidewindow.show();
	delay(1000);
	fade1_3();
	delay(500);
	fade3_1();
	delay(500);
	fade1_4();
	delay(500);
	fade4_1();
	delay(500);
	fade1_5();
	delay(500);
	fade5_1();
	delay(500);

	demo3window.fill();
	printc(6,15,2,"Press any key...");
	getch();
	flushkeys();
	slidewindow.hide();
	demo3window.hide();
}

//**************************************************************************

void demo4()
{
	Twindow demo4window;
	int r,g,b,i;

	demo4window.init(40,5,75,14,15,1,0,0);
	demo4window.show();
	printat(42,7,15,1,"   Bored with the standard 16");
	printat(42,8,15,1,"         color palette?");
	printat(42,10,15,1,"           CHANGE IT!");

	printat(5,5,1,0,"Color 1      ");
	printat(5,6,2,0,"Color 2      ");
	printat(5,7,3,0,"Color 3      ");
	printat(5,8,4,0,"Color 4      ");
	printat(5,9,5,0,"Color 5      ");
	printat(5,10,6,0,"Color 6      ");
	printat(5,11,7,0,"Color 7      ");
	printat(5,12,8,0,"Color 8      ");
	printat(5,13,9,0,"Color 9      ");
	printat(5,14,10,0,"Color 10     ");
	printat(5,15,11,0,"Color 11     ");
	printat(5,16,12,0,"Color 12     ");
	printat(5,17,13,0,"Color 13     ");
	printat(5,18,14,0,"Color 14     ");
	printat(5,19,15,0,"Color 15     ");

	delay(3000);
	printat(42,12,15,1,"     Press any key to end...");
	flushkeys();
	while(!kbhit()) {
		for(i=1;i<16;i++)
			rgb(i,random(63),random(63),random(63));
		delay(1000);
		}
	set_default_palette();
	delay(2000);
	demo4window.hide();
}

//**************************************************************************

void demo5()
{
	Twindow demo5window;

	demo5window.init(5,5,76,12,15,1,0,0);
	demo5window.show();

	printc(7,15,1,"As you know, if you try to use colors 8 through 15 as");
	printc(8,15,1,"background colors, the foreground begins to blink against your will.");
	delay(2000);
	printc(10,14,1,"Well now you're in control!");

	disable_blink();
	delay(1000);
	printc(15,0,15,"     Black on white    ");
	delay(1000);
	printc(17,5,14,"   Magenta on yellow   ");
	delay(1000);
	printc(19,15,9,"    Any combination!   ");
	delay(2000);

	printc(22,15,0,"Press any key...");

	flushkeys();
	getch();
	enable_blink();
	demo5window.hide();
}

//**************************************************************************

void demo6()
{
	Twindow demo6window;
	demo6window.init(5,5,76,13,15,1,0,0);
	demo6window.show();

	printc(7,15,1,"Ever want to turn the screen off during a massive screen");
	printc(8,15,1,"drawing routine so that the user doesn't have to (or doesn't");
	printc(9,15,1,"get to) see it all happening?");
	delay(3000);
	printc(11,14,1,"Press any key to DO IT!");

	flushkeys();
	getch();
	flushkeys();
	disable_refresh();
	demo6window.hide();

	Twindow w1,w2,w3,w4,w5;
	w1.init(15,5,25,10,15,1,1,7);
	w1.show();
	w2.init(25,7,35,12,15,2,1,7);
	w2.show();
	w3.init(35,9,45,14,15,3,1,7);
	w3.show();
	w4.init(45,11,55,16,15,4,1,7);
	w4.show();
	w5.init(55,13,65,18,15,5,1,7);
	w5.show();

	delay(1000);
	enable_refresh();
	delay(1500);

	printc(22,15,0,"Press any key...");
	flushkeys();
	getch();
}

//**************************************************************************

void outro()
{
	Twindow outrowindow;
	outrowindow.init(4,6,77,18,14,2,0,0);
	outrowindow.title("Summary");
	outrowindow.show();

	printc(8,14,2,"These are the highlights...the raw materials for your");
	printc(9,14,2,"creative ideas. Note that while this demo was in text mode,");
	printc(10,14,2,"these functions work equally as well in graphics mode.");
	printc(11,14,2,"Please read the complete documentation file for specific");
	printc(12,14,2,"information on using these functions in your programs.");
	printc(14,14,2,"Thank you for previewing software from Ludicrous Data.");
	printc(16,15,2,"Press any key now to return to DOS...");

	flushkeys();
	getch();
	flushkeys();
	outrowindow.hide();
}
