//--------------------------------------------------------------------------
//
//      COROUTINE.H: header file for DOS coroutine library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      Revision history:
//      1.0     April 1993      Initial coding
//      1.1     June 1993       Added wait, terminate; tidied private data
//
//--------------------------------------------------------------------------

#ifndef __COROUTINE_H
#define __COROUTINE_H

//--------------------------------------------------------------------------
//
//      Class Coroutine: abstract DOS coroutine base class.
//
//      Note that you must derive a concrete class from this base class
//      by supplying a main function containing the body of the task.
//
class Coroutine
{
    friend class CoroutineManager;
    
  public:
    Coroutine (unsigned stacksize = 2048);  // constructor
    virtual ~Coroutine ();                  // destructor

    int  run ();                            // start coroutine running
    void terminate ();                      // terminate coroutine
    void wait ();                           // wait for coroutine termination

    static void pause ();                   // schedule next coroutine

  protected:
    virtual void main () = 0;               // main body of coroutine

  private:
    CoroutineManager* const entry;
    enum { CREATED, RUNNING, TERMINATED } state;
};

#endif
