unit queues;
interface
const Qmax=32*1024;
type
 Qpos = 0..Qmax;
 Qarray=array[Qpos] of char;
 queue = record
   Qsize: Qpos;
   in_point: Qpos;
   out_point: Qpos;
   a: ^Qarray;
 end;
function NumInQ(Q: queue): Qpos;
function NumAvail (Q: queue): Qpos;
function empty(Q: queue) : boolean;
function full(Q: queue) :boolean;
procedure insertQ(ch: char; var Q: queue);
procedure remove(var ch: char; var Q: queue);
procedure initQ (var Q: queue; maxsize: Qpos);
procedure doneQ (var Q: queue);
implementation

function NumInQ;
begin
  with Q do begin
    if in_point < out_point then
      NumInQ := (in_point + Qsize + 1) - out_point
    else
      NumInQ := in_point - out_point;
  end;
end;

function NumAvail;
begin
  with Q do begin
    NumAvail := Qsize - NumInQ (Q);
  end;
end;

function empty;
begin
    with Q do empty := in_point = out_point;
end;

function full;
begin
  with Q do full := (in_point = out_point - 1) or ((in_point = Qsize) and
   (out_point = 0));
end;

procedure insertQ;
begin
   with Q do begin
      if full(Q) then begin
         writeln('QUEUE FULL ERROR');
         halt;
      end;
      if in_point =  Qsize then
         in_point := 0
      else
         inc (in_point);
      a^[in_point] :=ch;
   end;
end;
procedure remove;
begin
   if empty(Q) then begin
      writeln('QUEUE EMPTY ERROR');
      halt;
   end;
   with Q do begin
      if out_point = Qsize then out_point := 0
      else inc(out_point);
      ch := a^[out_point];
   end;
end;

procedure initQ;
begin
   with Q do begin
     Qsize := maxsize;
     in_point := 0;
     out_point := 0;
     getmem (a, maxsize + 1);
   end;
end;

procedure doneQ;
begin
  with Q do begin
    freemem (a, Qsize + 1);
    Qsize := 0;
    in_point := 0;
    out_point := 0;
    a := nil;
  end;
end;

end.