--************************************************************************
--
--  TYPES.ADS
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1993, Sam Houston St. Univ., TX 77341-2206
--************************************************************************

with system, memory;
with unchecked_conversion;

package Types is

type byte is range 0..255;
type word is range 0..65_535;

--  The following types and functions are declared for use instead of
--  words, and system.address to avoid "alignment holes" in record
--  declarations.  This may not be a problem with other than Meridian's
--  implementation fo ADA.

type bytes is array (word range <>) of byte;
type words is array (word range <>) of word;
subtype  W is bytes(1..2);
subtype DW is bytes(1..4);
function W_to_Word is new unchecked_conversion(W, Word);
function DW_to_SA is new unchecked_conversion(DW, system.address);
function DW_to_Long is new unchecked_conversion(DW, Long_Integer);
function Word_to_W is new unchecked_conversion(Word, W);
function SA_to_DW is new unchecked_conversion(system.address, DW);
function Long_to_DW is new unchecked_conversion(Long_Integer, DW);


subtype string8 is string(1..8);
subtype string16 is string(1..16);


function "+"(left, right: byte) return byte;
function "OR"(left, right: byte) return byte;
function "+"(left, right: word) return word;
function "OR"(left, right: word) return word;
function "+"(left, right: W) return W;
function "OR"(left, right: W) return W;

end Types;