--************************************************************************
--
--  SERVTASK.ADS
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1993, Sam Houston St. Univ., TX 77341-2206
--************************************************************************

with Types; use Types;
with NetBios; use NetBios;
with Drivers; use Drivers;
with system;

package ServerTasks is

task type Nets is
  entry Start(Name: string16);
  entry Call (Ncb: ncbAccess);
  entry ShutDown;
end Nets;
for Nets'storage_size use 512;

type NetAccess is access Nets;

task type CDRoms is
  entry Init(DeviceStrategy  : system.address;
             DeviceInterrupt : system.address);
  entry Call(rh: in out rhs);
  entry ShutDown;
end CDRoms;
for CDRoms'storage_size use 512;

type CDAccess is access CDRoms;

task type Schedulers is
  entry Listen(Net : NetAccess;
               Ncb : ncbAccess);
end Schedulers;
for Schedulers'storage_size use 512;

type SchedulerAccess is access Schedulers;

task type Sessions is
  entry Start(Net       : NetAccess;
              LocalName : string16;
              CD        : CDAccess;
              SubUnits  : byte;
              Scheduler : SchedulerAccess);
end Sessions;
for Sessions'storage_size use 768;
type SessionsAccess is access Sessions;

task type Consoles is
  entry Init(MaxSessions: integer);
  entry SignIn(SessionNumber: byte;
               Client       : String16);
  entry SignOut(SessionNumber: byte);
end Consoles;

Console : Consoles;

end ServerTasks;