
  RPN  ---  A simulation of a Hewlett-Packard scientific calculator.
______________________________

    SYNOPSIS
	rpn  -b <-t top> <-l left> <-c [config-file]>>

	All command-line arguments are optional.  Angle brackets indicate
	associated arguments, square braces indicate optional filenames.
______________________________

    Contents:
	SYNOPSIS
	Contents
	DESCRIPTION
	A Quick Sketch of the HP Calculator Style.
	AVAILABLE FUNCTIONS
		FUNCTIONS
		CONSTANTS
		UNIT CONVERSION functions
		TIME functions
		ANGULAR functions
		MEMORY functions
		STATISTICAL functions
		PRINTING
		MISCELLANEOUS
	SCREEN COLORS
	MEANS
	STANDARD DEVIATION
	LINEAR REGRESSION
	CONFIGURATION FILE
	KNOWN BUGS
	ACKNOWLEDGEMENTS
	VERSION HISTORY
	AUTHOR
______________________________


    DESCRIPTION
	RPN is another calculator, this one using rpn logic in the
	manner of my dear departed HP-29c (R.I.P.).  Almost all of
	the functions are implemented.  There is no programmability
	feature.  All math is done in double-precision floating-point.
	There are 100 memory "registers" (rather than the HP-29c's
	31 "registers"), referred to as M[0] .. M[99].  The memory
	registers are long-double-precision, to give the statistical
	functions somewhat more accuracy.

	A display is drawn on the right side of the screen, showing
	the stack registers, LastX register, last-executed-function,
	the function name currently being entered, and the number base
	in use.  Two Help screens can be called up via the F1 function
	key; these list the available functions and the hexadecimal
	"digits".  The program was written and tested on a CGA display;
	it has been reported to work on a Hercules display.

	(version 2.1)  Optional arguments -t and -l can be supplied
	to open the display at a specified upper-left corner.  Once
	opened, the display may be repositioned as desired by toggling
	on the ScrollLock key and then using the cursor keys.  The Help
	screens may overlap the display in this case, and will get
	turned off as the display moves.  ScrollLock status is
	displayed in the trig-mode window, if it's on.

	(version 3.0) Optional argument -b allows use of the slower
	BIOS output mode, which may be work on less-compatible machines.
	Optional argument -c allows use of a configuration file.  If
	a filename is supplied, that file is used (if it exists).
	Without a filename, RPN will look for an environment variable
	named RPN, whose value is taken as the fully path-qualified
	name of the configuration file.  If the environment variable
	is absent, RPN will look for the filename CONFIG.RPN in the
	current directory and in the root directory.  If no configuration
	file is found, the -c option is a harmless error.

	With version 3.0, RPN departs from straight interpretation of
	an HP-29, by adding a number of numerical and controlling
	functions.
______________________________

    A Quick Sketch of the HP Calculator Style.
	"RPN" is Reverse Polish (in honor of Lukasiewiez) Notation.
	Numbers are entered onto a 4-deep stack, then a function is
	invoked.  The function removes whatever arguments it needs
	from the stack, and puts its result on the stack instead.
	The previous top-of-stack is saved in the "LastX" register,
	from which it can be recalled for reuse or undoing of the
	last function.  The four stack "registers" are named, from
	top to bottom, X, Y, Z, and T.  When a function pops the
	stack the T register replicates itself.
______________________________


    AVAILABLE FUNCTIONS
	Some functions are represented by single keys.  Most of them
	are represented by a multiple-character, carriage-return-
	terminated string.  This string is processed character by
	character (necessary with console input).  Some functions
	have more than one "name" for user convenience.

	In the following list, a comma separates alternate forms
	for a function.  A `#' indicates an integer representing a
	memory register (0..99), a precision (number of displayed
	places, 1..19), or a number base (8,10,16 work).  <CR>,
	<SPACE>, and <ESC> are keys.  A `^' indicates a control
	character; a `@' indicates an ALTernate character.
	All other characters must be entered as shown.


	FUNCTIONS
	    +                Y + X
	    -                Y - X
	    *                Y * X
	    /                Y / X
	    %                X percent of Y (Y unchanged)
	    I                invert X register to (1.0 / X)
	    pow, ^           power function (Y^X  or  Y raised-to-power X)
	    pow10, p10       anti-common-log (10^X)
	    exp              anti-natural-log (e^X  or  exp(X))
	    ln               natural logarithm of X
	    lg               base-2 logarithm of X
	    log              base-10 (common) logarithm of X
	    !, fact          factorial of X register  ( == gamma(X+1) )
	    gamma            gamma function of X register  ( == (X-1)! );
				gamma values are approximated to five
				decimal places (by table lookup)
	    sqr              square of X
	    sqrt             square root of X
	    abs              absolute value of X
	    int              integer portion of X
	    frac             fractional portion of X
	    L                retrieve last X value back into X register
	    C                clear X register
	    X                exchange X register and Y register
	    N, '             change-sign (negate) X register  (quote-mark
				is alternate 1-key form, for convenience)
				This key changes the sign of the mantissa or
				of the exponent, if either is being entered.

	    ru, UpArrow      roll stack up
	    rd, DownArrow    roll stack down
	    clrstk           clear all four stack registers
	    sinh             hyperbolic sine of X
	    cosh             hyperbolic cosine of X
	    tanh             hyperbolic tangent of X
	    isinh            inverse hyperbolic sine of X
	    icosh            inverse hyperbolic cosine of X
	    itanh            inverse hyperbolic tangent of X
	    csch             hyperbolic cosecant of X
	    sech             hyperbolic secant of X
	    coth             hyperbolic cotangent of X
	    icsch            inverse hyperbolic cosecant of X
	    isech            inverse hyperbolic secant of X
	    icoth            inverse hyperbolic cotangent of X


	CONSTANTS
	    pi               load value of pi (3.14159...) into X register
	    c                load 299792.4562 (km/second;
				speed of light in free space)
	    fc               load 1797610211686.842 (c, in furlongs/fortnight)
	    planck           load 6.6261965e-34
				(Joules/second; Planck's Constant)
	    avogadro         load 6.0221694e23  (/ mole;  molecules / mole)
	    epsi             load 8.854e-12  (Farads/meter;
				permittivity of free space (epsilon0))


	UNIT CONVERSION functions -- all these alter the X-register
	    acres            convert hectares to acres
	    cal              convert Joules to calories (not Kilocal.)
	    celsius          convert Fahrenheit to Celsius
	    cuinch           convert gallons to cubic inches
	    deg              convert X from degrees to radians
	    fahr             convert Celsius to Fahrenheit
	    feet             convert meters to feet
	    furlongs         convert yards to furlongs
	    gal              convert liters to gallons
	    hectares         convert acres to hectares
	    igal             convert cubic inches to gallons
	    joules           convert calories to Joules
	    kg               convert pounds (avoirdupois) to kilograms
	    km               convert miles to kilometers
	    lb               convert kilograms to pounds (avdp.)
	    liters           convert gallons (U.S. liq.) to liters
	    ly               convert meters to lightyears
	    lymeters         convert lightyears to meters
	    meters           convert feet to meters
	    miles            convert kilometers to miles
	    mph              convert miles/hour to meters/second
	    mps              convert meters/second to miles/hour
	    rad              convert X from radians to degrees
	    yards            convert furlongs to yards


	TIME functions -- convert between decimal-formatted hours
	and "sexagesimal-formatted" hours, where sexagesimal, or
	base 60, is represented as HH.MMSSfff...  Here HH represents
	hours, MM represents minutes, SS represents seconds, and fff...
	represents fractions of seconds.  (HH may be more than two
	digits.)  Base conversion and roundoff anomalies occasionally
	produce a value such as "12.1860" instead of "12.1900".  Values
	are rounded to nanoseconds to alleviate this.
	Usage note:  these functions also convert degrees-minutes-seconds
	to and from decimal degrees.
	    hms              convert decimal hours in X register to
				sexagesimal format
	    hrs              convert sexagesimal formatted hours in
				X register to decimal format.


	ANGULAR functions
	    ^D               put calculator in "Degree" mode (default)
	    ^R               put calculator in "Radians" mode
	    rad              convert X from degrees to radians
	    deg              convert X from radians to degrees
	    sin              sine of X
	    cos              cosine of X
	    tan              tangent of X
	    asin, arcsin     arcsine of X
	    acos, arccos     arccosine of X
	    atan, arctan     arctangent of X
	    atan2            arctangent of the ratio Y-register / X-register
				(better accuracy for some values)
	    polar            convert X,Y Cartesian coordinates (in X-register
				and Y-register) To R,Theta polar coordinates 
				(R -> X, Theta in radians -> Y)
	    rect             convert polar coordinates (R in X, Theta in Y)
				into X,Y Cartesian coordinates


	MEMORY functions (see also STATISTICAL) -- in the following
	the `#' symbol refers to an address in the range 0..99, or
	`i' (meaning use M[0] contents as an address).
	`#' is a "metanumber", always specified in base 10.
	    clrmem           load 0.0 into all Memory locations
	    clrblk           load 0.0 into range of Memory locations,
				with the lowest index in Y reg. and
				highest index in X reg.
	    sto#, S#         store X into M[ # ]
	    sto+#, S+#       add X-contents to M[ # ]
	    sto-#, S-#       subtract X-contents from M[ # ]
	    sto*#, S*#       multiply M[ # ] by X-contents
	    sto*#, S/#       divide M[ # ] by X-contents
	    rcl#, R#         recall M[ # ] into X-register


	STATISTICAL functions
	    rcls, Rs         recall M[11] into X, M[13] into Y
	    clrsum           load 0.0 into each of M[10] .. M[17],
				load 1.0 into M[18] and M[19].
	    sum+, ]          add X into M[11], X*X into M[12], Y into M[13],
				Y*Y into M[14], X*Y into M[15];
				add inverse of X into M[16], inverse of Y
				into M[17]; multiply X into M[18],
				multiply Y into M[19]; increment M[10]
				(X saved in lastX-reg., M[10] into X-reg.)
	    sum-, [          subtract X from M[11], X*X from M[12], Y from
				M[13], Y*Y from M[14], X*Y from M[15];
				subtract inverse of X from M[16], inverse
				of Y from M[17]; divide M[18] by X,
				divide M[19] by Y; decrement M[10]
				(used to undo a mistaken sum+ function)
	    mean             M[11] / M[10] into X,  M[13] / M[10] into Y
	    sd               sample std.dev. of X's and Y's into X-register
				and Y-register respectively
				(see "STANDARD DEVIATION" below)
	    geomean          n'th root of M[18] into X, n'th root of M[19]
				into Y (M[10] == n)
	    harmean          M[10] / M[16] into X,  M[10] / M[17] into Y

	    clrlin           load 0.0 into each of M[90] .. M[99]
	    linreg           perform a linear regression on X-Y pairs
				accumulated in the summation registers.
				B1 coefficient into X,  B0 coeff. into Y,
				s(y|x) into Z, r-squared into T,
				covariance into LastX.
				* Memory registers also affected; see below.
	    linstats         retrieve statistics from a previous linear
				regression.  s(B1) into X, t(B1) into Y,
				s(B0) into Z, t(B0) into T, F-ratio into
				LastX.  * See below.
	    interpy          perform linear interpolation on x value in X,
				put resulting y value back into X.  This
				uses B0 and B1 coefficients in registers
				90 and 91, and is compatible with the
				`linreg' function.  Also see `lincoeffs'.
	    interpx          perform inverse linear interpolation on
				x value in X, put resulting y value back
				into X.  This uses B0 and B1 coefficients
				in registers 90 and 91, and is compatible
				with `linreg'.  See `lincoeffs'.
	    lincoeffs        calculate and store B0 and B1 coefficients
				into Memory[90] and Memory[91], using
				two points: x1 from T, y1 from Z, and
				x2 from Y, y2 from X.  Order of x and y
				input values differs from `linreg'.


	PRINTING
	    <F2>             Toggle saving of results.  If a savefile
				is already open it is closed.  Otherwise
				a file is opened in the current directory.
				If a name has been typed in, like a
				function (but not entered), then that is
				the filename.  Otherwise the name
				"save-out.rpn" is used.  As each function
				is performed, its name and the contents
				of the Y, X, and LastX registers are
				written.
	    prtstk           print the T, Z, Y, X, and LastX registers
	    prtreg           print the contents of all non-zero memories
	    prtsum           print the contents of the summation memories
				M[10]..M[19]; also the means, stddev's,
				geometric means, and harmonic means
	    prtlin           print the results of a linear regression.
				These are precisely the outputs of the
				`linreg' and `linstats' functions.


	MISCELLANEOUS -- keys used in entering numbers and controlling
	the calculator.  In the following, '#' is a "metanumber",
	specified in base 10.
	    E#               exponent of number currently being entered
				(mantissa is set to 1 if no current value)
	    P#               display # decimal places of the X register
	 			(# range should be 0..15)
	    B#               display numbers in Base # (anything other than
	 			10, 16, 8 is rather flakey; attempting to
	 			display non-integers or oversize numbers
	 			in other than base 10 forces base 10 again)
	    0 .. 9, @A, @B, @C, @D, @E, @F
				The digits for 0 through 15 (10..15 only
	 			needed in base 16).  ALTernate characters
	 			@A .. @F generate the last six digits.
				(Can be changed via the configuration file.)
	    <F3>             toggle between Fixed, Scientific, and Default
				(Base-10) display modes
	    init             re-initialize the calculator (like start-up)
	    <DEL>, <BACKSPACE>  erase the last-entered digit of a new number
	    <CR>             execute the current function;  or,
	 			ENTER the current number or metanumber
	    <SPACE>          ENTER the current number (push stack)
	    <ESC>            close the Help Window if it's showing;
	 			or, erase the current function and go back
	 			to number entry
	    <F1>             Toggle between Help screens 1 & 2, and no screen.
	    <F10>            quit the calculator
	    <CONTROL>-<F10>  quit the calculator but leave windows showing
	    <SHIFT>-<F10>    escape to a subshell pointed to by COMSPEC.
	    <SCROLLLOCK>     use cursor keys to move display window about
______________________________


    SCREEN COLORS
	The program RPNINST may be used to alter the colors of the
	display and help screens.  If it is invoked without a filename
	it will try to use "RPN.EXE".  Its poening menu offers a choice
	of Display (D), Help (H), or Quit (Q).  If D or H is chosen, the
	appropriate screen is shown with a menu indicating groups of
	colors that can be changed by pressing the appropriate Capitalized
	letter.  For the Help screens you can also press `O' to see the
	effect on the "other" help screen.  Other choices are Reset (R)
	to reset the original colors, Save (S) to save the colors you've
	selected, and Quit (Q or <CR>) to abandon your changes.
______________________________


    MEANS
	Given N different values v1 through vN, the `mean', `geometric
	mean', and `harmonic mean' are defined as:

				   v1 + ... + vN
			  mean =  ---------------
				         N
				     _______________
				  N /		    |
		geometric mean =   /  v1 * ... * vN
				 \/

					    N
		 harmonic mean = -----------------------
				  (1/v1) + ... + (1/vN)
______________________________


    STANDARD DEVIATION
	Like the HP calculators, and unlike the inferior, cheap (but
	popularly inexpensive) TI things, this calculates the SAMPLE
	standard deviation rather than the POPULATION standard
	deviation.  The formula for the standard deviation of X,
	given N samples, is:

	                    /  sum(X * X) + [sum(X) * sum(X) / N]  \
	     sd(X) =   sqrt | ------------------------------------ |
	                    \                 N - 1                /

	The difference is in the divisor, which is (N-1) for samples
	but N for populations.  Thus the sample s.d.  is slightly
	larger than the population s.d., reflecting less certainty
	about the location of the mean.

	Population standard deviation is related to sample standard
	deviation by the formula:

	    sqr(POP) = sqr(SAMP) * (N - 1) / N .
______________________________


    LINEAR REGRESSION
	The linear regression routine performs a y(x) least-squares
	fit to the data collected in the summation memories.  The
	Y,X pairs in the summation memories are fitted to the line

		y = B0 + B1 * x .

	The standard errors of the coefficients, s(B0) and s(B1),
	and their t-statistics, t(B0) and t(B1), are calculated;
	also the standard error of the regression, s(y|x), the
	correlation coefficient of the Y's and X's (r-squared),
	the F-ratio of the regression (for two degrees of freedom
	used by the regression), and the covariance.  These values
	are stored in the high memory registers:

		B0		->  M[90]
		B1		->  M[91]
		sqr[ s(B0) ]	->  M[92]
		t(B0)		->  M[93]
		sqr[ s(B1) ]	->  M[94]
		t(B1)		->  M[95]
		sqr[ s(y|x) ]	->  M[96]
		r-squared	->  M[97]
		F-ratio(2, N-2)	->  M[98]
		covariance	->  M[99]

	The defining formulae for these:

		c   =  N*sum(x*y) - sum(x)*sum(y)
	 	det =  N*sum(x*x) - sum(x)*sum(x)
		R1  =  c*c / det	
		T1  =  N*sum(y*y) - sum(y)*sum(y)
		M   =  [ T1 - R1 ] / [ N-2 ]

		B1         =  c / det
		s(B1)      =  sqrt[ M / det ]
		t(B1)      =  B1 / s(B1)
		B0         =  sum(y) / N  -  B1*sum(x) / N
		s(B0)      =  sqrt[ (M / det) * sum(x*x) / N ]
		t(B0)      =  B0 / s(B0)
		s(y|x)     =  sqrt[ M / N ]
		r-squared  =  R / T
		F-ratio    =  R1 / M
		covariance =  c / [ N*(N-1) ]

	References: "Design of Experiments", Richard A. Freund (Eastman
	Kodak Co.); "Glossary and Tables for Statistical Quality Control,
	American Society for Quality Control, 1973
______________________________


    CONFIGURATION FILE
	If RPN.EXE is invoked with a "-c" option, it will attempt to
	read a configuration file.  The path-qualified name may be
	supplied (viz. "rpn -c \etc\myconfig.rpn"); if no name is
	supplied, RPN will check for an environment variable named
	"RPN" whose value is a file name; if that fails it will search
	in the current directory and the device root directory for a
	file named "CONFIG.RPN".  If no file is found, an error message
	is displayed and the calculator starts with default values.

	RPN will not look for the configuration file unless given the
	"-c" option, to allow slightly faster startup.

	The configuration file presently supports three options.  These
	include starting in "BIOS mode" (also a command-line option)
	in which screen display are done through BIOS calls.  This is
	slow, but may be more portable.  The CONST option allows
	pre-storing numeric values into memory registers.  A HEX-
	characters option, in two forms, allows the hexadecimal digits
	to be bound to any keys on the keyboard (instead of the default
	<ALT>-A through <ALT>-F keys).  The keycodes to be used for
	this are in a separate document, "scancode.doc".  Note that
	the option names and values are case-sensitive:  the keywords
	BIOS, CONST, HEXVAL, and HEXCHAR, must be in Capitals.
	Comments preceded by `#' and blank lines are ignored.

	Examples of the usage of these options are given in the supplied
	sample CONFIG.RPN file.
______________________________


    KNOWN BUGS
	Only bases 10, 8, and 16 work.  Any other base shows in red
	and leaves the display in base 10; it may also crash the DFA
	and require an <ESC> and an `init'.

	The input/output is strongly tied to an IBMpc CGA display.
	Source code obeys TurboCv2.0 notions of dpANSI compatibility.

	Decimal-sexagesimal conversions don't really round the
	base-60 numbers correctly on display, because 59.999...
	wants to round to 60 instead of 100.  The underlying
	calculations are rounded to nanoseconds.

	The gamma() function is only approximation, based on a 5-place
	table of gamma values in the range 1.00 to 1.99 (copied from
	the CRC Handbook of Chemistry and Physics, 55th edition), with
	linear interpolation between table entries.  Accuracy will be
	fewer than 5 decimal places (for fractional inputs).  Inputs
	greater than 171 will overflow.
______________________________


    ACKNOWLEDGEMENTS
	This program owes a very little bit to the "rpn calculator"
	in K&R 1st ed. (other than the entire C language, of course).
	Machine description comes from the "Hewlett-Packard
	HP19C/HP29C Owners Handbook and Programming Guide".

	Statistics: "Design of Experiments", Richard A. Freund (Eastman
	Kodak Co.); "Glossary and Tables for Statistical Quality Control,
	American Society for Quality Control, 1973

	Bug reports: Nathan Glasser, Mike Mueller, Martin R. Wittmann.


    VERSION HISTORY
	v3.0 90.05.29  Feeping Creaturism rears its ugly head.
	     Configuration files, save (output) files, sub-shell.
	     Linear-regression and extended statistics,
	     unit conversions, stored constants (fixed ones and
	     loadable-from-configuration-file ones).
	     Screens may be recolored using rpninst.exe.
	     Document `sqr(X)' function, which existed but wasn't
	     listed previously (another oops).
	     Fixed/scientific display notation available.
	     Thoroughly redesigned Help screens.
	     Overflow problems (with statistics and other) are now
	     trapped and handled.
	v2.3 May 1990 Fix a Mem[0] bug and hex-digit/^C gaffe.
	     Hex digits can be set from a configuration file.
	     This maintenance release leads into v3.0.
	v2.2 90.01.23  stack display simplified so that it doesn't
	     round so strangely.  Deletion of fractional digits fixed?
	     Possible bug in error-message display fixed.
	     v2.1 only sent to 3 people; this one will get released.
	v2.1 90.01.04  hrs bugfix, movable display position.
	     Second released version?
	v2.0 90.01.01, RAMontante --- Add sexagesimal conversions,
	     exponent-number entry, degree-mode trig calculations,
	     percent function.  Help screens are statically stored
	     instead of being constructed at first invocation; this
	     is both faster and smaller (but harder to set up in the
	     source code), and may avoid a reported problem with
	     mislocated helpscreens.  Minimal conversions for TCv2.0.
	v1.1 89.12.20, RAMontante (bobmon@iuvax.cs.indiana.edu)
	     documentation fixups, esp. Inverse function!
	     fix `pi' entry bug.
	v1.0 89.01.01, RAMontante  (start the year out right)


    AUTHOR
	R A Montante (bobmon@cs.indiana.edu, bobmon@ucs.indiana.edu)
	Computer Science Department
	Indiana University
	Bloomington, Indiana  47405

    May 29th, 1990
