(*--------------------------------------------------------------------------*)
(*                     Dupl -- Duplicate a character n times                *)
(*--------------------------------------------------------------------------*)

FUNCTION Dupl( Dup_char : Char; Dup_Count: INTEGER ) : AnyStr;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*    Function: Dupl                                                        *)
(*                                                                          *)
(*    Purpose:  Duplicate a character n times                               *)
(*                                                                          *)
(*    Calling Sequence:                                                     *)
(*                                                                          *)
(*       Dup_String := Dupl( Dup_Char: Char; Dup_Count: INTEGER ): AnyStr;  *)
(*                                                                          *)
(*          Dup_Char   --- Character to be duplicated                       *)
(*          Dup_Count  --- Number of times to duplicate character           *)
(*          Dup_String --- Resultant duplicated string                      *)
(*                                                                          *)
(*          Note:  If Dup_Count <= 0, a null string is returned.            *)
(*                                                                          *)
(*    Calls:  None                                                          *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

VAR
   S    : AnyStr;       (* Holds incomplete result *)
   I    : INTEGER;      (* Counter                 *)

BEGIN (* Dupl *)

   S := '';

   FOR I := 1 to Dup_Count DO
      S := S + Dup_Char;

   Dupl := S;

END   (* Dupl *);
