/****************************************************************************/
/*                                                                          */
/* STR_CTRL.C                                                               */
/*                                         Kevin Huck/Boyd Gafford 02/01/92 */
/*                                                                          */
/* We have had several customers try to output strings that contain control */
/* characters such as \r \n \t etc. and wonder why they display funny       */
/* characters in the window. The reason for this is that the UltraWin output*/
/* routines don't process ANY characters differently that ANY OTHER         */
/* characters.  This is done for speed.  However, we decided to show you    */
/* how to extend the library by adding a string function that does process  */
/* these characters and more and can easily be extended.  While not as fast */
/* as other output routines, this routine will make things like file        */
/* browsers easier to write.                                                */
/*                                                                          */
/*------------------------- characters processed ---------------------------*/
/* \r Carriage Return - moves "x" to first column in current row.           */
/* \n Line Feed       - moves "y" down one position, scrolling if at bottom.*/
/* \t Tab             - moves "x" to the next tab column or end of row.     */
/* \b Backspace       - moves "x" back one, outputting a space at that pos. */
/* \007 Bell          - sounds the speaker for 1/10th of a second.          */
/*                                                                          */
/****************************************************************************/
#include <stdlib.h>
#include "uw.h"
#include "uw_globx.h"
#include "uw_keys.h"

/*-------------------------- a golbal WINDOW variable ----------------------*/
WINDOW Main_wn;

/*-------------------------- just some prototypes --------------------------*/
void msg_line( char *msg );
void wn_st_ctrl( char *s, WINDOW *wnp );


/*********/
/* ~main */
/*       ********************************************************************/
/****************************************************************************/
int main()
{
	int i, r;
	WINDOW *wnp = &Main_wn;

	init_video(80, 25);
	init_clock(0x3333);
	wn_create( 0, 0, V_cols-1, V_rows-1, DBL_BDR, WN_NORMAL, wnp );
	wn_color( LIGHTGRAY, BLUE, wnp );
	wn_bdr_color( LIGHTGRAY, BLUE, wnp );
	wn_name("<<< EnQue's String Control Char Processing Demonstration >>>", wnp);
	wn_set(wnp);

	wn_init_tabs(3, wnp);

	mv_cs( 0, 2, wnp );
	wn_st( "This is a string with a CR at the end\r",wnp);
	wait_event();
	wn_st( "This string should overwrite the previous",wnp);
	wait_event();
	mv_cs( 0, 4, wnp );
	wn_st( "This is a string with a LF at the end\n",wnp);
	wait_event();
	wn_st( "This string should be below the previous",wnp);
	mv_cs( 0, 6, wnp );
	wn_st( "This\tis\ta\tstring\twith\tTABS\tbetween\teach\tword",wnp);
	wait_event();
	mv_cs( 0, 8, wnp );
	wn_st( "This is a string with mistakes bacq\bkspaced ovew\br them",wnp);
	wait_event();
	mv_cs( 0, 10, wnp );
	wn_st( "This is a string with a bell\007 character in it",wnp);
	wait_event();

	wn_color(YELLOW,BLUE,wnp);
	mv_cs( 0, 12, wnp );
	wn_st_ctrl( "This is a string with a CR at the end\r",wnp);
	wait_event();
	wn_st( "This string should overwrite the previous",wnp);
	wait_event();
	mv_cs( 0, 14, wnp );
	wn_st_ctrl( "This is a string with a LF at the end\n",wnp);
	wait_event();
	wn_st( "This string should be below the previous",wnp);
	mv_cs( 0, 16, wnp );
	wn_st_ctrl( "This\tis\ta\tstring\twith\tTABS\tbetween\teach\tword",wnp);
	wait_event();
	mv_cs( 0, 18, wnp );
	wn_st_ctrl( "This is a string with mistakes bacq\bkspaced ovew\br them",wnp);
	wait_event();
	mv_cs( 0, 20, wnp );
	wn_st_ctrl( "This is a string with a bell\007 character in it",wnp);
	wait_event();

	msg_line("Demo complete, press any key to quit!");
	wait_event();
	wn_destroy(wnp);
	end_video();
	return(0);
}
/*** end of main ***/

/*************/
/* ~msg_line */
/*           ****************************************************************/
/* Display the message at the last line on the screen.                      */
/****************************************************************************/
void msg_line( char *msg )
{
	int save_att = Main_wn.att;

	wn_color(BLACK, LIGHTGRAY, &Main_wn);
	mv_cs(0, V_rows - 3, &Main_wn);
	wn_claol(&Main_wn);
	wn_plst(CENTERED, V_rows - 3, msg, &Main_wn);
	Main_wn.att = save_att;
}
/*** end of message_line ***/

/***************/
/* ~wn_st_ctrl */
/*             **************************************************************/
/* Take the string and output it to the window with processing!             */
/****************************************************************************/
void wn_st_ctrl( char *s, WINDOW *wnp )
{
	int c, end_flag = 0;

	while( !end_flag )
	{
		switch( c = *s++ )
		{
			case '\0': end_flag = 1;        break;
			case 0x07: tone(1024,10);       break;
			case '\r': wnp->csr_x = 0;      break;
			case '\n': wn_csr_dn(1,wnp);	  break;
			case '\t': wn_tab_right(1,wnp); break;
			case '\b': wn_csr_left(1,wnp), wn_ch(' ', wnp), wn_csr_left(1,wnp); break;
			default  : wn_ch(c, wnp);       break;
		}
	}
}
/*** end of wn_st_ctrl ***/

/**** END OF FILE ****/
