/****************************************************************************/
/*																																					*/
/* UW_PROTO.H 																															*/
/*																																					*/
/* Prototype file for UltraWin.                                             */
/*																													Kevin Huck			*/
/*																													Boyd Gafford		*/
/*																																					*/
/****************************************************************************/

/*------------------------- Prototypes for UW_WIN.C ------------------------*/
void reset_all_masks();
void refresh_desktop();
void refresh_column( int col );
void refresh_row( int row );
void refresh_rect( RECT r );
void add_wn_mask( WINDOW *wnp );
void remove_wn_mask( WINDOW *wnp );
void col_wn_mask( int x_pos, int y_min, int y_max, int amount );
void row_wn_mask( int y_pos, int x_min, int x_max, int amount );
void set_window_attr();
WINDOW *end_window( WINDOW *wnp );
WINDOW *cr_inwindow( int col, int row );
WINDOW *add_window( WINDOW *wnp );
int remove_window( WINDOW *wnp );
void pull_to_top( WINDOW *wnp );
int make_top_window( WINDOW *wnp );
void mask_flags_on();
void move_wn_left( int cols, WINDOW *wnp );
void move_wn_right( int cols, WINDOW *wnp );
void move_wn_up( int rows, WINDOW *wnp );
void move_wn_down( int rows, WINDOW *wnp );
void set_rect(RECT *rectp, int x1, int y1, int x2, int y2);
int rect_equal(RECT r1, RECT r2);
rect_enclosed(RECT *r1, RECT *r2);
int rect_overlap(RECT *r1, RECT *r2);
void offset_rect(RECT *rectp, int col, int row);
int cr_inrect(int col, int row, RECT rect);

/*------------------------- Prototypes for UW_FONT.C ------------------------*/
int encode_color(int r, int g, int b);
void decode_color(int color, int *r, int *g, int *b);
void write_palette( int pnum, uchar val );
void write_palette_all( uchar *vals );
int read_palette( int pnum );
void read_palette_all( uchar *vals );
void set_block_ab(int a, int b);
void blink_enable(int state);
void replicate_enable(int state);
int load_font( uchar *font, char *fname );
int save_font( uchar *font, char *fname, int scan_lines );
void install_font(uchar *font, int block, int offset, int cnt,
	int scan_lines, int setmode );
void rom8x8(int block, int setmode);
void rom8x14(int block, int setmode);
void rom8x16(int block, int setmode);
uchar far *get_font_info( int type, int *scan_lines, int *rows );

/*------------------------- Prototypes for UW_ENTRY.C ------------------------*/
void up_first_char( char *wk_str, char *mask );
void disp_entry( int c, int r, int m_att, char *s, char *m,
								 int offset, int disp_width, int arrow_flag, WINDOW *wnp );
void g_insert( char *s, char *m, char *t, int pos );
void g_delete( char *s, char *m, char *t, int pos );
void g_rtl_insert( char *s, char *m, char *t, int pos );
void g_rtl_delete( char *s, char *m, char *t, int pos );
void add_mask( char *s, char *m, char *t );
int rmv_mask( char *s, char *t );
int validate( char *c, char t );
void strip_entry( char *s, char *m );
void strip_end( char *s, char *m );
void strip_start( char *s, char *m );
int strip_len( char *s, char *m );
int wn_gets( char *str, char *mask, char *template, int m_att,
						 int strip_mode, WINDOW *wnp );
int init_gets_str( char *s, char *m, char *t, char *wk );
void rev_init_gets_str( char *s, char *m, char *t, char *wk );
void reverse_str( char *s );
int wn_gets_ll( char *str, char *mask, char *template, int m_att,
								int flags, int disp_width, WINDOW *wnp );
#ifdef __cplusplus
void set_validation_func( int (*func_ptr)(...) );
void set_gets_hook( int (*func_ptr)(...) );
#else
void set_validation_func( int (*func_ptr)() );
void set_gets_hook( int (*func_ptr)() );
#endif

/*------------------------- Prototypes for UW_MENU.C ------------------------*/
void menu_st( MENU *mnp, int csr, int inx);
void menu_create( int x_min, int y_min, int x_max, int y_max, int direction,
						int back_att, int bdr_att, int csr_att, int first_att,
						int bdr, int type, MENU *mnp );
void item_add( char *entry, int id, int first_pos, MENU *mnp );
void menu_set( MENU *mnp );
void menu_restore( MENU *mnp );
void menu_destroy( MENU *mnp );
void decrement_csr( int *csr, int min, int max);
void increment_csr( int *csr, int min, int max);
int upkey( int key );
int menu_horiz( MENU *mnp, int proc_mode );
int menu_vert( MENU *mnp, int proc_mode );
int do_menu( MENU *mnp, int proc_mode );
int menu_system( MENU *top_mnp, MENU *dropmenu[], int draw_top );

/*------------------------- Prototypes for UW_PRTF.C ------------------------*/
int wn_printf( WINDOW *wnp, char *fmt, ... );

/*------------------------- Prototypes for UW_RFSH.C ------------------------*/
move_n_to_f( int *s, int dest_seg, int dest_off, int cnt );
move_f_to_n( int src_seg, int src_off, int *d, int cnt );
void wn_io( int dir, int area, WINDOW *wnp );
void wn_rfsh_line( int line, WINDOW *wnp );
void wn_rfsh_col( int col, WINDOW *wnp );

/*------------------------- Prototypes for UW_WN.C  ------------------------*/
int wn_create( int x_min, int y_min, int x_max, int y_max, int bdr, int mode, WINDOW *wnp );
void wn_destroy( WINDOW *wnp );
void wn_set( WINDOW *wnp );
void wn_clear( WINDOW *wnp );
void wn_move( int col, int row, WINDOW *wnp );

/*------------------------- Prototypes for UW_LL.C  ------------------------*/
int _csr_adj( WINDOW *wnp );
void _scroll( int dir, WINDOW *wnp );
uchar far *_calc_scr_addr(WINDOW *wnp);
uchar *_calc_buff_addr(WINDOW *wnp);
uchar *_calc_mask_addr(WINDOW *wnp);
void _calc_all_addr(uchar far **scr, uchar **buff, uchar **mask, WINDOW *wnp);

/*------------------------- Prototypes for UW_BDR.C ------------------------*/
void wn_co( int cnt, uchar c, WINDOW *wnp );
void wn_border( WINDOW *wnp );
void wn_hline(int row, int style, WINDOW *wnp);
void wn_vline(int col, int style, WINDOW *wnp);

/*------------------------- Prototypes for UW_MASK.C ------------------------*/
void adjust_mask_col( int x_pos, int y_min, int y_max, int amount, WINDOW *wnp );
void adjust_mask_row( int y_pos, int x_min, int x_max, int amount, WINDOW *wnp );
void set_mask( int mode, WINDOW *wnp1, WINDOW *wnp2 );
void clear_mask( WINDOW *wnp );

/*------------------------- Prototypes for UW_TERM.C ------------------------*/
void wn_claol( WINDOW *wnp );
void wn_cleol( WINDOW *wnp );
void wn_clbol( WINDOW *wnp );
void wn_cleos( WINDOW *wnp );
void wn_clbos( WINDOW *wnp );
void wn_claos( WINDOW *wnp );
void wn_cln(int qty, WINDOW *wnp);
void wn_clear_tabs( WINDOW *wnp );
void wn_init_tabs( int space, WINDOW *wnp );
void wn_set_tab( WINDOW *wnp );
void wn_reset_tab( WINDOW *wnp );
void wn_tab_right( int cnt, WINDOW *wnp );
void wn_tab_left( int cnt, WINDOW *wnp );
void wn_ins_del_chars(int mode, int c, int cnt, WINDOW *wnp );
void wn_ins_del_lines(int mode, int c, int cnt, WINDOW *wnp );
void wn_csr_dn( int qty, WINDOW *wnp );
void wn_csr_up( int qty, WINDOW *wnp );
void wn_csr_left( int qty, WINDOW *wnp );
void wn_csr_right( int qty, WINDOW *wnp );
void wn_csr_pos( int line, int col, WINDOW *wnp );
void wn_scroll_reg( int line_s, int line_e, WINDOW *wnp );
void wn_bksp( int qty, WINDOW *wnp );

/*------------------------- Prototypes for UW_GRAPH.C ------------------------*/
int init_uw_graphics( int xres, int yres, int font_rows, int font_spacing, int seg, int off );
int g_ch( int c, int r, int v );
void compatibility_hook();

/*------------------------- Prototypes for UW_ST.C  ------------------------*/
void wn_st( char *s, WINDOW *wnp );
void wn_st_qty( char *s, int qty, WINDOW *wnp );
void wn_plst( int col, int line, char *s, WINDOW *wnp );

/*------------------------- Prototypes for UW_CSR.C ------------------------*/
void rd_csr( int *col, int *line );
void mv_csr( int col, int line );
void csr_style( int style );
void csr_hide();
void csr_show();
void pl_csr( WINDOW *wnp );

/*------------------------- Prototypes for UW_CH.C  ------------------------*/
void wn_ch( int c, WINDOW *wnp );
void wn_noatt_ch( int c, WINDOW *wnp );
uchar wn_och( WINDOW *wnp );
uchar wn_oatt( WINDOW *wnp );
void wn_qch( int cnt, uchar c, WINDOW *wnp );

/*------------------------- Prototypes for UW_PRINT.C ------------------------*/
int init_printer( char *fname, char *diskbuff, long isize, long msize, PRINT *p );
int end_printer( PRINT *p );
int realloc_printer( long new_size, PRINT *p );
void set_prt_xlat( int state, uchar *xlat, PRINT *p );
int print_char( uchar c, PRINT *p );
int print_str( uchar *str, PRINT *p );
int print_data( uchar *data, int cnt, PRINT *p );
int print_file( char *fname, PRINT *p );
int print_window( WINDOW *wnp, PRINT *p );
int print_screen( PRINT *p );
int print_eol( PRINT *p );
int print_in_bkgrnd( void );
void disp_print_stats( PRINT *p, int mode, WINDOW *wnp );

/*------------------------- Prototypes for UW_EVENT.C ------------------------*/
void m_reset(M_RESET *m);
void m_colrange( int col_min, int col_max );
void m_rowrange( int row_min, int row_max );
void init_mouse();
void end_mouse();
void m_show();
void m_hide();
void m_pos( M_LOC *m );
void m_moveto( int col, int row );
void m_pressed( int button, M_LOC *m );
void m_released( int button, M_LOC *m );
void m_textcursor(int curstype, unsigned arg1, unsigned arg2);
void m_motion( M_MOVE *m );
void m_lpen_on();
void m_lpen_off();
void m_ratio( int horiz, int vert );
void wait_ticks( clock_t ticks );
int get_key();
int check_key();
int event_pending();
void set_idle_func( int (*func_ptr)() );
void wait_event();

/*------------------------- Prototypes for UW_VID.C ------------------------*/
void set_25_rows();
int get_num_rows();
void get_v_mode();
void init_video(int cols, int rows);
void set_vid_addr( int segment, int offset );
void force_video(int force_mode, int cols, int rows);
void end_video();
uchar swap_nibbles( uchar c );
uchar get_att( uchar att );
void check_desq();
void mode43();
void mode25();
ega_vga_check();
void far interrupt clock_vect();
void init_clock(unsigned int speed);
void end_clock();
void clock_speed( uint speed );
void tone( uint freq, int dur );
void sound_off();
void wait_ticks( clock_t ticks );

/**** END OF FILE ****/
