/*
 *  definitions and includes
 *
 */

#include <dos.h>

typedef struct
{ /* time holder */
  int hour;
  int minute;
  int sec;
  int hsec;
} TIME, *TIME_PTR;

#define GET_TIME	0x2c		/* time request		*/
#define DOS_INT		0x21		/* int to call DOS	*/
#define INIT		6		/* initial clock set	*/
/*
 * get_time(n)
 * TIME_PTR n;
 *
 * fills timetype structure n with current time using DOS interrupt 21
 *
 */

get_time(n)
TIME_PTR n;
{
  union REGS inregs;
  union REGS outregs;

  inregs.h.ah = GET_TIME;

  int86(DOS_INT, &inregs, &outregs);

  n->hour = outregs.h.ch;
  n->minute  = outregs.h.cl;
  n->sec  = outregs.h.dh;
  n->hsec = outregs.h.dl;

  return(0);
}

sleep(x)
int x;
{
  int i;
  unsigned s;
  TIME n;               /* current time record */

  i = 0;
  get_time(&n);
  s = n.sec;

  while (i < x){
    while (s == n.sec)
      get_time(&n);
    s = n.sec;
    ++i;
  }
}

msleep(ms)
  int ms;
{ /* sleep for ms miliseconds */
  static long count = 0;
  long loops;
  TIME n1, n2;
  int delay;
  
  if (count == 0)
  { /* wait for a clock tick */
    count = 1000L;
    get_time(&n1);
    delay = n1.hsec;
    while (n1.hsec == delay)
      get_time(&n1);
    /* first get a ballpark figure */
    for (loops = count; loops--; loops = (loops << 1) / 2);
    get_time(&n2);
    delay = (100*n2.sec + n2.hsec) - (100*n1.sec + n1.hsec);
    if (delay < 0) delay += 6000;
printf("1st time %2d:%02d:%02d.%02d\n", n1.hour, n1.minute, n1.sec, n1.hsec);
printf("%02d.%02d ... %02d.%02d\n", n1.sec, n1.hsec, n2.sec, n2.hsec);
printf("delay %d ms\n", 10*delay);
if (delay < 0) exit(0);
    /* this is the first guess */
    count = 100*count / delay;
printf("Delay %d loops/ms\n", count);
    /* this one should be about 2 sec */
    get_time(&n1);
    for (loops = INIT*count; loops--; loops = (loops << 1) / 2);
    get_time(&n2);
    delay = (100*n2.sec + n2.hsec) - (100*n1.sec + n1.hsec);
    if (delay < 0) delay += 6000;
printf("delay %d ms\n", 10*delay);
    count = INIT*100*count / delay;
printf("Delay %d loops/ms\n", count);
  }

  for (loops = ms*count/1000; loops--; loops = (loops << 1) / 2);
}

#ifdef	TEST
#include <stdio.h>
main() {
  msleep(0);
  bdos(6,7); /* bell */
  msleep(6000);
  bdos(6,7);
  msleep(3000);
  bdos(6,7);
}
#endif
