/***************************************************************/
/* File Id.                     GetChars.C.                    */
/* Author.                      Stan Milam.                    */
/* Date Written.                12/02/89.                      */
/*                                                             */
/*            (c) Copyright 1989, 1990 by Stan Milam           */
/*                                                             */
/* Custom Routine to accept buffered input at any location on  */
/* the screen.  Input field on screen can be any color, and the*/
/* length of the input field is specified.  Can use left/rite  */
/* arrow keys, insert, delete, and backspace.                  */
/***************************************************************/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "pcwproto.h"
#include "keys.h"

static void beep(void);

static void beep() {
    _sound(880);
    rest(4);
    _nosound();
}

int get_chars(int row, int col, int fclr, int bclr, int len, char *buffer) {

   int  i, j, k;
   int  ch;

 /*   memset(buffer,0,len); len--; */
   len--;
   qfill(row, col, row, col+len, fclr, bclr, 32);
   qputs(row, col, fclr, bclr, buffer);
   set_cursor_pos(row, col); j = i = 0; k = col;
   for (;;) {
      ch = keyin();
      get_cursor_pos(&row, &k);
      switch (ch) {
         case BOTH_MOUSE_KEY :
         case ENTER : return(0);
         case RITE_MOUSE_KEY :
         case ESC : return(ESC);
         case 3   :                         /* Ctrl C or Ctrl Break */
         case F1  :
         case F2  :
         case F3  :
         case F4  :
         case F5  :
         case F6  :
         case F7  :
         case F8  :
         case F9  :
         case F10 :
         case PGUP:
         case PGDN:
         case TAB :
         case UPARROW:
         case DOWNARROW:
         case SHFTTAB: continue;            /* Ignore all of these keys */

         case HOME:
            j = 0;
            set_cursor_pos(row, col);
            continue;

         case END :
            j = strlen(buffer);
            set_cursor_pos(row, col + j);
            continue;

         case INS :
            i = strlen(buffer);
            if (i >= (len+1) || j >= len) {
               beep();
               continue;
            }
            for (; i > j; i--) buffer[i] = buffer[i-1];
            buffer[j] = (char) SPACES;
            qputs(row, col, fclr, bclr, buffer);
            continue;

         case DEL :
            qputchar(row, k, fclr, bclr, SPACES);
            i = strlen(&buffer[j]) - 1;
            i = (i < 0) ? 0 : i;
            qputchar(row, k + i, fclr, bclr, SPACES);
            memcpy(&buffer[j], &buffer[j+1], strlen(&buffer[j+1]));
            i = strlen(buffer) - 1;
            buffer[(i < 0) ? 0 : i] = 0;
            qputs(row, k, fclr, bclr,&buffer[j]);
            continue;

         case LEFTARROW :
            if (j <= 0) {
               beep();
               continue;
            }
            j--;
            set_cursor_pos(row, --k);
            continue;

         case RITEARROW :
            if (j > len || buffer[j] == 0) {
               beep();
               continue;
            }
            j++;
            set_cursor_pos(row, ++k);
            continue;

         case BACKSPACE :                         /* '\b': */
            if (j <= 0) {
               beep();
               continue;
            }
            i = strlen(&buffer[j]) - 1;
            qputchar(row, k + i, fclr, bclr, SPACES);
            j--;
            memcpy(&buffer[j], &buffer[j+1], strlen(&buffer[j+1])+1);
            qputs(row, --k, fclr, bclr, &buffer[j]);
            set_cursor_pos(row, k);
            continue;

         default  :
            if (j > len) {
               beep();
               continue;
            }
            if ischar(ch) {
                buffer[j++] = (char) ch;
                qputchar(row, k, fclr, bclr, (char) ch);
                set_cursor_pos(row, ++k);
            }
            break;
      }
   }
#ifndef __TURBOC__
   return(0);
#endif
}
