/***************************************************************/
/* File Id.                     PCW_DEMO.C.                    */
/* Author.                      Chris Balthrop.                */
/*                              Stan Milam.                    */
/* Date Written.                ??/??/??.                      */
/*                                                             */
/*             (c) Copyright 1991 by Chris Baltrop.            */
/*             (c) Copyright 1991 by Stan Milam.               */
/*                                                             */
/* This program is a demonstration of some of the amazing cap- */
/* bilities of the PC Windows Library by Stan Milam.  Make use */
/* of the menus and make extensive use of the tmenu() function.*/
/*                                                             */
/***************************************************************/

/* === includes ======================================== */
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <ctype.h>

#include "pcwproto.h"
#include "menu.h"
#include "files.h"

/* === defines ========================================= */
#define FALSE 0
#define TRUE  1
#define ESC 0x1B
#define EVER ;;

#ifndef MK_FP
   #define MK_FP(seg,off)  (void far *)(((long)seg << 16L) | ((long)off))
   #define clrscr()  puts("\x1B[2J")
   #define getche()  (char)getche()
#endif

   /* pc hardware def's */
#define SCROLL_LOCK (unsigned char far *)0x00400017L
#define SCRN_BUF  (unsigned char far *)0xB8000000L
#define SCRN_SEG 0xB800
#define SCRN_OFF 0x0000

/* === global variables ================================ */
char cmdbuf[80];
int err_code;

char *sptr,*eptr,str[80];

   /* --- pc global vars --- */
struct PTRS
{
   unsigned int mem_tmp;
   unsigned int mem_seg;
   unsigned int mem_off;
   unsigned char far *mem;
   unsigned char far *tmp;
} ptrs;

/* static union REGS inregs,outregs;
   static struct SREGS segregs; */

/* === prototypes ====================================== */
char get_a_cmd(void);
void do_a_cmd(char cmd);
int get_hex(char *inptr);
void wait_for_something(void); /* wait for key or mse */


void cmd_b(void);      /* test function Bar */
void cmd_e(void);      /* Edit command */
void cmd_h(void);      /* Help command */
void cmd_k(void);      /* test picKlist style menu's */
void cmd_l(void);      /* test Lotus style menu's */
void cmd_r(void);      /* show PCW_QREF.TXT */
void cmd_p(void);      /* test Pop-up menu's */
void cmd_t(void);      /* test Top style menu's */
void cmd_x(void);      /* ? */
int  demos_menu(void);

static char *intromsg[] = {
   "PC Windows!  PCW is a windowing package written in C for C",
   "using the IBM family of personal  computers and  100% true",
   "compatibles.  PCW supports Microsoft C 5.0+, Turbo C 1.5+,",
   "and MIX POWER C 1.3+.  PCW  not only supports windows.....",
   "it features automatic sensing of the adapter & monitor  in",
   "use.  It also does  QUICK  screen  writes (NO SNOW ON CGA)",
   "with functions like qprintf() & qputs(). Also featured are",
   "popup menus & a variation of the famous  Lotus  menu  with",
   "MOUSE support.  In short, PCW gives  you  control  and all",
   "the video power you can use.  Best of all, PCW is targeted",
   "as FREEWARE software!   Press a key and let's take a look.",
   NULL
};

static char *menumsg[] = {
   "Chris Balthop and I  have  prepared a little demo  for  you.",
   "We are using the built-in menus of PC Windows to demonstrate",
   "just how powerful PC Windows is.   We feature the menus  be-",
   "cause they demonstrate many of  the  capabilites of PCW.  We",
   "hope you enjoy the show.  So use your keyboard or your mouse",
   "and watch PC Windows do its stuff.                          ",
   NULL
};

static char *goodby[] = {
   "Well, I have labored long and hard to bring you PC Windows",
   "and I hope you enjoy it.  After much thought and consider-",
   "ation I have decided to let PCW be FREEWARE so enjoy!!!!  ",
   NULL
};

static char *copyright[] = {
   "PC Windows",
   "(c) Copyright 1989, 1990, 1991, 1992",
   "by",
   "Stan Milam",
   NULL
};


/* === main() ========================================== */
int main(void)
{
   int tl, bl;
   int        i = 0;
   WNDPTR *menuwnd, *msgwnd;

   static TMNUFLDS mainmenu1[] =
      /* select_key, select_col, *item */
      {{ 'F',  2, "Files"    },
       { 'D', 15, "Demos"    },
       { 'E', 27, "Edit"     },
       { 'R', 38, "quickRef" },
       { 'H', 55, "Help"     },
       { 'Q', 70, "Quit"     },
       {  0,   0,  NULL      }};

   static TMNUFLDS mainmenu2[] =
      /* select_key, select_col, *item */
      {{ 'L',  2, "Lmenu"         },
       { 'P', 19, "Pmenu"         },
       { 'K', 33, "picKlist menu" },
       { 'T', 54, "Tmenu"         },
       { 'B', 69, "funcBar"       },
       {  0,   0,  NULL           }};

   static TMNUFLDS *mainmenulist[] = {mainmenu1, mainmenu2, NULL};

   static TMNUTYPE mainmenu =
      { NULL,                              /* previous window pointer */
        1, 1, 3, 80,                       /* urow, ucol, lrow, lcol  */
        YELLOW, BLUE,                      /* fcolor, bcolor          */
        SINGLEALL,LIGHTGRAY,BLUE,          /* btype, bfcolor, bbcolor */
        " PCW_DEMO ",                      /* *title                  */
        TOP,MIDDLE,WHITE,BLUE,      /* tvloc, thloc, tfcolor, tbcolor */
        YELLOW,MAGENTA,                    /* cfcolor, cbcolor        */
        0,0,mainmenulist };                /* bar_pos, wnd_pos, **tlist */

   /* --- coldstart --- */
   vcls();
   get_cursor_size(&tl, &bl);
   set_cursor_size(0, 0);

   /* --- warmstart --- */
   init_mouse();
   menuwnd = maketmenu(&mainmenu);

   if ( mpresent ) hide_mouse();
   bordercolor( BLUE, BLACK );
   msgwnd = wexplode(6,8,20,72,YELLOW,BLACK);
   w_block_write(msgwnd, 2, CENTER, intromsg);
   keywait(30);
   clr_wnd( msgwnd, 1 );
   w_block_write(msgwnd, 4, CENTER, menumsg);
   keywait(30);
   clr_wnd(msgwnd, 1);
   whide( msgwnd );
   if ( mpresent ) show_mouse();

   while (i != 'Q') {
      i = tmenuinput(&mainmenu);
      switch(i) {
         case 'B' : cmd_b(); break;
         case 'D' : demos_menu(); break;
         case 'E' : cmd_e(); break;
         case 'F' : files_menu(); break;
         case 'H' : cmd_h(); break;
         case 'K' : cmd_k(); break;
         case 'L' : cmd_l(); break;
         case 'R' : cmd_r(); break;
         case 'P' : cmd_p(); break;
         case 'T' : cmd_t(); break;
         case 'Q' : continue;
      }
   }
   if (mpresent) hide_mouse();
   wshow( msgwnd );
   w_block_write( msgwnd, 3, CENTER, goodby );
   set_wnd_attr( msgwnd, RED, BLACK );
   w_block_write( msgwnd, 8, CENTER, copyright);
   keywait( 30 );
   msgwnd = wpop( msgwnd );
   menuwnd = wpop(menuwnd);

   /* --- system close --- */
   init_mouse();

   /* --- quit --- */
   vcls();
   set_cursor_size(tl, bl);
   puts("---bye---\n");
   return(0);
}
/* --- end main() -------------------------------------- */


/* === get_hex() ======================================= */
int get_hex(char *inptr) /* convert ascii at inptr to hex */
{
   int i;
   char strbuf[7];
   char *strptr,*endptr;
   strptr = &strbuf[0];
   *strptr++ = '0';    /* stuff in 0x so i don't have to */
   *strptr++ = 'x';
   i = 2;
   while( *inptr == ' ') inptr++;       /* ignore spaces */
   while(*inptr && (i<6))         /* copy up to 6 char's */
   {
      *strptr++ = *inptr++;
      i++;
   }
   *strptr = 0;                  /* terminate str with 0 */
   strptr = &strbuf[0];                 /* reset pointer */
   i = (int)strtol(strptr,&endptr,16);        /* convert */
   if(endptr <= &strbuf[2]) err_code = 1; /* test for err */
   return(i);
}
/* --- end get_hex() ----------------------------------- */


/* === cmd_b() ========================================= */
void cmd_b(void)   /* display function bar */
{
    int row, col, bstatus, done;
    static char *funcs =
       "F1-help   F2-edit   F3-options   F4-next"
       "    F5-goto   F6-zoom          <ESC>quit";
    if (mpresent) hide_mouse();
    qputs(25, 1, YELLOW, BLUE, funcs);
    if (mpresent) show_mouse();

    for(done = 0; !done; )          /*wait for something */
    {
       if(keypressed()) { keybrd_flush(); done++; }
       if(mpresent)
       {
          if(get_mpressed(RITEM)) done++;
          if(get_mpressed(LEFTM)) done++;
          get_mpos(&row, &col, &bstatus);
       }
    }

    if(mpresent) hide_mouse();
    qfill(25,  1, 25, 80, WHITE, BLACK, SPACES);
    if(mpresent) show_mouse();

}
/* --- end cmd_b() ------------------------------------- */


/* === cmd_e() ========================================= */
void cmd_e(void)   /* Edit cmd */
{
    int row, col, bstatus, done;
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "call Edit()");
    if(mpresent) show_mouse();

    for(done = 0; !done; )          /*wait for something */
    {
       if(keypressed()) { keybrd_flush(); done++; }
       if(mpresent)
       {
          if(get_mpressed(RITEM)) done++;
          if(get_mpressed(LEFTM)) done++;
          get_mpos(&row, &col, &bstatus);
       }
    }

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "           ");
    if(mpresent) hide_mouse();
}
/* --- end cmd_e() ------------------------------------- */


/* === cmd_h() ========================================= */
void cmd_h(void)   /* help command */
{
   int row, col, bstatus, done;
   WNDPTR *wnd;
   static char *helpmsg[] =
   { "wframe(), wtitle(), and w_block_write() can be used to",
     "create pop-up help screens",
     "",
     "The following commands are valid   ",
     "   b ---- make function Bar        ",
     "   d ---- Pulldown Demos Menu      ",
     "   e ---- Edit a file              ",
     "   f ---- do Files stuff           ",
     "   h,? -- Help (print this message)",
     "   k ---- picKlist menu demo       ",
     "   l ---- Lotus menu demo          ",
     "   p ---- Pop up-menu demo         ",
     "   q ---- Quit pcw_demo            ",
     "   r ---- show pcw_qRef.txt        ",
     "   t ---- Top menu demo            ",
     " ", " ", "Press any key to return", "", NULL };
   bordercolor(LIGHTBLUE,BLACK);
   titlecolor(WHITE,RED);
   if(mpresent) hide_mouse();
   wnd = wframe(5, 5, 23, 75,YELLOW,BLACK);
   if(wnd == NULL) return;
   wtitle(wnd, TOP,LEFT," Friendly Help ");
   w_block_write(wnd,2,CENTER,helpmsg);
   if(mpresent) show_mouse();

   for(done = 0; !done; )          /*wait for something */
   {
      if(keypressed()) { keybrd_flush(); done++; }
      if(mpresent)
      {
         if(get_mpressed(RITEM)) done++;
         if(get_mpressed(LEFTM)) done++;
         get_mpos(&row, &col, &bstatus);
      }
   }

   if(mpresent) hide_mouse();
   wpop(wnd);
   if(mpresent) show_mouse();
}
/* --- end cmd_h() ------------------------------------- */

/* === cmd_k() ========================================= */
void cmd_k(void)   /* Test picKlist style menu's */
{
   WNDPTR *wnd, *savewnd, *iwnd;

/***********************************************************/
/* Create and initialize the pick-list menu values.        */
/***********************************************************/

static char *selections[] = {
    "Methodology",
    "Word Processors",
    "C Compiler",
    "Pascal Compiler",
    "3270 Emulation",
    "Communications",
    "COBOL Compiler",
    "MASM",
    NULL
};

/**********************************************************/
/* PICKLIST contains elements concerning a picklist menu. */
/* First, there is a pointer to the window to be used,    */
/* then window parameters, border parms, title parms,     */
/* selection bar parms, and finally a pointer back to our */
/* menu options.                                          */
/**********************************************************/

    static PICKLIST plmenu =  {
       NULL,
       15, 30, 19, 50, BLACK,LIGHTGRAY,          /* Window Parms */
       2, RED,LIGHTGRAY,                         /* Border Parms */
       " Main Menu ",TOP,MIDDLE,BLUE,LIGHTGRAY,  /* Title  Parms */
       WHITE,BLUE,                               /* Select Bar color  */
       selections,                               /* pointer to menu list */
       0,0                                       /* bar position offset */
    };

    static char *instructions[] = {
       "To use  the Pick  List Menu  use the \30\31 arrow  keys,",
       "to place the cursor  bar on  the  desired  selection",
       "and then press  enter.  Or, use the Mouse  to  point",
       "and shoot the  selection you want.  ESC or the right",
       "Mouse  key will end the demo.   There  may  be  more",
       "picks  than can be shown in the window. You may  use",
       "the arrow  keys or the Mouse to scroll them.        ",
       NULL
    };

   int i = 0;
   int mxr, mxc;

   chk_video_state(&mxr,&mxc);                   /* Get max rows & cols */
   if (mpresent) hide_mouse();                   /* Hide mouse */
   savewnd = wpush(1,1,mxr,mxc);                 /* Save entire screen */
   if (!savewnd) return;                         /* Exit if cannot save */
   bordercolor(BLUE,LIGHTGRAY);                  /* Set border color */
   titlecolor(BLACK,LIGHTGRAY);                  /* Set the title color */
   iwnd = wexplode(2,10,12,70,RED,LIGHTGRAY);    /* Make instruction window */
   wtitle(iwnd,TOP,LEFT," Pick List Menu Instructions "); /* Title it */
   w_block_write(iwnd, 2, CENTER,instructions);  /* Write instructions to it */
   wnd = make_pick_list(&plmenu);                /* Make a popup window */
   if (mpresent) show_mouse();                   /* Show mouse */
   while (i != -1) {                             /* Do until Esc */
      i = get_pick_list(&plmenu);                /* Get Menu return value */
      if ( i == -1 ) continue;
      if (mpresent) hide_mouse();
      qhchar(22,1,BLACK,BLACK,32,80);            /* Clear msg line */
      qputs(22,99,RED,7,selections[i]);          /* Write the choice */
      if (mpresent) show_mouse();
   }
   if (mpresent) hide_mouse();                   /* Hide the mouse */
   wnd     = wpop(wnd);                          /* Get rid of menu */
   iwnd    = wpop(iwnd);                         /* Get rid of instructions */
   savewnd = wpop(savewnd);                      /* Restore msg row */
                                                 /* And go home */

}
/* --- end cmd_k() ------------------------------------- */


/* === cmd_l() ========================================= */
void cmd_l(void)   /* test lotus style menu's */
{
   int mxr, mxc;
   int i = 0;
   int index = 0;
   WNDPTR *menuwnd, *savewnd, *iwnd;

   static LMNUFLDS menu1[] =
       /* select_key, select_col, *item, *item_msg */
      {{ 'A', 2, "Add",    "Add an Entry to Database"},
       { 'C', 17,"Change", "Change a Database Entry"},
       { 'D', 33,"Delete", "Delete a Database Entry"},
       {  0 ,  0,    NULL,  NULL}};

   static LMNUFLDS menu2[] =
      {{ 'P', 2, "Purge", "Purge the Workfile"},
       { 'S', 18,"Send",  "Send Electronic Mail"},
       { 'E', 35,"Exit",  "Exit the Program"},
       {  0,   0, NULL ,NULL }};

   static LMNUFLDS *menulist[] = {menu1, menu2, NULL};

   static LMNUTYPE lmenu =
      { NULL,                         /* initial window ptr    */
        22, 1, 25, 80,                /* window boundaries     */
        BLUE, LIGHTGRAY,              /* window color          */
        DOUBLEALL,RED,LIGHTGRAY,      /* border type and color */
        " Lmenu Type ",               /* menu title            */
        TOP,LEFT,BLACK,LIGHTGRAY,     /* title loc and color   */
        WHITE,BLUE,                   /* select bar color      */
        0,0,menulist };    /* bar pos, wnd pos, ptr to options */

   static char *selections[] =
      { "call Add()     ", "call Change()  ", "call Delete()  ",
        "call Purge()   ", "call Send()    ", "               " };


   static char *instructions[] = {        /* Some instructions */
      "To use this menu you may use the arrow keys, PgUp, PgDn,",
      "Home and the End keys. More than one menu may be stacked",
      "into one window, therefore, you may  page  through them.",
      "Arrow to your selection and press enter, or  use the hot",
      "character (usually the first character of the selection)",
      "or use the Mouse.  You may use the Mouse to page through",
      "the menus by clicking on the arrows at  either  side  of",
      "the menu.  Play with it .... it will suprise you!       ",
      NULL
   };


   if (mpresent) hide_mouse();
   chk_video_state(&mxr, &mxc);
   savewnd = wpush(1,1,mxr,mxc);                  /* Save entire screen */
   bordercolor(BLUE, LIGHTGRAY);
   titlecolor(RED,LIGHTGRAY);
   iwnd = wexplode(2,10,13,70,BLACK,LIGHTGRAY);
   wtitle(iwnd,TOP,RITE," Lmenu Instructions ");
   w_block_write(iwnd, 2, CENTER, instructions);
   qputs(20, 30, WHITE, RED,"Your Choice: ");    /* Message line */
   menuwnd = makelmenu(&lmenu);
   if (mpresent) show_mouse();
   do
   {
      i = lmenuinput(&lmenu);
      switch(i)
      {
         case 'A' : index = 0; break;
         case 'C' : index = 1; break;
         case 'D' : index = 2; break;
         case 'P' : index = 3; break;
         case 'S' : index = 4; break;
         case 27  :
         case 'E' : index = 5; break;
         default  : index = 5;
      }
      if(mpresent) hide_mouse();
      qputs(20,44,WHITE,BLACK,selections[index]);
      if(mpresent) show_mouse();
   }
   while (i != 'E' && i != ESC);

   if (mpresent) hide_mouse();
   menuwnd = wpop(menuwnd);
   iwnd    = wpop(iwnd);                          /* Remove instructions */
   savewnd = wpop(savewnd);                       /* Remove trash */
   if (mpresent) show_mouse();

}
/* --- end cmd_l() ------------------------------------- */


/* === cmd_p() ========================================= */
void cmd_p(void)   /* test pop-up menu's */
{
   WNDPTR *wnd, *savewnd, *iwnd;

/***********************************************************/
/* Initialize the popup menu structures defined in menu.h. */
/***********************************************************/

   static PMNUFLDS pitems[] = {
       { '1', "1. Methodology                   "},
       { '2', "2. Word Processors               "},
       { '3', "3. ITI Mainframe Communications  "},
       { '4', "4. C Programming Environment     "},
       { '5', "5. Pascal Programming Environment"},
       { 'e' ,"E. Esc or Right Mouse Key - Exit "},
       {  0,  ""}
    };

/**********************************************************/
/* PMNUTYPE contains elements concerning a popup menu.    */
/* First, there is a pointer to the window to be used,    */
/* then window parameters, border parms, title parms,     */
/* selection bar parms, and finally a pointer back to our */
/* menu options.                                          */
/**********************************************************/

    static PMNUTYPE  pmenu =  {
       NULL,
       13, 20, 20, 60, BLACK,LIGHTGRAY,          /* Window Parms */
       2, RED,LIGHTGRAY,                         /* Border Parms */
       " Main Menu ",TOP,MIDDLE,BLUE,LIGHTGRAY,  /* Title  Parms */
       WHITE,BLUE,0,                             /* Select Bar   */
       pitems                                    /* pointer to menu list */
    };

    static char *instructions[] = {
       "To use the  Popup  Menu  use  the  \30\31  arrow  keys,",
       "to place the cursor bar on  the  desired  selection",
       "and then press enter.  Or, use the SELECT CHARACTER",
       "at left of each selection, or...use  the  Mouse  to",
       "point and shoot the selection you want.  ESC or the",
       "right Mouse key will end the demo.                 ",
       NULL
    };

    static char *selections[] = {
       "Methodology",
       "Word Processors",
       "ITI Mainframe Communications",
       "C Programming Environment",
       "Pascal Programming Environment"
    };

    int i = 0;
    int mxr, mxc;

   chk_video_state(&mxr,&mxc);                   /* Get max rows & cols */
   if (mpresent) hide_mouse();                   /* Hide the mouse */
   savewnd = wpush(1,1,mxr,mxc);                 /* Save entire screen */
   if (!savewnd) return;                         /* Exit if cannot save */
   bordercolor(BLUE,LIGHTGRAY);                  /* Set border color */
   titlecolor(BLACK,LIGHTGRAY);                  /* Set the title color */
   iwnd = wexplode(2,10,11,70,RED,LIGHTGRAY);      /* Make instruction window */
   wtitle(iwnd,TOP,LEFT," Popup Menu Instructions "); /* Title it */
   w_block_write(iwnd, 2, CENTER,instructions);  /* Write instructions to it */
   wnd = makepmenu(&pmenu);                      /* Make a popup window */
   if (mpresent) show_mouse();                   /* Show the mouse */
   while (i != 27 && i != 'e') {                 /* Do until Esc */
      i = pmenuinput(&pmenu);                    /* Get Menu return value */
      switch(i) {
         case '1' :
         case '2' :
         case '3' :
         case '4' :
         case '5' :
            if (mpresent) hide_mouse();
            i -= 48;
            qhchar(22,1,BLACK,BLACK,32,80);          /* Clear msg line */
            qputs(22,99,RED,7,selections[i-1]);  /* Write the choice */
            if (mpresent) show_mouse();
            break;
         default: break;
      }
   }
   if (mpresent) hide_mouse();                   /* Hide the mouse */
   wnd     = wpop(wnd);                          /* Get rid of menu */
   iwnd    = wpop(iwnd);                         /* Get rid of instructions */
   savewnd = wpop(savewnd);                      /* Restore msg row */
                                                 /* And go home */
}

/* --- end cmd_p() ------------------------------------- */


/* === cmd_r() ========================================= */
void cmd_r(void)   /* show quick reference */
{
    WNDPTR *wnd;
    int mxr, mxc;

    if(mpresent) hide_mouse();
    chk_video_state(&mxr, &mxc);
    bordercolor(YELLOW, BLUE);
    titlecolor( LIGHTGRAY, RED );
    wnd = wframe(1, 1, 20, 80, LIGHTGRAY, BLUE);
    wtitle(wnd, TOP, MIDDLE, " PCW_QREF.TXT ");
    set_int29();

    system("type pcw_qref.txt");

    puts("====== wow! any key to return ======");
    wait_for_something();
    reset_int29();
    wpop(wnd);

    if(mpresent) show_mouse();

}
/* --- end cmd_r() ------------------------------------- */


/* === cmd_t() ========================================= */
void cmd_t(void)   /* test top style menu's */
{
   int    i = 0;
   int    index = 0;
   int    mxr, mxc;
   WNDPTR *menuwnd, *iwnd, *savewnd;

   static TMNUFLDS tmenu1[] =
       /* select_key, select_col, *item */
      {{ 'A', 2, "Add"    },
       { 'C', 17,"Change" },
       { 'E', 33,"Exit" },
       {  0,   0, NULL }};

   static TMNUFLDS tmenu2[] =
       /* select_key, select_col, *item, *item_msg */
      {{ 'P', 2, "Purge" },
       { 'S', 18,"Send"  },
       { 'D', 35,"Delete"  },
       {  0,   0, NULL }};

   static TMNUFLDS *tmenulist[] = {tmenu1, tmenu2, NULL};

   static TMNUTYPE tmenu =
      { NULL,                              /* previous window pointer */
        16,  1, 18, 80,                    /* urow, ucol, lrow, lcol  */
        YELLOW, BLUE,                      /* fcolor, bcolor          */
        SINGLEALL,LIGHTGRAY,BLUE,          /* btype, bfcolor, bbcolor */
        " Tmenu Type ",                    /* *title                  */
        TOP,MIDDLE,WHITE,BLUE,      /* tvloc, thloc, tfcolor, tbcolor */
        YELLOW,MAGENTA,                    /* cfcolor, cbcolor        */
        0,0,tmenulist };                 /* bar_pos, wnd_pos, **tlist */

   static char *selections[] =
      { "call Add()     ", "call Change()  ", "               ",
        "call Purge()   ",  "call Send()    ", "call Delete() " };

   static char *instructions[] = {               /* Some instructions */
      "The 'tmenu' function was generated by customizing the    ",
      "'lmenu' code. The 'info' line was removed and ESC was    ",
      "changed to act as a home key and bring you back to the   ",
      "top menu. A specific action is required quit -- a key    ",
      "entry of 'e' or 'E' or a mouse click on 'Exit' in the    ",
      "menu bar. Note: The source code from Stan is well commented",
      "and the effort to create a custom menu type was minimal. ",
      "                              ...... Thank's Stan ...... ",
      NULL
   };

   chk_video_state(&mxr, &mxc);     /* Get max rows and cols */
   if (mpresent) hide_mouse();      /* Hide the mouse        */
   savewnd = wpush(1, 1, mxr, mxc); /* Save entire screen    */
   if(!savewnd) return;             /* Exit if cannot save   */
   bordercolor(WHITE, LIGHTGRAY);   /* Set the border color  */
   titlecolor(BLACK, LIGHTGRAY);    /* Set the title color   */
   setborder(SINGLESIDES);
   iwnd = wframe(2, 10, 11, 70, RED, LIGHTGRAY); /* make window */
   wtitle(iwnd, BOTTOM, RITE, " Top menu instructions ");
   w_block_write(iwnd, 1, CENTER, instructions);
   menuwnd = maketmenu(&tmenu);     /* Make a top menu       */
   if (mpresent) show_mouse();      /* Show mouse            */
   while (i != 'E' && i != 27) {    /* DO UNTIL 'Exit'       */
      i = tmenuinput(&tmenu);
      switch(i) {
         case 'A' : index = 0; break;
         case 'C' : index = 1; break;
         case 'E' : index = 2; break;
         case 'P' : index = 3; break;
         case 'S' : index = 4; break;
         case 'D' : index = 5; break;
      }
      if(mpresent) hide_mouse();
      qputs(14,CENTER,WHITE,BLACK,selections[index]);
      if(mpresent) show_mouse();
   }
   if (mpresent) hide_mouse();    /* Hide mouse         */
   menuwnd = wpop(menuwnd);       /* Get rid of menu    */
   iwnd    = wpop(iwnd);     /* Get rid of instructions */
   savewnd = wpop(savewnd);          /* Restore screen  */
                                         /* And go home */
   if (mpresent) show_mouse();

}
/* --- end cmd_t() ------------------------------------- */


/* === wait_for_something() ============================ */
void wait_for_something(void) { /* wait for key or mse */

    int done;

    for(done = 0; !done; )          /*wait for something */
    {
       if(keypressed()) { keybrd_flush(); done++; }
    }
}
/* --- end wait_for_something() ------------------------ */


/* === end pcw_demo.c ================================== */
