/***************************************************************/
/* File Id.                     Wscroll.C                      */
/* Author.                      Stan Milam.                    */
/* Date Written.                                               */
/*                                                             */
/*             (c) Copyright 1989-90 by Stan Milam             */
/*                                                             */
/* Comments:  Scroll the contents of the window count times.   */
/* If count is < 0 scrolling will be up and down if positive.  */
/* If the action flag is non-zero scrolling will be inside of  */
/* the borders.                                                */
/***************************************************************/

#include <stdio.h>
#include "pcw.i"
#include "pcwproto.h"

int wscroll(WNDPTR *wnd, int action, int count) {

   int ur, uc, lr, lc, fg, bg;              /* Scratch variables */
   int cp, rc, mr, mc;                      /* Current Page & return code */

   if (!chk_video_state(&mr, &mc)) return(0);
   if (!wnd) return(0);
   if (wnd->hideflag) return(0);            /* Can't scroll if no visible */

   ur = wnd->urow;                          /* Get rows & cols from window */
   uc = wnd->ucol;                          /* Structure */
   lr = wnd->lrow;
   lc = wnd->lcol;
   if (action) {                            /* If action non-zero */
      ur++; uc++;                           /* scroll inside of the borders */
      lr--; lc--;
   }
   fg = wnd->attr & 0x0f;                   /* Retrieve the colors */
   bg = (wnd->attr & 0xf0) >> 4;

   cp = getpage();                          /* Save the current page*/
   setpage(wnd->page);                      /* Video Page window is in */
   re_order(wnd,NORMAL);                    /* Make the window active */
   rc = scroll(ur,uc,lr,lc,fg,bg,count);    /* Call scroll function */
   setpage(cp);                             /* Reset video page */
   return(rc);                              /* Send back return code */
}
