/*$no list *//*$no trace <<<pcwproto.h>>> */
/***********************************************************/
/* File Id.                  Pcwproto.H                    */
/* Author.                   Stan Milam.                   */
/*                                                         */
/*          (c) Copyright 1989, 1990 by Stan Milam         */
/*                                                         */
/* Comments: This file contains definitions to be used int */
/* the screen management library.  The library will support*/
/* Microsoft C V5.10, Turbo C V2.0, Power C V1.60.         */
/*                                                         */
/***********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern  int Vbump;
extern  int mpresent;
extern  int _monitor;
extern  int _adaptor;
extern  int _video_ram;

#ifdef MSC
#   define MK_FP(seg, off) ((void far *)(((long)(seg)<<16) | (off)))
#   define outportb outp
#   define inportb inp
    struct REGPACK {
        unsigned r_ax, r_bx, r_cx, r_dx, r_bp;
        unsigned r_si, r_di, r_ds, r_es, r_flags;
    };
#endif
#ifdef __ZTC__
#   define outportb outp
#   define inportb inp
    struct REGPACK {
        unsigned r_ax, r_bx, r_cx, r_dx, r_bp;
        unsigned r_si, r_di, r_ds, r_es, r_flags;
    };
#endif

#define ischar(c) ((int)(c) > -1 && (int)(c) < 256)
#define peekc(s,o)   ((char far *)((MK_FP((s),(o))))
#define peekw(a,b)   ((int  far *)((MK_FP((s),(o))))
#define pokec(s,o,v) ((char far *)((MK_FP((s),(o)))) = (char) (v)
#define pokew(s,o,v) ((int  far *)((MK_FP((s),(o)))) = (int)  (v)

#define MK_SCRNOFF(r,c) ((unsigned)(((r)-1)*Vbump)+(((c)-1)*2)+(page*pagesize))
#define MK_ATTR(fc,bc) ((((bc) << 4) | (fc)) << 8)

#ifndef WNDPTR
#  define WNDPTR void
#endif

/* Define the Text Colors */

#define BLACK         0
#define BLUE          1
#define GREEN         2
#define CYAN          3
#define RED           4
#define MAGENTA       5
#define BROWN         6
#define LIGHTGRAY     7
#define DARKGRAY      8
#define LIGHTBLUE     9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15
#define BLINK       128

/* Define the Border Types */

#define DOUBLEALL     0
#define SINGLEALL     1
#define SINGLESIDES   2
#define DOUBLESIDES   3
#define NOSIDES       4

/* Defines of Where Window Titles go */

#define TOP           0                /* Title located at top */
#define BOTTOM        1                /* Title located at botton */
#define LEFT          0                /* Left side of Window */
#define RITE          1                /* Right side of window */
#define MIDDLE        2                /* Or in the middle  */

/* Used to specify which button for the mouse */

#define LEFTM         0                /* Left Mouse Button */
#define RITEM         1                /* Rite Mouse Button */

/* Defines for Reordering the Windows */

#define NORMAL        0
#define POP           1                /* Do NOT USE!!!! */
#define PUSH          2                /* Do NOT USE!!!! */
#define HIDE          3                /* Do NOT USE!!!! */
#define SHOW          4                /* Do NOT USE!!!! */

/* Define scrolling parms */

#define DOWN          0
#define UP            1

/* Define values for monitor and adaptor */

#define MDA           1
#define CGA           2
#define EGA           3
#define VGA           4

#define MONO          0
#define COLOR         1

#define CGA200        0
#define EGA350        1
#define VGA400        2
#define EGA14        14
#define VGA16        16

/* Define values to initialize PCW with pcwinit() */

#define AUTOEXIT      1
#define NOEXIT        0

/*  Miscellaneous Defines */

#define CENTER       99                            /* qputs & wputs */
#define SPACES       32

/* Default EGA & VGA Palette */

#define DFTL_PALETTE 22

/*     Window Functions    */

WNDPTR *wpop(WNDPTR *wnd);
WNDPTR *get_active_wnd(void);
WNDPTR *wframe(int ur,int uc,int lr,int lc, int fclr, int bclr);
WNDPTR *wpush(int urow, int ucol, int lrow, int lcol);
WNDPTR *wexplode(int urow,int ucol,int lrow,int lcol,int fclr,int bclr);
int    wprintf(WNDPTR *wnd, int row, int col, char *format,...);
int    wputs(WNDPTR *wnd, int row, int col, char str[]);
int    wprints(WNDPTR *wnd,int row,int col,int fclr,int bclr,char *str);
int    wtitle(WNDPTR *wnd, int tb, int mlr, char *s);
int    whide(WNDPTR *wnd);
int    wshow(WNDPTR *wnd);
int    wndmove(WNDPTR *wnd, int row, int col);
int    w_chg_attr(WNDPTR *wnd,int row,int col,int fclr,int blclr,int cols);
int    wscroll(WNDPTR *wnd, int action, int count);
int    w_block_write(WNDPTR *wnd, int row, int col, char *block[]);
int    clr_wnd(WNDPTR *wnd, int action);
void   pcwinit(int action);
void   _pcw_exit(void);
void   re_order(WNDPTR *wnd, int attribute);

/*     Quick Screen Writing Routines     */

int  qputchar(int row, int col, int fcolor, int bcolor, unsigned char ch);
int  qfill(int urow,int ucol,int lrow,int lcol,int fcolor,int bcolor,int ch);
int  qbox(int urow, int ucol, int lrow, int lcol);
int  qvchar(int row, int col, int fcolor, int bcolor, unsigned char ch, int count);
int  qhchar(int row, int col, int fcolor, int bcolor, unsigned char ch, int count);
int  qputs (int row, int col, int fcolor, int bcolor, char *s);
int  qvputs(int row, int col, int fcolor, int bcolor, char *s);
int  qprintf(int row, int col, int fcolor, int bcolor, char *format, ...);
int  qvprintf(int row, int col, int fcolor, int bcolor, char *format, ...);
int  q_block_write(int row,int col,int fclr,int bclr, char *block[]);
int  scroll(int ur,int uc,int lr,int lc,int fg,int bg,int count);
int  chg_attr(int row, int col, int fcolor, int bcolor, int count);
int  getattr(int row, int col);
int  getchr(int row, int col);

/* Some Miscellaneous Function related to quick writes & windows */

void titlecolor(int fcolor, int bcolor);
void bordercolor(int fcolor, int bcolor);
void setborder(int type);
void set_wnd_attr(WNDPTR *wnd, int foreground, int background);

/* Miscellaneous Functions */

void _sound(unsigned freq);
void _nosound(void);
void rest(unsigned ticks);
void swait(unsigned seconds);
void far _delay(unsigned ms);
void farcopy(void far *dest, void far *srce, unsigned count);

/* Environment functions */

int  getpage(void);                         /* Gets logical CRT page */
int  getpagesize(void);                     /* Returns size of CRT page */
int  setpage(int page);                     /* Sets logical CRT page */
int  ispcwinit(void);                       /* Is the library intialized? */
int  chk_video_state(int *rw, int *cl);     /* Returns max rows & cols */
unsigned int getscrnseg(void);              /* Returns Segment of video mem */

/* BIOS dependent functions */

int  vgetattr(void);
int  vgetchr(void);
void get_cursor_size(int *tline, int *bline);
void set_cursor_size(int tline, int bline);
void get_cursor_pos(int *row, int *col);
void set_cursor_pos(int row, int col);
void switchpage(int page);
void vcls(void);
void vgetmode(int *cols, int *mode, int *activepage);
void vsetmode(int mode);

/*  Mouse Functions  */

int  init_mouse(void);
int  get_mpressed(int button);
int  get_mreleased(int button);
void show_mouse(void);
void hide_mouse(void);
void get_mpos(int *row, int *col, int *bstatus);
void set_mpos(int  row, int  col);
void mframe(int urow, int ucol, int lrow, int lcol);
void set_mtype(int ctype, int arg1, int arg2);
char *save_mouse_state(void);
void restore_mouse_state(char *buffer);

/*  Keyboard Functions */

int  keypressed(void);                      /* Was a key pressed */
int  readkey(void);                         /* Read keyboard character */
int  isxkeybd(void);                        /* Extended keyboard BIOS? */
int  keywait(int seconds);                  /* Wait or keypressed */
int  get_chars(int rw,int cl,int fc,int bc,int len,char *buffer);
int keyin(void);                           /* Read char/handles spcl keys */
void keybrd_flush(void);                    /* Flush the keyboard */

/*  EGA/VGA specific functions */

int  download_rom_font(int font, char *buffer);
int  load_user_font(int bpc,int blk,int nchars,int fchar,char *buffer);
char *get_ega_palette(int mode);
void set_palette(int preg, int color);
void load_ega_palette(void);
void set_load_palette(int preg, int color);
void fload(int block, int font);
void set_vga_scan_lines(int arg);

/* Interrupt Handlers & Such */

int  set_int24(void);
int  set_int29(void);
void reset_int29(void);

#ifdef __cplusplus
}
#endif
/*$list *//*$trace <<<pcwproto.h>>> */
