/***********************************************************/
/* File Id.                  ChgAttr.C                     */
/* Author.                   Stan Milam.                   */
/* Date Written.             03/06/89.                     */
/*                                                         */
/*            (c) Copyright 1989-90 by Stan Milam          */
/*                                                         */
/* Comments: This function will chage the color attributes */
/* starting at row & col and continue for the count of cols*/
/***********************************************************/

#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int chg_attr(int row, int col, int fclr, int bclr, int count) {

   unsigned scrnseg, offset;
   int far  *scrnptr;
   int page, attr, pagesize;
   int mx_rows, mx_cols;

   if (!chk_video_state(&mx_rows, &mx_cols)) return(0);
   if (((col - 1) + count) > mx_cols)
      count = count - (((col - 1) + count) - mx_cols);

   pagesize = getpagesize();
   scrnseg  = getscrnseg();
   page     = getpage();
   attr     = MK_ATTR(fclr,bclr);
   offset   = MK_SCRNOFF(row,col);
   scrnptr  = (int far *) MK_FP(scrnseg,offset);
   Tchg_Attr(scrnptr, count, attr);
   return(1);
}

/**********************************************************/
/*                        W_Chg_Attr                      */
/*                                                        */
/* Change the attribute at row & col inside of a window.  */
/* The change is confined inside of window boundries.     */
/**********************************************************/

int w_chg_attr(wnd, row, col, foreground, background, count)
WNDPTR *wnd;
int    row, col, foreground, background, count; {

   int mxr, mxc;

   if (!wnd) return(0);
   if (!chk_video_state(&mxr, &mxc)) return(0);
   re_order(wnd, NORMAL);

   row = wnd->urow + row;
   col = wnd->ucol + col;

   if (col >= wnd->lcol) return(0);
   if (col <= wnd->ucol) return(0);
   if (row <= wnd->urow) return(0);
   if (row >= wnd->lrow) return(0);
   if ((col + count - 1) >= wnd->lcol) return(0);

   return(chg_attr(row, col, foreground, background, count));
}

/**********************************************************/
/*                        Set_Wnd_Attr                    */
/*                                                        */
/* Changes the attribute stored in the WNDPTR structure.  */
/**********************************************************/

void set_wnd_attr(WNDPTR *wnd, int fg, int bg) {

   if (!wnd) return;
   wnd->attr = (char) ((bg << 4) | fg);
}
