/* dos.c */

#define BYTE unsigned char

#include  <stdio.h>
#include  <dos.h>

static BYTE cur_row  = 0;      /* current row */
static BYTE cur_col  = 0;      /* current col */

/* write character & attribute without advancing cursor */

void AttrWrite(ch,attr)
BYTE ch;
BYTE attr;
{union REGS  reg;
 reg.h.ah = 9;
 reg.h.bh = 0;        /* current text page */
 reg.h.al = ch;       /* character */
 reg.h.bl = attr;
 reg.x.cx = 1;
 int86(0x10, &reg, &reg);
}

/* position cursor at desired row & column */

void Position(row, col)
BYTE row, col;
{union REGS reg;
 reg.h.ah = 2;
 reg.h.bh = 0;
 reg.h.dh = row;
 reg.h.dl = col;
 int86(0x10, &reg, &reg);
 cur_row = row;
 cur_col = col;
}

/* returns the current row of the cursor */

int GetRow()
{union  REGS  reg;
 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0x10, &reg, &reg);
 return(reg.h.dh);
}

/* returns the current column of the cursor */

int GetCol()
{union  REGS  reg;
 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0x10, &reg, &reg);
 return(reg.h.dl);
}

/* scrolls area specified # rows */

void Scroll(urow, lcol, lrow, rcol, nrows, attr)
unsigned  urow;   /* upper row of area */
unsigned  lcol;   /* left column of area */
unsigned  lrow;   /* lower row of area */
unsigned  rcol;   /* right column of area */
int nrows;        /* # rows to scroll */
int attr;         /* attribute to use for blank lines */
{union REGS reg;
 reg.h.ah = 6;
 reg.h.ch = urow;
 reg.h.cl = lcol;
 reg.h.al = nrows;
 reg.h.bh = attr;
 reg.h.dh = lrow;
 reg.h.dl = rcol;
 int86(0x10, &reg, &reg);
}